/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.net;

import com.datadog.android.core.internal.net.FirstPartyHostHeaderTypeResolver;
import com.datadog.android.lint.InternalApi;
import com.datadog.android.trace.TracingHeaderType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\f\u001a\u00020\r2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ'\u0010\u0010\u001a\u00020\r2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0000\u00a2\u0006\u0002\b\u0012J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016RB\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/datadog/android/core/internal/net/DefaultFirstPartyHostHeaderTypeResolver;", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "hosts", "", "", "", "Lcom/datadog/android/trace/TracingHeaderType;", "(Ljava/util/Map;)V", "<set-?>", "knownHosts", "getKnownHosts$dd_sdk_android_core_release", "()Ljava/util/Map;", "addKnownHosts", "", "", "addKnownHosts$dd_sdk_android_core_release", "addKnownHostsWithHeaderTypes", "hostsWithHeaderTypes", "addKnownHostsWithHeaderTypes$dd_sdk_android_core_release", "getAllHeaderTypes", "headerTypesForUrl", "url", "Lokhttp3/HttpUrl;", "isEmpty", "", "isFirstPartyUrl", "dd-sdk-android-core_release"})
@InternalApi
@SourceDebugExtension(value={"SMAP\nDefaultFirstPartyHostHeaderTypeResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultFirstPartyHostHeaderTypeResolver.kt\ncom/datadog/android/core/internal/net/DefaultFirstPartyHostHeaderTypeResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1179#2,2:86\n1253#2,4:88\n1747#2,3:92\n288#2,2:95\n1179#2,2:97\n1253#2,4:99\n1179#2,2:103\n1253#2,4:105\n*S KotlinDebug\n*F\n+ 1 DefaultFirstPartyHostHeaderTypeResolver.kt\ncom/datadog/android/core/internal/net/DefaultFirstPartyHostHeaderTypeResolver\n*L\n25#1:86,2\n25#1:88,4\n31#1:92,3\n53#1:95,2\n69#1:97,2\n69#1:99,4\n80#1:103,2\n80#1:105,4\n*E\n"})
public final class DefaultFirstPartyHostHeaderTypeResolver
implements FirstPartyHostHeaderTypeResolver {
    @NotNull
    private Map<String, ? extends Set<? extends TracingHeaderType>> knownHosts;

    /*
     * WARNING - void declaration
     */
    public DefaultFirstPartyHostHeaderTypeResolver(@NotNull Map<String, ? extends Set<? extends TracingHeaderType>> hosts) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(hosts, (String)"hosts");
        Iterable iterable = hosts.entrySet();
        DefaultFirstPartyHostHeaderTypeResolver defaultFirstPartyHostHeaderTypeResolver = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String string = (String)it.getKey();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            Pair pair = TuplesKt.to((Object)string2, it.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        defaultFirstPartyHostHeaderTypeResolver.knownHosts = destination$iv$iv;
    }

    @NotNull
    public final Map<String, Set<TracingHeaderType>> getKnownHosts$dd_sdk_android_core_release() {
        return this.knownHosts;
    }

    @Override
    public boolean isFirstPartyUrl(@NotNull HttpUrl url) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            String host = url.host();
            Iterable $this$any$iv = this.knownHosts.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it, (Object)"*") || Intrinsics.areEqual((Object)host, (Object)it) || StringsKt.endsWith$default((String)host, (String)("." + it), (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean isFirstPartyUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpUrl httpUrl = HttpUrl.Companion.parse(url);
        if (httpUrl == null) {
            return false;
        }
        HttpUrl httpUrl2 = httpUrl;
        return this.isFirstPartyUrl(httpUrl2);
    }

    @Override
    @NotNull
    public Set<TracingHeaderType> headerTypesForUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpUrl httpUrl = HttpUrl.Companion.parse(url);
        if (httpUrl == null) {
            return SetsKt.emptySet();
        }
        HttpUrl httpUrl2 = httpUrl;
        return this.headerTypesForUrl(httpUrl2);
    }

    @Override
    @NotNull
    public Set<TracingHeaderType> headerTypesForUrl(@NotNull HttpUrl url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String host = url.host();
        Set set = this.knownHosts.get(host);
        if (set == null) {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = this.knownHosts.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!StringsKt.endsWith$default((String)host, (String)("." + it.getKey()), (boolean)false, (int)2, null)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            Map.Entry entry = v1;
            set = entry != null ? (Set)entry.getValue() : null;
            if (set == null && (set = this.knownHosts.get("*")) == null) {
                set = SetsKt.emptySet();
            }
        }
        return set;
    }

    @Override
    @NotNull
    public Set<TracingHeaderType> getAllHeaderTypes() {
        return CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)this.knownHosts.values()));
    }

    @Override
    public boolean isEmpty() {
        return this.knownHosts.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final void addKnownHosts$dd_sdk_android_core_release(@NotNull List<String> hosts) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(hosts, (String)"hosts");
        Iterable iterable = hosts;
        Map<String, ? extends Set<? extends TracingHeaderType>> map = this.knownHosts;
        DefaultFirstPartyHostHeaderTypeResolver defaultFirstPartyHostHeaderTypeResolver = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            TracingHeaderType[] it = (TracingHeaderType[])element$iv$iv;
            boolean bl = false;
            TracingHeaderType[] tracingHeaderTypeArray = it;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string = tracingHeaderTypeArray.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            tracingHeaderTypeArray = new TracingHeaderType[]{TracingHeaderType.DATADOG, TracingHeaderType.TRACECONTEXT};
            Pair pair = TuplesKt.to((Object)string, (Object)SetsKt.setOf((Object[])tracingHeaderTypeArray));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map map3 = destination$iv$iv;
        defaultFirstPartyHostHeaderTypeResolver.knownHosts = MapsKt.plus(map, (Map)map3);
    }

    /*
     * WARNING - void declaration
     */
    public final void addKnownHostsWithHeaderTypes$dd_sdk_android_core_release(@NotNull Map<String, ? extends Set<? extends TracingHeaderType>> hostsWithHeaderTypes) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(hostsWithHeaderTypes, (String)"hostsWithHeaderTypes");
        Iterable iterable = hostsWithHeaderTypes.entrySet();
        Map<String, ? extends Set<? extends TracingHeaderType>> map = this.knownHosts;
        DefaultFirstPartyHostHeaderTypeResolver defaultFirstPartyHostHeaderTypeResolver = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String string = (String)it.getKey();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            Pair pair = TuplesKt.to((Object)string2, it.getValue());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map map3 = destination$iv$iv;
        defaultFirstPartyHostHeaderTypeResolver.knownHosts = MapsKt.plus(map, (Map)map3);
    }
}

