/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence;

import androidx.annotation.AnyThread;
import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.EventType;
import com.datadog.android.api.storage.FeatureStorageConfiguration;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.core.internal.metrics.RemovalReason;
import com.datadog.android.core.internal.persistence.BatchData;
import com.datadog.android.core.internal.persistence.BatchId;
import com.datadog.android.core.internal.persistence.Storage;
import com.datadog.android.core.internal.privacy.ConsentProvider;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.core.persistence.NoOpPersistenceStrategy;
import com.datadog.android.core.persistence.PersistenceStrategy;
import com.datadog.android.privacy.TrackingConsent;
import com.datadog.android.privacy.TrackingConsentProviderCallback;
import java.util.concurrent.ExecutorService;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B?\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0017J\b\u0010)\u001a\u00020\"H\u0017J\u0018\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0016J\n\u0010.\u001a\u0004\u0018\u00010/H\u0017J\b\u00100\u001a\u00020\u0012H\u0003J,\u00101\u001a\u00020\"2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020(2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\"06H\u0017R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0016\u001a\u0004\b\u0019\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00068"}, d2={"Lcom/datadog/android/core/internal/persistence/AbstractStorage;", "Lcom/datadog/android/core/internal/persistence/Storage;", "Lcom/datadog/android/privacy/TrackingConsentProviderCallback;", "sdkCoreId", "", "featureName", "persistenceStrategyFactory", "Lcom/datadog/android/core/persistence/PersistenceStrategy$Factory;", "executorService", "Ljava/util/concurrent/ExecutorService;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "storageConfiguration", "Lcom/datadog/android/api/storage/FeatureStorageConfiguration;", "consentProvider", "Lcom/datadog/android/core/internal/privacy/ConsentProvider;", "(Ljava/lang/String;Ljava/lang/String;Lcom/datadog/android/core/persistence/PersistenceStrategy$Factory;Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/api/storage/FeatureStorageConfiguration;Lcom/datadog/android/core/internal/privacy/ConsentProvider;)V", "grantedPersistenceStrategy", "Lcom/datadog/android/core/persistence/PersistenceStrategy;", "getGrantedPersistenceStrategy", "()Lcom/datadog/android/core/persistence/PersistenceStrategy;", "grantedPersistenceStrategy$delegate", "Lkotlin/Lazy;", "notGrantedPersistenceStrategy", "pendingPersistenceStrategy", "getPendingPersistenceStrategy", "pendingPersistenceStrategy$delegate", "getPersistenceStrategyFactory$dd_sdk_android_core_release", "()Lcom/datadog/android/core/persistence/PersistenceStrategy$Factory;", "getSdkCoreId$dd_sdk_android_core_release", "()Ljava/lang/String;", "getStorageConfiguration$dd_sdk_android_core_release", "()Lcom/datadog/android/api/storage/FeatureStorageConfiguration;", "confirmBatchRead", "", "batchId", "Lcom/datadog/android/core/internal/persistence/BatchId;", "removalReason", "Lcom/datadog/android/core/internal/metrics/RemovalReason;", "deleteBatch", "", "dropAll", "onConsentUpdated", "previousConsent", "Lcom/datadog/android/privacy/TrackingConsent;", "newConsent", "readNextBatch", "Lcom/datadog/android/core/internal/persistence/BatchData;", "resolvePersistenceStrategy", "writeCurrentBatch", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "forceNewBatch", "callback", "Lkotlin/Function1;", "Lcom/datadog/android/api/storage/EventBatchWriter;", "dd-sdk-android-core_release"})
public final class AbstractStorage
implements Storage,
TrackingConsentProviderCallback {
    @Nullable
    private final String sdkCoreId;
    @NotNull
    private final String featureName;
    @NotNull
    private final PersistenceStrategy.Factory persistenceStrategyFactory;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final FeatureStorageConfiguration storageConfiguration;
    @NotNull
    private final ConsentProvider consentProvider;
    @NotNull
    private final Lazy grantedPersistenceStrategy$delegate;
    @NotNull
    private final Lazy pendingPersistenceStrategy$delegate;
    @NotNull
    private final PersistenceStrategy notGrantedPersistenceStrategy;

    public AbstractStorage(@Nullable String sdkCoreId, @NotNull String featureName, @NotNull PersistenceStrategy.Factory persistenceStrategyFactory, @NotNull ExecutorService executorService, @NotNull InternalLogger internalLogger, @NotNull FeatureStorageConfiguration storageConfiguration, @NotNull ConsentProvider consentProvider) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter((Object)persistenceStrategyFactory, (String)"persistenceStrategyFactory");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)storageConfiguration, (String)"storageConfiguration");
        Intrinsics.checkNotNullParameter((Object)consentProvider, (String)"consentProvider");
        this.sdkCoreId = sdkCoreId;
        this.featureName = featureName;
        this.persistenceStrategyFactory = persistenceStrategyFactory;
        this.executorService = executorService;
        this.internalLogger = internalLogger;
        this.storageConfiguration = storageConfiguration;
        this.consentProvider = consentProvider;
        this.grantedPersistenceStrategy$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PersistenceStrategy>(this){
            final /* synthetic */ AbstractStorage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PersistenceStrategy invoke() {
                return this.this$0.getPersistenceStrategyFactory$dd_sdk_android_core_release().create(this.this$0.getSdkCoreId$dd_sdk_android_core_release() + "/" + AbstractStorage.access$getFeatureName$p(this.this$0) + "/" + TrackingConsent.GRANTED, this.this$0.getStorageConfiguration$dd_sdk_android_core_release().getMaxItemsPerBatch(), this.this$0.getStorageConfiguration$dd_sdk_android_core_release().getMaxBatchSize());
            }
        }));
        this.pendingPersistenceStrategy$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PersistenceStrategy>(this){
            final /* synthetic */ AbstractStorage this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PersistenceStrategy invoke() {
                return this.this$0.getPersistenceStrategyFactory$dd_sdk_android_core_release().create(this.this$0.getSdkCoreId$dd_sdk_android_core_release() + "/" + AbstractStorage.access$getFeatureName$p(this.this$0) + "/" + TrackingConsent.PENDING, this.this$0.getStorageConfiguration$dd_sdk_android_core_release().getMaxItemsPerBatch(), this.this$0.getStorageConfiguration$dd_sdk_android_core_release().getMaxBatchSize());
            }
        }));
        this.notGrantedPersistenceStrategy = new NoOpPersistenceStrategy();
        this.consentProvider.registerCallback(this);
    }

    @Nullable
    public final String getSdkCoreId$dd_sdk_android_core_release() {
        return this.sdkCoreId;
    }

    @NotNull
    public final PersistenceStrategy.Factory getPersistenceStrategyFactory$dd_sdk_android_core_release() {
        return this.persistenceStrategyFactory;
    }

    @NotNull
    public final FeatureStorageConfiguration getStorageConfiguration$dd_sdk_android_core_release() {
        return this.storageConfiguration;
    }

    private final PersistenceStrategy getGrantedPersistenceStrategy() {
        Lazy lazy = this.grantedPersistenceStrategy$delegate;
        return (PersistenceStrategy)lazy.getValue();
    }

    private final PersistenceStrategy getPendingPersistenceStrategy() {
        Lazy lazy = this.pendingPersistenceStrategy$delegate;
        return (PersistenceStrategy)lazy.getValue();
    }

    @Override
    @AnyThread
    public void writeCurrentBatch(@NotNull DatadogContext datadogContext, boolean forceNewBatch, @NotNull Function1<? super EventBatchWriter, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ConcurrencyExtKt.submitSafe(this.executorService, "Data write", this.internalLogger, () -> AbstractStorage.writeCurrentBatch$lambda$0(this, callback));
    }

    @WorkerThread
    private final PersistenceStrategy resolvePersistenceStrategy() {
        PersistenceStrategy persistenceStrategy;
        switch (WhenMappings.$EnumSwitchMapping$0[this.consentProvider.getConsent().ordinal()]) {
            case 1: {
                persistenceStrategy = this.getGrantedPersistenceStrategy();
                break;
            }
            case 2: {
                persistenceStrategy = this.getPendingPersistenceStrategy();
                break;
            }
            case 3: {
                persistenceStrategy = this.notGrantedPersistenceStrategy;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return persistenceStrategy;
    }

    @Override
    @WorkerThread
    @Nullable
    public BatchData readNextBatch() {
        BatchData batchData;
        PersistenceStrategy.Batch batch = this.getGrantedPersistenceStrategy().lockAndReadNext();
        if (batch != null) {
            PersistenceStrategy.Batch it = batch;
            boolean bl = false;
            batchData = new BatchData(new BatchId(it.getBatchId()), it.getEvents(), it.getMetadata());
        } else {
            batchData = null;
        }
        return batchData;
    }

    @Override
    @WorkerThread
    public void confirmBatchRead(@NotNull BatchId batchId, @NotNull RemovalReason removalReason, boolean deleteBatch) {
        Intrinsics.checkNotNullParameter((Object)batchId, (String)"batchId");
        Intrinsics.checkNotNullParameter((Object)removalReason, (String)"removalReason");
        if (deleteBatch) {
            this.getGrantedPersistenceStrategy().unlockAndDelete(batchId.getId());
        } else {
            this.getGrantedPersistenceStrategy().unlockAndKeep(batchId.getId());
        }
    }

    @Override
    @AnyThread
    public void dropAll() {
        ConcurrencyExtKt.submitSafe(this.executorService, "Data drop", this.internalLogger, () -> AbstractStorage.dropAll$lambda$2(this));
    }

    @Override
    public void onConsentUpdated(@NotNull TrackingConsent previousConsent, @NotNull TrackingConsent newConsent) {
        Intrinsics.checkNotNullParameter((Object)((Object)previousConsent), (String)"previousConsent");
        Intrinsics.checkNotNullParameter((Object)((Object)newConsent), (String)"newConsent");
        ConcurrencyExtKt.submitSafe(this.executorService, "Data migration", this.internalLogger, () -> AbstractStorage.onConsentUpdated$lambda$3(previousConsent, newConsent, this));
    }

    private static final void writeCurrentBatch$lambda$0(AbstractStorage this$0, Function1 $callback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        PersistenceStrategy strategy = this$0.resolvePersistenceStrategy();
        EventBatchWriter writer2 = new EventBatchWriter(strategy){
            final /* synthetic */ PersistenceStrategy $strategy;
            {
                this.$strategy = $strategy;
            }

            @WorkerThread
            @Nullable
            public byte[] currentMetadata() {
                return this.$strategy.currentMetadata();
            }

            @WorkerThread
            public boolean write(@NotNull RawBatchEvent event, @Nullable byte[] batchMetadata, @NotNull EventType eventType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
                return this.$strategy.write(event, batchMetadata, eventType);
            }
        };
        $callback.invoke((Object)writer2);
    }

    private static final void dropAll$lambda$2(AbstractStorage this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getGrantedPersistenceStrategy().dropAll();
        this$0.getPendingPersistenceStrategy().dropAll();
    }

    private static final void onConsentUpdated$lambda$3(TrackingConsent $previousConsent, TrackingConsent $newConsent, AbstractStorage this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)$previousConsent), (String)"$previousConsent");
        Intrinsics.checkNotNullParameter((Object)((Object)$newConsent), (String)"$newConsent");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($previousConsent == TrackingConsent.PENDING) {
            switch (WhenMappings.$EnumSwitchMapping$0[$newConsent.ordinal()]) {
                case 1: {
                    this$0.getPendingPersistenceStrategy().migrateData(this$0.getGrantedPersistenceStrategy());
                    break;
                }
                case 3: {
                    this$0.getPendingPersistenceStrategy().dropAll();
                }
            }
        }
    }

    public static final /* synthetic */ String access$getFeatureName$p(AbstractStorage $this) {
        return $this.featureName;
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackingConsent.values().length];
            try {
                nArray[TrackingConsent.GRANTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackingConsent.PENDING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackingConsent.NOT_GRANTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

