/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence;

import androidx.annotation.AnyThread;
import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.core.internal.metrics.MetricsDispatcher;
import com.datadog.android.core.internal.metrics.RemovalReason;
import com.datadog.android.core.internal.persistence.BatchData;
import com.datadog.android.core.internal.persistence.BatchId;
import com.datadog.android.core.internal.persistence.FileEventBatchWriter;
import com.datadog.android.core.internal.persistence.NoOpEventBatchWriter;
import com.datadog.android.core.internal.persistence.Storage;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FileMover;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.FilePersistenceConfig;
import com.datadog.android.core.internal.persistence.file.FileReaderWriter;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileReaderWriter;
import com.datadog.android.core.internal.privacy.ConsentProvider;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.core.metrics.MethodCallSamplingRate;
import com.datadog.android.core.metrics.PerformanceMetric;
import com.datadog.android.core.metrics.TelemetryMetricType;
import com.datadog.android.privacy.TrackingConsent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 >2\u00020\u0001:\u0002=>B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0017J\u0018\u0010(\u001a\u00020#2\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020'H\u0003J\"\u0010(\u001a\u00020#2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010+\u001a\u00020'H\u0003J\u0018\u0010/\u001a\u00020#2\u0006\u0010,\u001a\u00020-2\u0006\u0010+\u001a\u00020'H\u0003J\u0010\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020-H\u0003J\b\u00102\u001a\u00020#H\u0017J\n\u00103\u001a\u0004\u0018\u000104H\u0017J\n\u00105\u001a\u0004\u0018\u00010\u0005H\u0003J,\u00106\u001a\u00020#2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020)2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020#0;H\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/datadog/android/core/internal/persistence/ConsentAwareStorage;", "Lcom/datadog/android/core/internal/persistence/Storage;", "executorService", "Ljava/util/concurrent/ExecutorService;", "grantedOrchestrator", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "pendingOrchestrator", "batchEventsReaderWriter", "Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReaderWriter;", "batchMetadataReaderWriter", "Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;", "fileMover", "Lcom/datadog/android/core/internal/persistence/file/FileMover;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "filePersistenceConfig", "Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "metricsDispatcher", "Lcom/datadog/android/core/internal/metrics/MetricsDispatcher;", "consentProvider", "Lcom/datadog/android/core/internal/privacy/ConsentProvider;", "featureName", "", "(Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReaderWriter;Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;Lcom/datadog/android/core/internal/persistence/file/FileMover;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;Lcom/datadog/android/core/internal/metrics/MetricsDispatcher;Lcom/datadog/android/core/internal/privacy/ConsentProvider;Ljava/lang/String;)V", "getFilePersistenceConfig$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "getGrantedOrchestrator$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "lockedBatches", "", "Lcom/datadog/android/core/internal/persistence/ConsentAwareStorage$Batch;", "getPendingOrchestrator$dd_sdk_android_core_release", "writeLock", "", "confirmBatchRead", "", "batchId", "Lcom/datadog/android/core/internal/persistence/BatchId;", "removalReason", "Lcom/datadog/android/core/internal/metrics/RemovalReason;", "deleteBatch", "", "batch", "reason", "batchFile", "Ljava/io/File;", "metaFile", "deleteBatchFile", "deleteBatchMetadataFile", "metadataFile", "dropAll", "readNextBatch", "Lcom/datadog/android/core/internal/persistence/BatchData;", "resolveOrchestrator", "writeCurrentBatch", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "forceNewBatch", "callback", "Lkotlin/Function1;", "Lcom/datadog/android/api/storage/EventBatchWriter;", "Batch", "Companion", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nConsentAwareStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsentAwareStorage.kt\ncom/datadog/android/core/internal/persistence/ConsentAwareStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,213:1\n1549#2:214\n1620#2,3:215\n288#2,2:218\n1855#2,2:220\n1855#2,2:223\n13309#3:222\n13310#3:225\n*S KotlinDebug\n*F\n+ 1 ConsentAwareStorage.kt\ncom/datadog/android/core/internal/persistence/ConsentAwareStorage\n*L\n102#1:214\n102#1:215,3\n128#1:218,2\n144#1:220,2\n150#1:223,2\n149#1:222\n149#1:225\n*E\n"})
public final class ConsentAwareStorage
implements Storage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final FileOrchestrator grantedOrchestrator;
    @NotNull
    private final FileOrchestrator pendingOrchestrator;
    @NotNull
    private final BatchFileReaderWriter batchEventsReaderWriter;
    @NotNull
    private final FileReaderWriter batchMetadataReaderWriter;
    @NotNull
    private final FileMover fileMover;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final FilePersistenceConfig filePersistenceConfig;
    @NotNull
    private final MetricsDispatcher metricsDispatcher;
    @NotNull
    private final ConsentProvider consentProvider;
    @NotNull
    private final String featureName;
    @NotNull
    private final Set<Batch> lockedBatches;
    @NotNull
    private final Object writeLock;
    @NotNull
    public static final String WARNING_DELETE_FAILED = "Unable to delete file: %s";

    public ConsentAwareStorage(@NotNull ExecutorService executorService, @NotNull FileOrchestrator grantedOrchestrator, @NotNull FileOrchestrator pendingOrchestrator, @NotNull BatchFileReaderWriter batchEventsReaderWriter, @NotNull FileReaderWriter batchMetadataReaderWriter, @NotNull FileMover fileMover, @NotNull InternalLogger internalLogger, @NotNull FilePersistenceConfig filePersistenceConfig, @NotNull MetricsDispatcher metricsDispatcher, @NotNull ConsentProvider consentProvider, @NotNull String featureName) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)grantedOrchestrator, (String)"grantedOrchestrator");
        Intrinsics.checkNotNullParameter((Object)pendingOrchestrator, (String)"pendingOrchestrator");
        Intrinsics.checkNotNullParameter((Object)batchEventsReaderWriter, (String)"batchEventsReaderWriter");
        Intrinsics.checkNotNullParameter((Object)batchMetadataReaderWriter, (String)"batchMetadataReaderWriter");
        Intrinsics.checkNotNullParameter((Object)fileMover, (String)"fileMover");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)filePersistenceConfig, (String)"filePersistenceConfig");
        Intrinsics.checkNotNullParameter((Object)metricsDispatcher, (String)"metricsDispatcher");
        Intrinsics.checkNotNullParameter((Object)consentProvider, (String)"consentProvider");
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        this.executorService = executorService;
        this.grantedOrchestrator = grantedOrchestrator;
        this.pendingOrchestrator = pendingOrchestrator;
        this.batchEventsReaderWriter = batchEventsReaderWriter;
        this.batchMetadataReaderWriter = batchMetadataReaderWriter;
        this.fileMover = fileMover;
        this.internalLogger = internalLogger;
        this.filePersistenceConfig = filePersistenceConfig;
        this.metricsDispatcher = metricsDispatcher;
        this.consentProvider = consentProvider;
        this.featureName = featureName;
        this.lockedBatches = new LinkedHashSet();
        this.writeLock = new Object();
    }

    @NotNull
    public final FileOrchestrator getGrantedOrchestrator$dd_sdk_android_core_release() {
        return this.grantedOrchestrator;
    }

    @NotNull
    public final FileOrchestrator getPendingOrchestrator$dd_sdk_android_core_release() {
        return this.pendingOrchestrator;
    }

    @NotNull
    public final FilePersistenceConfig getFilePersistenceConfig$dd_sdk_android_core_release() {
        return this.filePersistenceConfig;
    }

    @Override
    @WorkerThread
    public void writeCurrentBatch(@NotNull DatadogContext datadogContext, boolean forceNewBatch, @NotNull Function1<? super EventBatchWriter, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        String string = ConsentAwareStorage.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ConsentAwareStorage::class.java.name");
        PerformanceMetric metric = this.internalLogger.startPerformanceMeasure(string, TelemetryMetricType.MethodCalled, MethodCallSamplingRate.RARE.getRate(), "writeCurrentBatch[" + this.featureName + "]");
        ConcurrencyExtKt.submitSafe(this.executorService, "Data write", this.internalLogger, () -> ConsentAwareStorage.writeCurrentBatch$lambda$1(this, callback, metric, forceNewBatch));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @WorkerThread
    @Nullable
    public BatchData readNextBatch() {
        Pair pair;
        Set<Batch> set = this.lockedBatches;
        synchronized (set) {
            File file;
            block5: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                boolean bl = false;
                Iterable iterable = this.lockedBatches;
                FileOrchestrator fileOrchestrator = this.grantedOrchestrator;
                boolean $i$f$map = false;
                void var8_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Batch batch = (Batch)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getFile());
                }
                if (fileOrchestrator.getReadableFile(CollectionsKt.toSet((Iterable)((List)destination$iv$iv))) != null) break block5;
                BatchData batchData = null;
                return batchData;
            }
            File batchFile = file;
            File metaFile = this.grantedOrchestrator.getMetadataFile(batchFile);
            this.lockedBatches.add(new Batch(batchFile, metaFile));
            pair = TuplesKt.to((Object)batchFile, (Object)metaFile);
        }
        Pair pair2 = pair;
        File batchFile = (File)pair2.component1();
        File metaFile = (File)pair2.component2();
        BatchId batchId = BatchId.Companion.fromFile(batchFile);
        byte[] batchMetadata = metaFile == null || !FileExtKt.existsSafe(metaFile, this.internalLogger) ? null : (byte[])this.batchMetadataReaderWriter.readData(metaFile);
        List<RawBatchEvent> batchData = this.batchEventsReaderWriter.readData(batchFile);
        return new BatchData(batchId, batchData, batchMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void confirmBatchRead(@NotNull BatchId batchId, @NotNull RemovalReason removalReason, boolean deleteBatch) {
        Batch batch;
        Intrinsics.checkNotNullParameter((Object)batchId, (String)"batchId");
        Intrinsics.checkNotNullParameter((Object)removalReason, (String)"removalReason");
        Set<Batch> set = this.lockedBatches;
        synchronized (set) {
            Object v0;
            block9: {
                boolean bl = false;
                Iterable $this$firstOrNull$iv = this.lockedBatches;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Batch it = (Batch)element$iv;
                    boolean bl2 = false;
                    if (!batchId.matchesFile(it.getFile())) continue;
                    v0 = element$iv;
                    break block9;
                }
                v0 = null;
            }
            Batch batch2 = v0;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl21 : MonitorExitStatement: MONITOREXIT : var6_4
            batch = batch2;
        }
        if (batch == null) {
            return;
        }
        Batch batch3 = batch;
        if (deleteBatch) {
            this.deleteBatch(batch3, removalReason);
        }
        Set<Batch> set2 = this.lockedBatches;
        synchronized (set2) {
            boolean bl = false;
            boolean bl3 = this.lockedBatches.remove(batch3);
        }
    }

    @Override
    @AnyThread
    public void dropAll() {
        ConcurrencyExtKt.submitSafe(this.executorService, "ConsentAwareStorage.dropAll", this.internalLogger, () -> ConsentAwareStorage.dropAll$lambda$11(this));
    }

    @WorkerThread
    private final FileOrchestrator resolveOrchestrator() {
        FileOrchestrator fileOrchestrator;
        TrackingConsent consent = this.consentProvider.getConsent();
        switch (WhenMappings.$EnumSwitchMapping$0[consent.ordinal()]) {
            case 1: {
                fileOrchestrator = this.grantedOrchestrator;
                break;
            }
            case 2: {
                fileOrchestrator = this.pendingOrchestrator;
                break;
            }
            case 3: {
                fileOrchestrator = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fileOrchestrator;
    }

    @WorkerThread
    private final void deleteBatch(Batch batch, RemovalReason reason) {
        this.deleteBatch(batch.getFile(), batch.getMetaFile(), reason);
    }

    @WorkerThread
    private final void deleteBatch(File batchFile, File metaFile, RemovalReason reason) {
        this.deleteBatchFile(batchFile, reason);
        File file = metaFile;
        boolean bl = file != null ? FileExtKt.existsSafe(file, this.internalLogger) : false;
        if (bl) {
            this.deleteBatchMetadataFile(metaFile);
        }
    }

    @WorkerThread
    private final void deleteBatchFile(File batchFile, RemovalReason reason) {
        boolean result = this.fileMover.delete(batchFile);
        if (result) {
            this.metricsDispatcher.sendBatchDeletedMetric(batchFile, reason);
        } else {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, (Function0)new Function0<String>(batchFile){
                final /* synthetic */ File $batchFile;
                {
                    this.$batchFile = $batchFile;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Unable to delete file: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$batchFile.getPath()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }, null, false, null, 56, null);
        }
    }

    @WorkerThread
    private final void deleteBatchMetadataFile(File metadataFile) {
        boolean result = this.fileMover.delete(metadataFile);
        if (!result) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, (Function0)new Function0<String>(metadataFile){
                final /* synthetic */ File $metadataFile;
                {
                    this.$metadataFile = $metadataFile;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Unable to delete file: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$metadataFile.getPath()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }, null, false, null, 56, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeCurrentBatch$lambda$1(ConsentAwareStorage this$0, Function1 $callback, PerformanceMetric $metric, boolean $forceNewBatch) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        FileOrchestrator orchestrator = this$0.resolveOrchestrator();
        if (orchestrator == null) {
            $callback.invoke((Object)new NoOpEventBatchWriter());
            PerformanceMetric performanceMetric = $metric;
            if (performanceMetric != null) {
                performanceMetric.stopAndSend(false);
            }
            return;
        }
        Object object = this$0.writeLock;
        synchronized (object) {
            boolean bl = false;
            File batchFile = orchestrator.getWritableFile($forceNewBatch);
            File metadataFile = batchFile != null ? orchestrator.getMetadataFile(batchFile) : null;
            EventBatchWriter writer2 = batchFile == null ? (EventBatchWriter)new NoOpEventBatchWriter() : (EventBatchWriter)new FileEventBatchWriter(batchFile, metadataFile, this$0.batchEventsReaderWriter, this$0.batchMetadataReaderWriter, this$0.filePersistenceConfig, this$0.internalLogger);
            $callback.invoke((Object)writer2);
            PerformanceMetric performanceMetric = $metric;
            if (performanceMetric != null) {
                performanceMetric.stopAndSend(!(writer2 instanceof NoOpEventBatchWriter));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void dropAll$lambda$11(ConsentAwareStorage this$0) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Set<Batch> set = this$0.lockedBatches;
        synchronized (set) {
            boolean bl = false;
            Iterable $this$forEach$iv2 = this$0.lockedBatches;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                Batch it = (Batch)element$iv;
                boolean bl2 = false;
                this$0.deleteBatch(it, RemovalReason.Flushed.INSTANCE);
            }
            this$0.lockedBatches.clear();
            Unit unit = Unit.INSTANCE;
        }
        FileOrchestrator[] fileOrchestratorArray = new FileOrchestrator[]{this$0.pendingOrchestrator, this$0.grantedOrchestrator};
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void orchestrator = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Iterable $this$forEach$iv3 = orchestrator.getAllFiles();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                File it = (File)element$iv2;
                boolean bl3 = false;
                File metaFile = orchestrator.getMetadataFile(it);
                this$0.deleteBatch(it, metaFile, RemovalReason.Flushed.INSTANCE);
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/datadog/android/core/internal/persistence/ConsentAwareStorage$Batch;", "", "file", "Ljava/io/File;", "metaFile", "(Ljava/io/File;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "getMetaFile", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "dd-sdk-android-core_release"})
    private static final class Batch {
        @NotNull
        private final File file;
        @Nullable
        private final File metaFile;

        public Batch(@NotNull File file, @Nullable File metaFile) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.metaFile = metaFile;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @Nullable
        public final File getMetaFile() {
            return this.metaFile;
        }

        @NotNull
        public final File component1() {
            return this.file;
        }

        @Nullable
        public final File component2() {
            return this.metaFile;
        }

        @NotNull
        public final Batch copy(@NotNull File file, @Nullable File metaFile) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new Batch(file, metaFile);
        }

        public static /* synthetic */ Batch copy$default(Batch batch, File file, File file2, int n, Object object) {
            if ((n & 1) != 0) {
                file = batch.file;
            }
            if ((n & 2) != 0) {
                file2 = batch.metaFile;
            }
            return batch.copy(file, file2);
        }

        @NotNull
        public String toString() {
            return "Batch(file=" + this.file + ", metaFile=" + this.metaFile + ")";
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = result * 31 + (this.metaFile == null ? 0 : this.metaFile.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Batch)) {
                return false;
            }
            Batch batch = (Batch)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)batch.file)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.metaFile, (Object)batch.metaFile);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/persistence/ConsentAwareStorage$Companion;", "", "()V", "WARNING_DELETE_FAILED", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackingConsent.values().length];
            try {
                nArray[TrackingConsent.GRANTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackingConsent.PENDING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackingConsent.NOT_GRANTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

