/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.persistence.Deserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \t2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\tB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/core/internal/persistence/JsonObjectDeserializer;", "Lcom/datadog/android/core/internal/persistence/Deserializer;", "", "Lcom/google/gson/JsonObject;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/InternalLogger;)V", "deserialize", "model", "Companion", "dd-sdk-android-core_release"})
public final class JsonObjectDeserializer
implements Deserializer<String, JsonObject> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String DESERIALIZE_ERROR_MESSAGE_FORMAT = "Error while trying to deserialize the RumEvent: %s";

    public JsonObjectDeserializer(@NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
    }

    @Override
    @Nullable
    public JsonObject deserialize(@NotNull String model) {
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        try {
            jsonObject = JsonParser.parseString((String)model).getAsJsonObject();
        }
        catch (JsonParseException jpe) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(model){
                final /* synthetic */ String $model;
                {
                    this.$model = $model;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Error while trying to deserialize the RumEvent: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$model};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }, (Throwable)jpe, false, null, 48, null);
            jsonObject = null;
        }
        catch (IllegalStateException ise) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(model){
                final /* synthetic */ String $model;
                {
                    this.$model = $model;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Error while trying to deserialize the RumEvent: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$model};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }, (Throwable)ise, false, null, 48, null);
            jsonObject = null;
        }
        return jsonObject;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/persistence/JsonObjectDeserializer$Companion;", "", "()V", "DESERIALIZE_ERROR_MESSAGE_FORMAT", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

