/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.datastore;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.storage.datastore.DataStoreHandler;
import com.datadog.android.api.storage.datastore.DataStoreReadCallback;
import com.datadog.android.api.storage.datastore.DataStoreWriteCallback;
import com.datadog.android.core.internal.persistence.Deserializer;
import com.datadog.android.core.internal.persistence.datastore.DatastoreFileReader;
import com.datadog.android.core.internal.persistence.datastore.DatastoreFileWriter;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.core.persistence.Serializer;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016JG\u0010\u0012\u001a\u00020\f\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u0002H\u00132\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJK\u0010\u001b\u001a\u00020\f\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00130\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\u00130\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/datadog/android/core/internal/persistence/datastore/DataStoreFileHandler;", "Lcom/datadog/android/api/storage/datastore/DataStoreHandler;", "executorService", "Ljava/util/concurrent/ExecutorService;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "dataStoreFileReader", "Lcom/datadog/android/core/internal/persistence/datastore/DatastoreFileReader;", "datastoreFileWriter", "Lcom/datadog/android/core/internal/persistence/datastore/DatastoreFileWriter;", "(Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/core/internal/persistence/datastore/DatastoreFileReader;Lcom/datadog/android/core/internal/persistence/datastore/DatastoreFileWriter;)V", "clearAllData", "", "removeValue", "key", "", "callback", "Lcom/datadog/android/api/storage/datastore/DataStoreWriteCallback;", "setValue", "T", "", "data", "version", "", "serializer", "Lcom/datadog/android/core/persistence/Serializer;", "(Ljava/lang/String;Ljava/lang/Object;ILcom/datadog/android/api/storage/datastore/DataStoreWriteCallback;Lcom/datadog/android/core/persistence/Serializer;)V", "value", "Lcom/datadog/android/api/storage/datastore/DataStoreReadCallback;", "deserializer", "Lcom/datadog/android/core/internal/persistence/Deserializer;", "(Ljava/lang/String;Ljava/lang/Integer;Lcom/datadog/android/api/storage/datastore/DataStoreReadCallback;Lcom/datadog/android/core/internal/persistence/Deserializer;)V", "dd-sdk-android-core_release"})
public final class DataStoreFileHandler
implements DataStoreHandler {
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final DatastoreFileReader dataStoreFileReader;
    @NotNull
    private final DatastoreFileWriter datastoreFileWriter;

    public DataStoreFileHandler(@NotNull ExecutorService executorService, @NotNull InternalLogger internalLogger, @NotNull DatastoreFileReader dataStoreFileReader, @NotNull DatastoreFileWriter datastoreFileWriter) {
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)dataStoreFileReader, (String)"dataStoreFileReader");
        Intrinsics.checkNotNullParameter((Object)datastoreFileWriter, (String)"datastoreFileWriter");
        this.executorService = executorService;
        this.internalLogger = internalLogger;
        this.dataStoreFileReader = dataStoreFileReader;
        this.datastoreFileWriter = datastoreFileWriter;
    }

    @Override
    public <T> void setValue(@NotNull String key, @NotNull T data, int version, @Nullable DataStoreWriteCallback callback, @NotNull Serializer<T> serializer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        ConcurrencyExtKt.executeSafe(this.executorService, "dataStoreWrite", this.internalLogger, () -> DataStoreFileHandler.setValue$lambda$0(this, key, data, serializer, callback, version));
    }

    @Override
    public void removeValue(@NotNull String key, @Nullable DataStoreWriteCallback callback) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ConcurrencyExtKt.executeSafe(this.executorService, "dataStoreRemove", this.internalLogger, () -> DataStoreFileHandler.removeValue$lambda$1(this, key, callback));
    }

    @Override
    public void clearAllData() {
        ConcurrencyExtKt.executeSafe(this.executorService, "dataStoreClearAllData", this.internalLogger, () -> DataStoreFileHandler.clearAllData$lambda$2(this));
    }

    @Override
    public <T> void value(@NotNull String key, @Nullable Integer version, @NotNull DataStoreReadCallback<T> callback, @NotNull Deserializer<String, T> deserializer) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        ConcurrencyExtKt.executeSafe(this.executorService, "dataStoreRead", this.internalLogger, () -> DataStoreFileHandler.value$lambda$3(this, key, deserializer, version, callback));
    }

    private static final void setValue$lambda$0(DataStoreFileHandler this$0, String $key, Object $data, Serializer $serializer, DataStoreWriteCallback $callback, int $version) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intrinsics.checkNotNullParameter((Object)$serializer, (String)"$serializer");
        this$0.datastoreFileWriter.write$dd_sdk_android_core_release($key, $data, $serializer, $callback, $version);
    }

    private static final void removeValue$lambda$1(DataStoreFileHandler this$0, String $key, DataStoreWriteCallback $callback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        this$0.datastoreFileWriter.delete$dd_sdk_android_core_release($key, $callback);
    }

    private static final void clearAllData$lambda$2(DataStoreFileHandler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.datastoreFileWriter.clearAllData$dd_sdk_android_core_release();
    }

    private static final void value$lambda$3(DataStoreFileHandler this$0, String $key, Deserializer $deserializer, Integer $version, DataStoreReadCallback $callback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)$deserializer, (String)"$deserializer");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        this$0.dataStoreFileReader.read$dd_sdk_android_core_release($key, $deserializer, $version, $callback);
    }
}

