/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.datastore;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.storage.datastore.DataStoreReadCallback;
import com.datadog.android.core.internal.persistence.Deserializer;
import com.datadog.android.core.internal.persistence.datastore.DataStoreFileHelper;
import com.datadog.android.core.internal.persistence.datastore.DatastoreFileReader;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.tlvformat.TLVBlock;
import com.datadog.android.core.internal.persistence.tlvformat.TLVBlockFileReader;
import com.datadog.android.core.internal.persistence.tlvformat.TLVBlockType;
import com.datadog.android.core.internal.utils.ByteArrayExtKt;
import com.datadog.android.core.persistence.datastore.DataStoreContent;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J<\u0010\u0013\u001a\n\u0012\u0004\u0012\u0002H\u0015\u0018\u00010\u0014\"\b\b\u0000\u0010\u0015*\u00020\u00012\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u00150\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002JO\u0010\u001b\u001a\u00020\u000e\"\b\b\u0000\u0010\u0015*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u00150\u00172\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001fH\u0001\u00a2\u0006\u0004\b \u0010!JS\u0010\"\u001a\u00020\u000e\"\b\b\u0000\u0010\u0015*\u00020\u00012\u0006\u0010#\u001a\u00020\u00072\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u00150\u00172\u0006\u0010\n\u001a\u00020\u000b2\b\u0010$\u001a\u0004\u0018\u00010\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00150\u001fH\u0002\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/datadog/android/core/internal/persistence/datastore/DatastoreFileReader;", "", "dataStoreFileHelper", "Lcom/datadog/android/core/internal/persistence/datastore/DataStoreFileHelper;", "featureName", "", "storageDir", "Ljava/io/File;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "tlvBlockFileReader", "Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlockFileReader;", "(Lcom/datadog/android/core/internal/persistence/datastore/DataStoreFileHelper;Ljava/lang/String;Ljava/io/File;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlockFileReader;)V", "logBlocksInUnexpectedBlocksOrderError", "", "logInvalidNumberOfBlocksError", "numberBlocksFound", "", "numberBlocksExpected", "mapToDataStoreContents", "Lcom/datadog/android/core/persistence/datastore/DataStoreContent;", "T", "deserializer", "Lcom/datadog/android/core/internal/persistence/Deserializer;", "tlvBlocks", "", "Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlock;", "read", "key", "version", "callback", "Lcom/datadog/android/api/storage/datastore/DataStoreReadCallback;", "read$dd_sdk_android_core_release", "(Ljava/lang/String;Lcom/datadog/android/core/internal/persistence/Deserializer;Ljava/lang/Integer;Lcom/datadog/android/api/storage/datastore/DataStoreReadCallback;)V", "readFromDataStoreFile", "datastoreFile", "requestedVersion", "(Ljava/io/File;Lcom/datadog/android/core/internal/persistence/Deserializer;Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlockFileReader;Ljava/lang/Integer;Lcom/datadog/android/api/storage/datastore/DataStoreReadCallback;)V", "Companion", "dd-sdk-android-core_release"})
public final class DatastoreFileReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataStoreFileHelper dataStoreFileHelper;
    @NotNull
    private final String featureName;
    @NotNull
    private final File storageDir;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final TLVBlockFileReader tlvBlockFileReader;
    @NotNull
    public static final String INVALID_NUMBER_OF_BLOCKS_ERROR = "Read error - datastore entry has invalid number of blocks. Was: %d, expected: %d";
    @NotNull
    public static final String UNEXPECTED_BLOCKS_ORDER_ERROR = "Read error - blocks are in an unexpected order";

    public DatastoreFileReader(@NotNull DataStoreFileHelper dataStoreFileHelper, @NotNull String featureName, @NotNull File storageDir, @NotNull InternalLogger internalLogger, @NotNull TLVBlockFileReader tlvBlockFileReader) {
        Intrinsics.checkNotNullParameter((Object)dataStoreFileHelper, (String)"dataStoreFileHelper");
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)tlvBlockFileReader, (String)"tlvBlockFileReader");
        this.dataStoreFileHelper = dataStoreFileHelper;
        this.featureName = featureName;
        this.storageDir = storageDir;
        this.internalLogger = internalLogger;
        this.tlvBlockFileReader = tlvBlockFileReader;
    }

    @WorkerThread
    public final <T> void read$dd_sdk_android_core_release(@NotNull String key, @NotNull Deserializer<String, T> deserializer, @Nullable Integer version, @NotNull DataStoreReadCallback<T> callback) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        File datastoreFile = this.dataStoreFileHelper.getDataStoreFile$dd_sdk_android_core_release(this.storageDir, this.featureName, key);
        if (!FileExtKt.existsSafe(datastoreFile, this.internalLogger)) {
            callback.onSuccess(null);
            return;
        }
        this.readFromDataStoreFile(datastoreFile, deserializer, this.tlvBlockFileReader, version, callback);
    }

    public static /* synthetic */ void read$dd_sdk_android_core_release$default(DatastoreFileReader datastoreFileReader, String string, Deserializer deserializer, Integer n, DataStoreReadCallback dataStoreReadCallback, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        datastoreFileReader.read$dd_sdk_android_core_release(string, deserializer, n, dataStoreReadCallback);
    }

    private final <T> void readFromDataStoreFile(File datastoreFile, Deserializer<String, T> deserializer, TLVBlockFileReader tlvBlockFileReader, Integer requestedVersion, DataStoreReadCallback<T> callback) {
        int numberBlocksExpected;
        List<TLVBlock> tlvBlocks = tlvBlockFileReader.read$dd_sdk_android_core_release(datastoreFile);
        int numberBlocksFound = tlvBlocks.size();
        if (numberBlocksFound != (numberBlocksExpected = TLVBlockType.values().length)) {
            this.logInvalidNumberOfBlocksError(numberBlocksFound, numberBlocksExpected);
            callback.onFailure();
            return;
        }
        DataStoreContent<T> dataStoreContent = this.mapToDataStoreContents(deserializer, tlvBlocks);
        if (dataStoreContent == null) {
            callback.onFailure();
            return;
        }
        if (requestedVersion != null) {
            int n = dataStoreContent.getVersionCode();
            if (requestedVersion != n) {
                callback.onSuccess(null);
                return;
            }
        }
        callback.onSuccess(dataStoreContent);
    }

    private final <T> DataStoreContent<T> mapToDataStoreContents(Deserializer<String, T> deserializer, List<TLVBlock> tlvBlocks) {
        if (tlvBlocks.get(0).getType() != TLVBlockType.VERSION_CODE && tlvBlocks.get(1).getType() != TLVBlockType.DATA) {
            this.logBlocksInUnexpectedBlocksOrderError();
            return null;
        }
        TLVBlock versionCodeBlock = tlvBlocks.get(0);
        TLVBlock dataBlock = tlvBlocks.get(1);
        return new DataStoreContent<T>(ByteArrayExtKt.toInt(versionCodeBlock.getData()), deserializer.deserialize(new String(dataBlock.getData(), Charsets.UTF_8)));
    }

    private final void logInvalidNumberOfBlocksError(int numberBlocksFound, int numberBlocksExpected) {
        InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, (Function0)new Function0<String>(numberBlocksFound, numberBlocksExpected){
            final /* synthetic */ int $numberBlocksFound;
            final /* synthetic */ int $numberBlocksExpected;
            {
                this.$numberBlocksFound = $numberBlocksFound;
                this.$numberBlocksExpected = $numberBlocksExpected;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = "Read error - datastore entry has invalid number of blocks. Was: %d, expected: %d";
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{this.$numberBlocksFound, this.$numberBlocksExpected};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                return string2;
            }
        }, null, false, null, 56, null);
    }

    private final void logBlocksInUnexpectedBlocksOrderError() {
        InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, (Function0)logBlocksInUnexpectedBlocksOrderError.1.INSTANCE, null, false, null, 56, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/core/internal/persistence/datastore/DatastoreFileReader$Companion;", "", "()V", "INVALID_NUMBER_OF_BLOCKS_ERROR", "", "UNEXPECTED_BLOCKS_ORDER_ERROR", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

