/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.datastore;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.storage.datastore.DataStoreWriteCallback;
import com.datadog.android.core.internal.persistence.datastore.DataStoreFileHelper;
import com.datadog.android.core.internal.persistence.datastore.DatastoreFileWriter;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FileReaderWriter;
import com.datadog.android.core.internal.persistence.tlvformat.TLVBlock;
import com.datadog.android.core.internal.persistence.tlvformat.TLVBlockType;
import com.datadog.android.core.internal.utils.ByteArrayExtKt;
import com.datadog.android.core.internal.utils.NumberExtKt;
import com.datadog.android.core.persistence.Serializer;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\r\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\b\u000fJ\u001f\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0001\u00a2\u0006\u0002\b\u0014J/\u0010\u0015\u001a\u0004\u0018\u00010\u0016\"\b\b\u0000\u0010\u0017*\u00020\u00012\u0006\u0010\u0018\u001a\u0002H\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u000eH\u0002JI\u0010 \u001a\u00020\u000e\"\b\b\u0000\u0010\u0017*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u0002H\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0001\u00a2\u0006\u0004\b!\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/datadog/android/core/internal/persistence/datastore/DatastoreFileWriter;", "", "dataStoreFileHelper", "Lcom/datadog/android/core/internal/persistence/datastore/DataStoreFileHelper;", "featureName", "", "storageDir", "Ljava/io/File;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "fileReaderWriter", "Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;", "(Lcom/datadog/android/core/internal/persistence/datastore/DataStoreFileHelper;Ljava/lang/String;Ljava/io/File;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;)V", "clearAllData", "", "clearAllData$dd_sdk_android_core_release", "delete", "key", "callback", "Lcom/datadog/android/api/storage/datastore/DataStoreWriteCallback;", "delete$dd_sdk_android_core_release", "getDataBlock", "", "T", "data", "serializer", "Lcom/datadog/android/core/persistence/Serializer;", "(Ljava/lang/Object;Lcom/datadog/android/core/persistence/Serializer;)[B", "getVersionCodeBlock", "version", "", "logFailedToSerializeDataError", "write", "write$dd_sdk_android_core_release", "(Ljava/lang/String;Ljava/lang/Object;Lcom/datadog/android/core/persistence/Serializer;Lcom/datadog/android/api/storage/datastore/DataStoreWriteCallback;I)V", "Companion", "dd-sdk-android-core_release"})
public final class DatastoreFileWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataStoreFileHelper dataStoreFileHelper;
    @NotNull
    private final String featureName;
    @NotNull
    private final File storageDir;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final FileReaderWriter fileReaderWriter;
    @NotNull
    public static final String FAILED_TO_SERIALIZE_DATA_ERROR = "Write error - Failed to serialize data for the datastore";
    @NotNull
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public DatastoreFileWriter(@NotNull DataStoreFileHelper dataStoreFileHelper, @NotNull String featureName, @NotNull File storageDir, @NotNull InternalLogger internalLogger, @NotNull FileReaderWriter fileReaderWriter) {
        Intrinsics.checkNotNullParameter((Object)dataStoreFileHelper, (String)"dataStoreFileHelper");
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)fileReaderWriter, (String)"fileReaderWriter");
        this.dataStoreFileHelper = dataStoreFileHelper;
        this.featureName = featureName;
        this.storageDir = storageDir;
        this.internalLogger = internalLogger;
        this.fileReaderWriter = fileReaderWriter;
    }

    @WorkerThread
    public final <T> void write$dd_sdk_android_core_release(@NotNull String key, @NotNull T data, @NotNull Serializer<T> serializer, @Nullable DataStoreWriteCallback callback, int version) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
                File datastoreFile = this.dataStoreFileHelper.getDataStoreFile$dd_sdk_android_core_release(this.storageDir, this.featureName, key);
                byte[] versionCodeBlock = this.getVersionCodeBlock(version);
                byte[] dataBlock = this.getDataBlock(data, serializer);
                if (versionCodeBlock == null || dataBlock == null) {
                    DataStoreWriteCallback dataStoreWriteCallback = callback;
                    if (dataStoreWriteCallback != null) {
                        dataStoreWriteCallback.onFailure();
                    }
                    return;
                }
                byte[][] byArrayArray = new byte[][]{versionCodeBlock, dataBlock};
                byte[] dataToWrite = ByteArrayExtKt.join$default(CollectionsKt.listOf((Object[])((Object[])byArrayArray)), EMPTY_BYTE_ARRAY, null, null, this.internalLogger, 6, null);
                boolean result = this.fileReaderWriter.writeData(datastoreFile, dataToWrite, false);
                if (!result) break block2;
                DataStoreWriteCallback dataStoreWriteCallback = callback;
                if (dataStoreWriteCallback == null) break block3;
                dataStoreWriteCallback.onSuccess();
                break block3;
            }
            DataStoreWriteCallback dataStoreWriteCallback = callback;
            if (dataStoreWriteCallback == null) break block3;
            dataStoreWriteCallback.onFailure();
        }
    }

    @WorkerThread
    public final void delete$dd_sdk_android_core_release(@NotNull String key, @Nullable DataStoreWriteCallback callback) {
        block0: {
            block1: {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                File datastoreFile = this.dataStoreFileHelper.getDataStoreFile$dd_sdk_android_core_release(this.storageDir, this.featureName, key);
                if (!FileExtKt.existsSafe(datastoreFile, this.internalLogger)) break block0;
                boolean result = FileExtKt.deleteSafe(datastoreFile, this.internalLogger);
                if (!result) break block1;
                DataStoreWriteCallback dataStoreWriteCallback = callback;
                if (dataStoreWriteCallback == null) break block0;
                dataStoreWriteCallback.onSuccess();
                break block0;
            }
            DataStoreWriteCallback dataStoreWriteCallback = callback;
            if (dataStoreWriteCallback == null) break block0;
            dataStoreWriteCallback.onFailure();
        }
    }

    @WorkerThread
    public final void clearAllData$dd_sdk_android_core_release() {
        DataStoreFileHelper dataStoreFileHelper = this.dataStoreFileHelper;
        File file = this.storageDir;
        String string = this.featureName;
        File dataStoreDirectory = dataStoreFileHelper.getDataStoreDirectory$dd_sdk_android_core_release(file, string);
        if (FileExtKt.existsSafe(dataStoreDirectory, this.internalLogger)) {
            FileExtKt.deleteDirectoryContentsSafe(dataStoreDirectory, this.internalLogger);
        }
    }

    private final <T> byte[] getDataBlock(T data, Serializer<T> serializer) {
        byte[] serializedData;
        byte[] byArray;
        String string = serializer.serialize(data);
        if (string != null) {
            String string2 = string;
            byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        } else {
            byArray = serializedData = null;
        }
        if (serializedData == null) {
            this.logFailedToSerializeDataError();
            return null;
        }
        TLVBlock dataBlock = new TLVBlock(TLVBlockType.DATA, serializedData, this.internalLogger);
        return TLVBlock.serialize$dd_sdk_android_core_release$default(dataBlock, 0, 1, null);
    }

    private final byte[] getVersionCodeBlock(int version) {
        byte[] versionCodeByteArray = NumberExtKt.toByteArray(version);
        TLVBlock versionBlock = new TLVBlock(TLVBlockType.VERSION_CODE, versionCodeByteArray, this.internalLogger);
        return TLVBlock.serialize$dd_sdk_android_core_release$default(versionBlock, 0, 1, null);
    }

    private final void logFailedToSerializeDataError() {
        InternalLogger internalLogger = this.internalLogger;
        InternalLogger.Target target = InternalLogger.Target.MAINTAINER;
        InternalLogger.Level level = InternalLogger.Level.ERROR;
        InternalLogger.DefaultImpls.log$default(internalLogger, level, target, (Function0)logFailedToSerializeDataError.1.INSTANCE, null, false, null, 56, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/core/internal/persistence/datastore/DatastoreFileWriter$Companion;", "", "()V", "EMPTY_BYTE_ARRAY", "", "FAILED_TO_SERIALIZE_DATA_ERROR", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

