/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.batch;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.metrics.BatchClosedMetadata;
import com.datadog.android.core.internal.metrics.MetricsDispatcher;
import com.datadog.android.core.internal.metrics.RemovalReason;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.FilePersistenceConfig;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0000\u0018\u0000 ?2\u00020\u0001:\u0002>?B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010#\u001a\u00020\u001aH\u0002J\u0012\u0010$\u001a\u00020\u00032\b\b\u0002\u0010%\u001a\u00020\u001aH\u0002J\u001a\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00032\b\b\u0002\u0010(\u001a\u00020\u001aH\u0002J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0002J\u0016\u0010+\u001a\u00020,2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0002J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0017J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0017J\u0012\u0010/\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020\u0003H\u0017J\u0018\u00100\u001a\u0004\u0018\u00010\u00032\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000302H\u0017J\n\u00103\u001a\u0004\u0018\u00010\u0003H\u0002J\n\u00104\u001a\u0004\u0018\u00010\u0003H\u0017J\b\u00105\u001a\u000206H\u0016J\u0012\u00107\u001a\u0004\u0018\u00010\u00032\u0006\u00108\u001a\u00020\u001aH\u0017J\u0018\u00109\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010:\u001a\u00020\u0010H\u0002J\b\u0010;\u001a\u00020\u001aH\u0002J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0002J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0018\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\u00020\u001a*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR \u0010\u001c\u001a\u0004\u0018\u00010\u0003*\b\u0012\u0004\u0012\u00020\u00030\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\u00020\u0003*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006@"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator;", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "rootDir", "Ljava/io/File;", "config", "Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "metricsDispatcher", "Lcom/datadog/android/core/internal/metrics/MetricsDispatcher;", "(Ljava/io/File;Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/core/internal/metrics/MetricsDispatcher;)V", "getConfig$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "fileFilter", "Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator$BatchFileFilter;", "lastCleanupTimestamp", "", "lastFileAccessTimestamp", "previousFile", "previousFileItemCount", "recentReadDelayMs", "getRecentReadDelayMs$annotations", "()V", "recentWriteDelayMs", "getRecentWriteDelayMs$annotations", "isBatchFile", "", "(Ljava/io/File;)Z", "latestBatchFile", "", "getLatestBatchFile", "(Ljava/util/List;)Ljava/io/File;", "metadata", "getMetadata", "(Ljava/io/File;)Ljava/io/File;", "canDoCleanup", "createNewFile", "wasForced", "deleteFile", "file", "sendMetric", "deleteObsoleteFiles", "files", "freeSpaceIfNeeded", "", "getAllFiles", "getFlushableFiles", "getMetadataFile", "getReadableFile", "excludeFiles", "", "getReusableWritableFile", "getRootDir", "getRootDirName", "", "getWritableFile", "forceNewFile", "isFileRecent", "delayMs", "isRootDirValid", "listBatchFiles", "listSortedBatchFiles", "BatchFileFilter", "Companion", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nBatchFileOrchestrator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BatchFileOrchestrator.kt\ncom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,365:1\n288#2,2:366\n1603#2,9:368\n1855#2:377\n1856#2:379\n1612#2:380\n1789#2,3:382\n1#3:378\n1#3:381\n18#4:385\n26#5:386\n*S KotlinDebug\n*F\n+ 1 BatchFileOrchestrator.kt\ncom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator\n*L\n85#1:366,2\n259#1:368,9\n259#1:377\n259#1:379\n259#1:380\n285#1:382,3\n259#1:378\n313#1:385\n313#1:386\n*E\n"})
public final class BatchFileOrchestrator
implements FileOrchestrator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File rootDir;
    @NotNull
    private final FilePersistenceConfig config;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final MetricsDispatcher metricsDispatcher;
    @NotNull
    private final BatchFileFilter fileFilter;
    private final long recentReadDelayMs;
    private final long recentWriteDelayMs;
    @Nullable
    private File previousFile;
    private long previousFileItemCount;
    private long lastFileAccessTimestamp;
    private long lastCleanupTimestamp;
    public static final double DECREASE_PERCENT = 0.95;
    public static final double INCREASE_PERCENT = 1.05;
    @NotNull
    public static final String ERROR_ROOT_NOT_WRITABLE = "The provided root dir is not writable: %s";
    @NotNull
    public static final String ERROR_ROOT_NOT_DIR = "The provided root file is not a directory: %s";
    @NotNull
    public static final String ERROR_CANT_CREATE_ROOT = "The provided root dir can't be created: %s";
    @NotNull
    public static final String ERROR_DISK_FULL = "Too much disk space used (%d/%d): cleaning up to free %d bytes\u2026";
    @NotNull
    public static final String ERROR_NOT_BATCH_FILE = "The file provided is not a batch file: %s";
    @NotNull
    public static final String DEBUG_DIFFERENT_ROOT = "The file provided (%s) doesn't belong to the current folder (%s)";

    public BatchFileOrchestrator(@NotNull File rootDir, @NotNull FilePersistenceConfig config, @NotNull InternalLogger internalLogger, @NotNull MetricsDispatcher metricsDispatcher) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)metricsDispatcher, (String)"metricsDispatcher");
        this.rootDir = rootDir;
        this.config = config;
        this.internalLogger = internalLogger;
        this.metricsDispatcher = metricsDispatcher;
        this.fileFilter = new BatchFileFilter();
        this.recentReadDelayMs = MathKt.roundToLong((double)((double)this.config.getRecentDelayMs() * 1.05));
        this.recentWriteDelayMs = MathKt.roundToLong((double)((double)this.config.getRecentDelayMs() * 0.95));
    }

    @NotNull
    public final FilePersistenceConfig getConfig$dd_sdk_android_core_release() {
        return this.config;
    }

    private static /* synthetic */ void getRecentReadDelayMs$annotations() {
    }

    private static /* synthetic */ void getRecentWriteDelayMs$annotations() {
    }

    @Override
    @WorkerThread
    @Nullable
    public File getWritableFile(boolean forceNewFile) {
        File file;
        if (!this.isRootDirValid()) {
            return null;
        }
        if (this.canDoCleanup()) {
            List<File> files = this.listBatchFiles();
            files = this.deleteObsoleteFiles(files);
            this.freeSpaceIfNeeded(files);
            this.lastCleanupTimestamp = System.currentTimeMillis();
        }
        if (!forceNewFile) {
            file = this.getReusableWritableFile();
            if (file == null) {
                file = BatchFileOrchestrator.createNewFile$default(this, false, 1, null);
            }
        } else {
            file = this.createNewFile(true);
        }
        return file;
    }

    @Override
    @WorkerThread
    @Nullable
    public File getReadableFile(@NotNull Set<? extends File> excludeFiles) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(excludeFiles, (String)"excludeFiles");
            if (!this.isRootDirValid()) {
                return null;
            }
            List<File> it = this.listSortedBatchFiles();
            boolean bl = false;
            List<File> files = this.deleteObsoleteFiles(it);
            this.lastCleanupTimestamp = System.currentTimeMillis();
            Iterable $this$firstOrNull$iv = files;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it2 = (File)element$iv;
                boolean bl2 = false;
                if (!(!excludeFiles.contains(it2) && !this.isFileRecent(it2, this.recentReadDelayMs))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @WorkerThread
    @NotNull
    public List<File> getAllFiles() {
        if (!this.isRootDirValid()) {
            return CollectionsKt.emptyList();
        }
        return this.listSortedBatchFiles();
    }

    @Override
    @WorkerThread
    @NotNull
    public List<File> getFlushableFiles() {
        return this.getAllFiles();
    }

    @Override
    @WorkerThread
    @Nullable
    public File getRootDir() {
        if (!this.isRootDirValid()) {
            return null;
        }
        return this.rootDir;
    }

    @Override
    @NotNull
    public String getRootDirName() {
        return FilesKt.getNameWithoutExtension((File)this.rootDir);
    }

    @Override
    @WorkerThread
    @Nullable
    public File getMetadataFile(@NotNull File file) {
        File file2;
        InternalLogger.Target[] targetArray;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Intrinsics.areEqual((Object)file.getParent(), (Object)this.rootDir.getPath())) {
            targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.DEBUG, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(file, this){
                final /* synthetic */ File $file;
                final /* synthetic */ BatchFileOrchestrator this$0;
                {
                    this.$file = $file;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "The file provided (%s) doesn't belong to the current folder (%s)";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$file.getPath(), BatchFileOrchestrator.access$getRootDir$p(this.this$0).getPath()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }, null, false, null, 56, null);
        }
        if (this.isBatchFile(file)) {
            file2 = this.getMetadata(file);
        } else {
            targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(file){
                final /* synthetic */ File $file;
                {
                    this.$file = $file;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "The file provided is not a batch file: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$file.getPath()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }, null, false, null, 56, null);
            file2 = null;
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isRootDirValid() {
        if (FileExtKt.existsSafe(this.rootDir, this.internalLogger)) {
            if (this.rootDir.isDirectory()) {
                if (FileExtKt.canWriteSafe(this.rootDir, this.internalLogger)) {
                    return true;
                }
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(this){
                    final /* synthetic */ BatchFileOrchestrator this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        String string = "The provided root dir is not writable: %s";
                        Locale locale = Locale.US;
                        Object[] objectArray = new Object[]{BatchFileOrchestrator.access$getRootDir$p(this.this$0).getPath()};
                        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        return string2;
                    }
                }, null, false, null, 56, null);
                return false;
            }
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(this){
                final /* synthetic */ BatchFileOrchestrator this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "The provided root file is not a directory: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{BatchFileOrchestrator.access$getRootDir$p(this.this$0).getPath()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }, null, false, null, 56, null);
            return false;
        }
        File file = this.rootDir;
        synchronized (file) {
            block9: {
                block8: {
                    boolean bl = false;
                    if (!FileExtKt.existsSafe(this.rootDir, this.internalLogger)) break block8;
                    boolean bl2 = true;
                    return bl2;
                }
                if (!FileExtKt.mkdirsSafe(this.rootDir, this.internalLogger)) break block9;
                boolean bl = true;
                return bl;
            }
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(this){
                final /* synthetic */ BatchFileOrchestrator this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "The provided root dir can't be created: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{BatchFileOrchestrator.access$getRootDir$p(this.this$0).getPath()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }, null, false, null, 56, null);
            boolean bl = false;
            return bl;
        }
    }

    private final File createNewFile(boolean wasForced) {
        String newFileName = String.valueOf(System.currentTimeMillis());
        File newFile = new File(this.rootDir, newFileName);
        File closedFile = this.previousFile;
        long closedFileLastAccessTimestamp = this.lastFileAccessTimestamp;
        if (closedFile != null) {
            long l = this.previousFileItemCount;
            this.metricsDispatcher.sendBatchClosedMetric(closedFile, new BatchClosedMetadata(closedFileLastAccessTimestamp, wasForced, l));
        }
        this.previousFile = newFile;
        this.previousFileItemCount = 1L;
        this.lastFileAccessTimestamp = System.currentTimeMillis();
        return newFile;
    }

    static /* synthetic */ File createNewFile$default(BatchFileOrchestrator batchFileOrchestrator, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return batchFileOrchestrator.createNewFile(bl);
    }

    private final File getReusableWritableFile() {
        File file;
        boolean hasSlotForMore;
        List<File> files = this.listBatchFiles();
        File file2 = this.getLatestBatchFile(files);
        if (file2 == null) {
            return null;
        }
        File lastFile = file2;
        File lastKnownFile = this.previousFile;
        long lastKnownFileItemCount = this.previousFileItemCount;
        if (!Intrinsics.areEqual((Object)lastKnownFile, (Object)lastFile)) {
            return null;
        }
        boolean isRecentEnough = this.isFileRecent(lastFile, this.recentWriteDelayMs);
        boolean hasRoomForMore = FileExtKt.lengthSafe(lastFile, this.internalLogger) < this.config.getMaxBatchSize();
        boolean bl = hasSlotForMore = lastKnownFileItemCount < (long)this.config.getMaxItemsPerBatch();
        if (isRecentEnough && hasRoomForMore && hasSlotForMore) {
            this.previousFileItemCount = lastKnownFileItemCount + 1L;
            this.lastFileAccessTimestamp = System.currentTimeMillis();
            file = lastFile;
        } else {
            file = null;
        }
        return file;
    }

    private final boolean isFileRecent(File file, long delayMs) {
        long now = System.currentTimeMillis();
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        Long l = StringsKt.toLongOrNull((String)string);
        long fileTimestamp = l != null ? l : 0L;
        return fileTimestamp >= now - delayMs;
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> deleteObsoleteFiles(List<? extends File> files) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        long threshold = System.currentTimeMillis() - this.config.getOldFileThreshold();
        Iterable iterable = files;
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File file;
            boolean isOldFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            Long l = StringsKt.toLongOrNull((String)string);
            boolean bl3 = isOldFile = (l != null ? l : 0L) < threshold;
            if (isOldFile) {
                if (FileExtKt.deleteSafe(it, this.internalLogger)) {
                    this.metricsDispatcher.sendBatchDeletedMetric(it, RemovalReason.Obsolete.INSTANCE);
                }
                if (FileExtKt.existsSafe(this.getMetadata(it), this.internalLogger)) {
                    FileExtKt.deleteSafe(this.getMetadata(it), this.internalLogger);
                }
                file = null;
            } else {
                file = it;
            }
            if (file == null) continue;
            File it$iv$iv = file;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void freeSpaceIfNeeded(List<? extends File> files) {
        Iterable iterable = files;
        long l = 0L;
        for (Object object : iterable) {
            void it;
            File file = (File)object;
            long l2 = l;
            boolean bl = false;
            long l3 = FileExtKt.lengthSafe((File)it, this.internalLogger);
            l = l2 + l3;
        }
        long sizeOnDisk = l;
        long maxDiskSpace = this.config.getMaxDiskSpace();
        long sizeToFree = sizeOnDisk - maxDiskSpace;
        if (sizeToFree > 0L) {
            void $this$fold$iv;
            Object object;
            object = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf(object), (Function0)new Function0<String>(sizeOnDisk, maxDiskSpace, sizeToFree){
                final /* synthetic */ long $sizeOnDisk;
                final /* synthetic */ long $maxDiskSpace;
                final /* synthetic */ long $sizeToFree;
                {
                    this.$sizeOnDisk = $sizeOnDisk;
                    this.$maxDiskSpace = $maxDiskSpace;
                    this.$sizeToFree = $sizeToFree;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Too much disk space used (%d/%d): cleaning up to free %d bytes\u2026";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$sizeOnDisk, this.$maxDiskSpace, this.$sizeToFree};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }, null, false, null, 56, null);
            object = CollectionsKt.sorted((Iterable)files);
            long initial$iv = sizeToFree;
            boolean $i$f$fold = false;
            long accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                long l4;
                File file = (File)element$iv;
                long remainingSizeToFree = accumulator$iv;
                boolean bl = false;
                if (remainingSizeToFree > 0L) {
                    void file2;
                    long deletedFileSize = this.deleteFile((File)file2, true);
                    long deletedMetaFileSize = BatchFileOrchestrator.deleteFile$default(this, this.getMetadata((File)file2), false, 2, null);
                    l4 = remainingSizeToFree - deletedFileSize - deletedMetaFileSize;
                } else {
                    l4 = remainingSizeToFree;
                }
                accumulator$iv = l4;
            }
        }
    }

    private final long deleteFile(File file, boolean sendMetric) {
        long l;
        if (!FileExtKt.existsSafe(file, this.internalLogger)) {
            return 0L;
        }
        long size = FileExtKt.lengthSafe(file, this.internalLogger);
        boolean wasDeleted = FileExtKt.deleteSafe(file, this.internalLogger);
        if (wasDeleted) {
            if (sendMetric) {
                this.metricsDispatcher.sendBatchDeletedMetric(file, RemovalReason.Purged.INSTANCE);
            }
            l = size;
        } else {
            l = 0L;
        }
        return l;
    }

    static /* synthetic */ long deleteFile$default(BatchFileOrchestrator batchFileOrchestrator, File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return batchFileOrchestrator.deleteFile(file, bl);
    }

    private final List<File> listBatchFiles() {
        Object[] $this$orEmpty$iv = FileExtKt.listFilesSafe(this.rootDir, this.fileFilter, this.internalLogger);
        boolean $i$f$orEmpty = false;
        Object[] objectArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            boolean $i$f$emptyArray = false;
            objectArray = new File[]{};
        }
        return ArraysKt.toList((Object[])objectArray);
    }

    private final List<File> listSortedBatchFiles() {
        return CollectionsKt.sorted((Iterable)this.listBatchFiles());
    }

    private final boolean canDoCleanup() {
        return System.currentTimeMillis() - this.lastCleanupTimestamp > this.config.getCleanupFrequencyThreshold();
    }

    private final File getMetadata(File $this$metadata) {
        return new File($this$metadata.getPath() + "_metadata");
    }

    private final boolean isBatchFile(File $this$isBatchFile) {
        String string = $this$isBatchFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return StringsKt.toLongOrNull((String)string) != null;
    }

    private final File getLatestBatchFile(List<? extends File> $this$latestBatchFile) {
        return (File)CollectionsKt.maxOrNull((Iterable)$this$latestBatchFile);
    }

    public static final /* synthetic */ File access$getRootDir$p(BatchFileOrchestrator $this) {
        return $this.rootDir;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator$BatchFileFilter;", "Ljava/io/FileFilter;", "(Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator;)V", "accept", "", "file", "Ljava/io/File;", "dd-sdk-android-core_release"})
    public final class BatchFileFilter
    implements FileFilter {
        @Override
        public boolean accept(@Nullable File file) {
            if (file == null) {
                return false;
            }
            return BatchFileOrchestrator.this.isBatchFile(file);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileOrchestrator$Companion;", "", "()V", "DEBUG_DIFFERENT_ROOT", "", "DECREASE_PERCENT", "", "ERROR_CANT_CREATE_ROOT", "ERROR_DISK_FULL", "ERROR_NOT_BATCH_FILE", "ERROR_ROOT_NOT_DIR", "ERROR_ROOT_NOT_WRITABLE", "INCREASE_PERCENT", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

