/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.batch;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileReaderWriter;
import com.datadog.android.core.internal.persistence.file.batch.PlainBatchFileReaderWriter;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0000\u0018\u0000 #2\u00020\u0001:\u0003!\"#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u001c\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0006H\u0017J\u001c\u0010\u001d\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/PlainBatchFileReaderWriter;", "Lcom/datadog/android/core/internal/persistence/file/batch/BatchFileReaderWriter;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/InternalLogger;)V", "checkReadExpected", "", "expected", "", "actual", "operation", "", "lockFileAndWriteData", "", "file", "Ljava/io/File;", "append", "data", "Lcom/datadog/android/api/storage/RawBatchEvent;", "readBlock", "Lcom/datadog/android/core/internal/persistence/file/batch/PlainBatchFileReaderWriter$BlockReadResult;", "stream", "Ljava/io/InputStream;", "expectedBlockType", "Lcom/datadog/android/core/internal/persistence/file/batch/PlainBatchFileReaderWriter$BlockType;", "readData", "", "readFileData", "writeData", "putAsTlv", "Ljava/nio/ByteBuffer;", "blockType", "", "BlockReadResult", "BlockType", "Companion", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nPlainBatchFileReaderWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlainBatchFileReaderWriter.kt\ncom/datadog/android/core/internal/persistence/file/batch/PlainBatchFileReaderWriter\n+ 2 FileLockExt.kt\ncom/datadog/android/core/internal/utils/FileLockExtKt\n*L\n1#1,274:1\n15#2,4:275\n*S KotlinDebug\n*F\n+ 1 PlainBatchFileReaderWriter.kt\ncom/datadog/android/core/internal/persistence/file/batch/PlainBatchFileReaderWriter\n*L\n100#1:275,4\n*E\n"})
public final class PlainBatchFileReaderWriter
implements BatchFileReaderWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    public static final int TYPE_SIZE_BYTES = 2;
    public static final int LENGTH_SIZE_BYTES = 4;
    public static final int HEADER_SIZE_BYTES = 6;
    @NotNull
    public static final String ERROR_WRITE = "Unable to write data to file: %s";
    @NotNull
    public static final String ERROR_READ = "Unable to read data from file: %s";
    @NotNull
    public static final String WARNING_NOT_ALL_DATA_READ = "File %s is probably corrupted, not all content was read.";

    public PlainBatchFileReaderWriter(@NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
    }

    @Override
    @WorkerThread
    public boolean writeData(@NotNull File file, @NotNull RawBatchEvent data, boolean append) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            this.lockFileAndWriteData(file, append, data);
            bl = true;
        }
        catch (IOException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(file){
                final /* synthetic */ File $file;
                {
                    this.$file = $file;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Unable to write data to file: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$file.getPath()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }, (Throwable)e, false, null, 48, null);
            bl = false;
        }
        catch (SecurityException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(file){
                final /* synthetic */ File $file;
                {
                    this.$file = $file;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Unable to write data to file: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$file.getPath()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }, (Throwable)e, false, null, 48, null);
            bl = false;
        }
        return bl;
    }

    @Override
    @WorkerThread
    @NotNull
    public List<RawBatchEvent> readData(@NotNull File file) {
        List list;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            list = this.readFileData(file);
        }
        catch (IOException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(file){
                final /* synthetic */ File $file;
                {
                    this.$file = $file;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Unable to read data from file: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$file.getPath()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }, (Throwable)e, false, null, 48, null);
            list = CollectionsKt.emptyList();
        }
        catch (SecurityException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)readData.2.INSTANCE, (Throwable)e, false, null, 48, null);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void lockFileAndWriteData(File file, boolean append, RawBatchEvent data) throws IOException {
        Closeable closeable = new FileOutputStream(file, append);
        Throwable throwable = null;
        try {
            FileOutputStream outputStream = (FileOutputStream)closeable;
            boolean bl = false;
            FileLock fileLock = outputStream.getChannel().lock();
            Intrinsics.checkNotNullExpressionValue((Object)fileLock, (String)"outputStream.channel.lock()");
            FileLock $this$use$iv = fileLock;
            boolean $i$f$use = false;
            try {
                FileLock it = $this$use$iv;
                boolean bl2 = false;
                byte[] meta = data.getMetadata();
                int metaBlockSize = 6 + meta.length;
                int dataBlockSize = 6 + data.getData().length;
                ByteBuffer byteBuffer = ByteBuffer.allocate(metaBlockSize + dataBlockSize);
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(metaBlockSize + dataBlockSize)");
                ByteBuffer buffer = this.putAsTlv(this.putAsTlv(byteBuffer, BlockType.META, meta), BlockType.EVENT, data.getData());
                outputStream.write(buffer.array());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$use$iv.release();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<RawBatchEvent> readFileData(File file) throws IOException {
        int inputLength = (int)FileExtKt.lengthSafe(file, this.internalLogger);
        List result = new ArrayList();
        int remaining = 0;
        InternalLogger.Target[] targetArray = new FileInputStream(file);
        int n = 8192;
        targetArray = targetArray instanceof BufferedInputStream ? (BufferedInputStream)targetArray : new BufferedInputStream((InputStream)targetArray, n);
        Throwable throwable = null;
        try {
            BlockReadResult eventReadResult;
            BlockReadResult metaReadResult;
            BufferedInputStream it = (BufferedInputStream)targetArray;
            boolean bl = false;
            for (remaining = inputLength; remaining > 0; remaining -= metaReadResult.getBytesRead() + eventReadResult.getBytesRead()) {
                metaReadResult = this.readBlock(it, BlockType.META);
                if (metaReadResult.getData() == null) {
                    remaining -= metaReadResult.getBytesRead();
                    break;
                }
                eventReadResult = this.readBlock(it, BlockType.EVENT);
                if (eventReadResult.getData() == null) break;
                result.add(new RawBatchEvent(eventReadResult.getData(), metaReadResult.getData()));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)targetArray, (Throwable)throwable);
        }
        if (remaining != 0 || inputLength > 0 && result.isEmpty()) {
            targetArray = new InternalLogger.Target[]{InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(file){
                final /* synthetic */ File $file;
                {
                    this.$file = $file;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "File %s is probably corrupted, not all content was read.";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$file.getPath()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }, null, false, null, 56, null);
        }
        return result;
    }

    private final BlockReadResult readBlock(InputStream stream, BlockType expectedBlockType) throws IOException {
        byte[] dataBuffer;
        int dataReadBytes;
        ByteBuffer headerBuffer = ByteBuffer.allocate(6);
        int headerReadBytes = stream.read(headerBuffer.array());
        if (!this.checkReadExpected(6, headerReadBytes, "Block(" + expectedBlockType.name() + "): Header read")) {
            return new BlockReadResult(null, Math.max(0, headerReadBytes));
        }
        short blockType = headerBuffer.getShort();
        if (blockType != expectedBlockType.getIdentifier()) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, (Function0)new Function0<String>(blockType, expectedBlockType){
                final /* synthetic */ short $blockType;
                final /* synthetic */ BlockType $expectedBlockType;
                {
                    this.$blockType = $blockType;
                    this.$expectedBlockType = $expectedBlockType;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Unexpected block type identifier=" + this.$blockType + " met, was expecting " + this.$expectedBlockType + "(" + this.$expectedBlockType.getIdentifier() + ")";
                }
            }, null, false, null, 56, null);
            return new BlockReadResult(null, headerReadBytes);
        }
        int dataSize = headerBuffer.getInt();
        return this.checkReadExpected(dataSize, dataReadBytes = stream.read(dataBuffer = new byte[dataSize]), "Block(" + expectedBlockType.name() + "):Data read") ? new BlockReadResult(dataBuffer, headerReadBytes + dataReadBytes) : new BlockReadResult(null, headerReadBytes + Math.max(0, dataReadBytes));
    }

    private final boolean checkReadExpected(int expected, int actual, String operation) {
        boolean bl;
        if (expected != actual) {
            if (actual != -1) {
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, (Function0)new Function0<String>(operation, expected, actual){
                    final /* synthetic */ String $operation;
                    final /* synthetic */ int $expected;
                    final /* synthetic */ int $actual;
                    {
                        this.$operation = $operation;
                        this.$expected = $expected;
                        this.$actual = $actual;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Number of bytes read for operation='" + this.$operation + "' doesn't match with expected: expected=" + this.$expected + ", actual=" + this.$actual;
                    }
                }, null, false, null, 56, null);
            } else {
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.MAINTAINER, (Function0)new Function0<String>(operation){
                    final /* synthetic */ String $operation;
                    {
                        this.$operation = $operation;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Unexpected EOF at the operation=" + this.$operation;
                    }
                }, null, false, null, 56, null);
            }
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final ByteBuffer putAsTlv(ByteBuffer $this$putAsTlv, BlockType blockType, byte[] data) {
        ByteBuffer byteBuffer = $this$putAsTlv.putShort(blockType.getIdentifier()).putInt(data.length).put(data);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"this\n            .putSho\u2026e)\n            .put(data)");
        return byteBuffer;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/PlainBatchFileReaderWriter$BlockReadResult;", "", "data", "", "bytesRead", "", "([BI)V", "getBytesRead", "()I", "getData", "()[B", "dd-sdk-android-core_release"})
    private static final class BlockReadResult {
        @Nullable
        private final byte[] data;
        private final int bytesRead;

        public BlockReadResult(@Nullable byte[] data, int bytesRead) {
            this.data = data;
            this.bytesRead = bytesRead;
        }

        @Nullable
        public final byte[] getData() {
            return this.data;
        }

        public final int getBytesRead() {
            return this.bytesRead;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\n\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/PlainBatchFileReaderWriter$BlockType;", "", "identifier", "", "(Ljava/lang/String;IS)V", "getIdentifier", "()S", "EVENT", "META", "dd-sdk-android-core_release"})
    private static final class BlockType
    extends Enum<BlockType> {
        private final short identifier;
        public static final /* enum */ BlockType EVENT = new BlockType(0);
        public static final /* enum */ BlockType META = new BlockType(1);
        private static final /* synthetic */ BlockType[] $VALUES;

        private BlockType(short identifier) {
            this.identifier = identifier;
        }

        public final short getIdentifier() {
            return this.identifier;
        }

        public static BlockType[] values() {
            return (BlockType[])$VALUES.clone();
        }

        public static BlockType valueOf(String value) {
            return Enum.valueOf(BlockType.class, value);
        }

        static {
            $VALUES = blockTypeArray = new BlockType[]{BlockType.EVENT, BlockType.META};
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/core/internal/persistence/file/batch/PlainBatchFileReaderWriter$Companion;", "", "()V", "ERROR_READ", "", "ERROR_WRITE", "HEADER_SIZE_BYTES", "", "LENGTH_SIZE_BYTES", "TYPE_SIZE_BYTES", "WARNING_NOT_ALL_DATA_READ", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

