/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.tlvformat;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.persistence.tlvformat.TLVBlockType;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlock;", "", "type", "Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlockType;", "data", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlockType;[BLcom/datadog/android/api/InternalLogger;)V", "getData", "()[B", "getInternalLogger", "()Lcom/datadog/android/api/InternalLogger;", "getType", "()Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlockType;", "logEntrySizeExceededError", "", "entrySize", "", "maxEntrySize", "serialize", "serialize$dd_sdk_android_core_release", "Companion", "dd-sdk-android-core_release"})
public final class TLVBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TLVBlockType type;
    @NotNull
    private final byte[] data;
    @NotNull
    private final InternalLogger internalLogger;
    private static final int MAXIMUM_DATA_SIZE_MB = 0xA00000;
    @NotNull
    public static final String BYTE_LENGTH_EXCEEDED_ERROR = "DataBlock length exceeds limit of %s bytes, was %s";

    public TLVBlock(@NotNull TLVBlockType type, @NotNull byte[] data, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.type = type;
        this.data = data;
        this.internalLogger = internalLogger;
    }

    @NotNull
    public final TLVBlockType getType() {
        return this.type;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    @NotNull
    public final InternalLogger getInternalLogger() {
        return this.internalLogger;
    }

    @Nullable
    public final byte[] serialize$dd_sdk_android_core_release(int maxEntrySize) {
        if (this.data.length == 0) {
            return null;
        }
        int typeFieldSize = 2;
        int dataLengthFieldSize = 4;
        int dataFieldSize = this.data.length;
        int entrySize = typeFieldSize + dataLengthFieldSize + dataFieldSize;
        if (entrySize > maxEntrySize) {
            this.logEntrySizeExceededError(entrySize, maxEntrySize);
            return null;
        }
        short tlvTypeAsShort = this.type.getRawValue-Mh2AYeg();
        return ByteBuffer.allocate(entrySize).putShort(tlvTypeAsShort).putInt(dataFieldSize).put(this.data).array();
    }

    public static /* synthetic */ byte[] serialize$dd_sdk_android_core_release$default(TLVBlock tLVBlock, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0xA00000;
        }
        return tLVBlock.serialize$dd_sdk_android_core_release(n);
    }

    private final void logEntrySizeExceededError(int entrySize, int maxEntrySize) {
        InternalLogger internalLogger = this.internalLogger;
        InternalLogger.Target target = InternalLogger.Target.MAINTAINER;
        InternalLogger.Level level = InternalLogger.Level.WARN;
        InternalLogger.DefaultImpls.log$default(internalLogger, level, target, (Function0)new Function0<String>(maxEntrySize, entrySize){
            final /* synthetic */ int $maxEntrySize;
            final /* synthetic */ int $entrySize;
            {
                this.$maxEntrySize = $maxEntrySize;
                this.$entrySize = $entrySize;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = "DataBlock length exceeds limit of %s bytes, was %s";
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{this.$maxEntrySize, this.$entrySize};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                return string2;
            }
        }, null, false, null, 56, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlock$Companion;", "", "()V", "BYTE_LENGTH_EXCEEDED_ERROR", "", "MAXIMUM_DATA_SIZE_MB", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

