/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.tlvformat;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.persistence.file.FileReaderWriter;
import com.datadog.android.core.internal.persistence.tlvformat.TLVBlock;
import com.datadog.android.core.internal.persistence.tlvformat.TLVBlockFileReader;
import com.datadog.android.core.internal.persistence.tlvformat.TLVBlockType;
import com.datadog.android.core.internal.utils.ByteArrayExtKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u0015J \u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006!"}, d2={"Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlockFileReader;", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "fileReaderWriter", "Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;", "(Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;)V", "getFileReaderWriter", "()Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;", "getInternalLogger", "()Lcom/datadog/android/api/InternalLogger;", "logFailedToDeserializeError", "", "logTypeCorruptionError", "shortValue", "", "read", "", "Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlock;", "file", "Ljava/io/File;", "read$dd_sdk_android_core_release", "readBlock", "Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlockFileReader$TLVResult;", "inputArray", "", "currentIndex", "", "readData", "readType", "Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlockType;", "Companion", "TLVResult", "dd-sdk-android-core_release"})
public final class TLVBlockFileReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final FileReaderWriter fileReaderWriter;
    @NotNull
    public static final String CORRUPT_TLV_HEADER_TYPE_ERROR = "TLV header corrupt. Invalid type %s";
    @NotNull
    public static final String FAILED_TO_DESERIALIZE_ERROR = "Failed to deserialize TLV data length";

    public TLVBlockFileReader(@NotNull InternalLogger internalLogger, @NotNull FileReaderWriter fileReaderWriter) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)fileReaderWriter, (String)"fileReaderWriter");
        this.internalLogger = internalLogger;
        this.fileReaderWriter = fileReaderWriter;
    }

    @NotNull
    public final InternalLogger getInternalLogger() {
        return this.internalLogger;
    }

    @NotNull
    public final FileReaderWriter getFileReaderWriter() {
        return this.fileReaderWriter;
    }

    @WorkerThread
    @NotNull
    public final List<TLVBlock> read$dd_sdk_android_core_release(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        byte[] byteArray = (byte[])this.fileReaderWriter.readData(file);
        List blocks = new ArrayList();
        int currentIndex = 0;
        while (currentIndex < byteArray.length && this.readBlock(byteArray, currentIndex) != null) {
            TLVResult<TLVBlock> result;
            blocks.add(result.getData());
            currentIndex = result.getNewIndex();
        }
        return blocks;
    }

    private final TLVResult<TLVBlock> readBlock(byte[] inputArray, int currentIndex) {
        TLVResult<TLVBlockType> tLVResult = this.readType(inputArray, currentIndex);
        if (tLVResult == null) {
            return null;
        }
        TLVResult<TLVBlockType> typeResult = tLVResult;
        TLVResult<byte[]> tLVResult2 = this.readData(inputArray, typeResult.getNewIndex());
        if (tLVResult2 == null) {
            return null;
        }
        TLVResult<byte[]> data = tLVResult2;
        TLVBlock block = new TLVBlock(typeResult.getData(), data.getData(), this.internalLogger);
        return new TLVResult<TLVBlock>(block, data.getNewIndex());
    }

    private final TLVResult<TLVBlockType> readType(byte[] inputArray, int currentIndex) {
        int typeBlockSize = 2;
        int newIndex = currentIndex;
        if ((newIndex += typeBlockSize) > inputArray.length) {
            this.logFailedToDeserializeError();
            return null;
        }
        byte[] bytes = ByteArrayExtKt.copyOfRangeSafe(inputArray, currentIndex, newIndex);
        short shortValue = ByteArrayExtKt.toShort(bytes);
        TLVBlockType tlvHeader = TLVBlockType.Companion.fromValue-xj2QHRw(UShort.constructor-impl((short)shortValue));
        if (tlvHeader == null) {
            this.logTypeCorruptionError(shortValue);
            return null;
        }
        return new TLVResult<TLVBlockType>(tlvHeader, currentIndex + typeBlockSize);
    }

    private final TLVResult<byte[]> readData(byte[] inputArray, int currentIndex) {
        int lengthBlockSize = 4;
        int newIndex = currentIndex + lengthBlockSize;
        if (newIndex > inputArray.length) {
            this.logFailedToDeserializeError();
            return null;
        }
        byte[] lengthInBytes = ByteArrayExtKt.copyOfRangeSafe(inputArray, currentIndex, newIndex);
        int lengthData = ByteArrayExtKt.toInt(lengthInBytes);
        byte[] dataBytes = ByteArrayExtKt.copyOfRangeSafe(inputArray, newIndex, newIndex + lengthData);
        return new TLVResult<byte[]>(dataBytes, newIndex += lengthData);
    }

    private final void logTypeCorruptionError(short shortValue) {
        InternalLogger internalLogger = this.internalLogger;
        InternalLogger.Target target = InternalLogger.Target.MAINTAINER;
        InternalLogger.Level level = InternalLogger.Level.WARN;
        InternalLogger.DefaultImpls.log$default(internalLogger, level, target, (Function0)new Function0<String>(shortValue){
            final /* synthetic */ short $shortValue;
            {
                this.$shortValue = $shortValue;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = "TLV header corrupt. Invalid type %s";
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{this.$shortValue};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                return string2;
            }
        }, null, false, null, 56, null);
    }

    private final void logFailedToDeserializeError() {
        InternalLogger internalLogger = this.internalLogger;
        InternalLogger.Target target = InternalLogger.Target.MAINTAINER;
        InternalLogger.Level level = InternalLogger.Level.WARN;
        InternalLogger.DefaultImpls.log$default(internalLogger, level, target, (Function0)logFailedToDeserializeError.1.INSTANCE, null, false, null, 56, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlockFileReader$Companion;", "", "()V", "CORRUPT_TLV_HEADER_TYPE_ERROR", "", "FAILED_TO_DESERIALIZE_ERROR", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlockFileReader$TLVResult;", "T", "", "data", "newIndex", "", "(Ljava/lang/Object;I)V", "getData", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getNewIndex", "()I", "component1", "component2", "copy", "(Ljava/lang/Object;I)Lcom/datadog/android/core/internal/persistence/tlvformat/TLVBlockFileReader$TLVResult;", "equals", "", "other", "hashCode", "toString", "", "dd-sdk-android-core_release"})
    private static final class TLVResult<T> {
        @NotNull
        private final T data;
        private final int newIndex;

        public TLVResult(@NotNull T data, int newIndex) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            this.data = data;
            this.newIndex = newIndex;
        }

        @NotNull
        public final T getData() {
            return this.data;
        }

        public final int getNewIndex() {
            return this.newIndex;
        }

        @NotNull
        public final T component1() {
            return this.data;
        }

        public final int component2() {
            return this.newIndex;
        }

        @NotNull
        public final TLVResult<T> copy(@NotNull T data, int newIndex) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            return new TLVResult<T>(data, newIndex);
        }

        public static /* synthetic */ TLVResult copy$default(TLVResult tLVResult, Object object, int n, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                object = tLVResult.data;
            }
            if ((n2 & 2) != 0) {
                n = tLVResult.newIndex;
            }
            return tLVResult.copy(object, n);
        }

        @NotNull
        public String toString() {
            return "TLVResult(data=" + this.data + ", newIndex=" + this.newIndex + ")";
        }

        public int hashCode() {
            int result = this.data.hashCode();
            result = result * 31 + Integer.hashCode(this.newIndex);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TLVResult)) {
                return false;
            }
            TLVResult tLVResult = (TLVResult)other;
            if (!Intrinsics.areEqual(this.data, tLVResult.data)) {
                return false;
            }
            return this.newIndex == tLVResult.newIndex;
        }
    }
}

