/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.receiver;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b \u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/core/internal/receiver/ThreadSafeReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "isRegistered", "Ljava/util/concurrent/atomic/AtomicBoolean;", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "registerReceiver", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "filter", "Landroid/content/IntentFilter;", "unregisterReceiver", "", "Companion", "dd-sdk-android-core_release"})
public abstract class ThreadSafeReceiver
extends BroadcastReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean isRegistered = new AtomicBoolean(false);
    public static final int RECEIVER_NOT_EXPORTED_COMPAT = 4;

    @NotNull
    public final AtomicBoolean isRegistered() {
        return this.isRegistered;
    }

    @SuppressLint(value={"WrongConstant", "UnspecifiedRegisterReceiverFlag"})
    @Nullable
    public final Intent registerReceiver(@NotNull Context context, @NotNull IntentFilter filter) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intent intent = Build.VERSION.SDK_INT >= 33 ? context.registerReceiver((BroadcastReceiver)this, filter, 4) : (Build.VERSION.SDK_INT >= 26 ? context.registerReceiver((BroadcastReceiver)this, filter, 4) : context.registerReceiver((BroadcastReceiver)this, filter));
        this.isRegistered.set(true);
        return intent;
    }

    public final void unregisterReceiver(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.isRegistered.compareAndSet(true, false)) {
            context.unregisterReceiver((BroadcastReceiver)this);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/receiver/ThreadSafeReceiver$Companion;", "", "()V", "RECEIVER_NOT_EXPORTED_COMPAT", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

