/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.system;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PowerManager;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.receiver.ThreadSafeReceiver;
import com.datadog.android.core.internal.system.SystemInfo;
import com.datadog.android.core.internal.system.SystemInfoProvider;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/datadog/android/core/internal/system/BroadcastReceiverSystemInfoProvider;", "Lcom/datadog/android/core/internal/receiver/ThreadSafeReceiver;", "Lcom/datadog/android/core/internal/system/SystemInfoProvider;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/InternalLogger;)V", "systemInfo", "Lcom/datadog/android/core/internal/system/SystemInfo;", "getLatestSystemInfo", "handleBatteryIntent", "", "intent", "Landroid/content/Intent;", "handlePowerSaveIntent", "context", "Landroid/content/Context;", "onReceive", "register", "registerIntentFilter", "action", "", "unregister", "Companion", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nBroadcastReceiverSystemInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BroadcastReceiverSystemInfoProvider.kt\ncom/datadog/android/core/internal/system/BroadcastReceiverSystemInfoProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n1#2:128\n*E\n"})
public final class BroadcastReceiverSystemInfoProvider
extends ThreadSafeReceiver
implements SystemInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private SystemInfo systemInfo;
    private static final int DEFAULT_BATTERY_SCALE = 100;
    private static final int BATTERY_UNPLUGGED = -1;
    private static final int BATTERY_LEVEL_UNKNOWN = -1;
    @NotNull
    private static final Set<SystemInfo.BatteryStatus> batteryFullOrChargingStatus;
    @NotNull
    private static final Set<Integer> PLUGGED_IN_STATUS_VALUES;

    public BroadcastReceiverSystemInfoProvider(@NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
        this.systemInfo = new SystemInfo(false, 0, false, false, 15, null);
    }

    public void onReceive(@NotNull Context context, @Nullable Intent intent) {
        String action;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent2 = intent;
        String string = action = intent2 != null ? intent2.getAction() : null;
        if (Intrinsics.areEqual((Object)action, (Object)"android.intent.action.BATTERY_CHANGED")) {
            this.handleBatteryIntent(intent);
        } else if (Intrinsics.areEqual((Object)action, (Object)"android.os.action.POWER_SAVE_MODE_CHANGED")) {
            this.handlePowerSaveIntent(context);
        } else {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.DEBUG, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(action){
                final /* synthetic */ String $action;
                {
                    this.$action = $action;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Received unknown broadcast intent: [" + this.$action + "]";
                }
            }, null, false, null, 56, null);
        }
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    public void register(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.registerIntentFilter(context, "android.intent.action.BATTERY_CHANGED");
        this.registerIntentFilter(context, "android.os.action.POWER_SAVE_MODE_CHANGED");
    }

    @Override
    public void unregister(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.unregisterReceiver(context);
    }

    @Override
    @NotNull
    public SystemInfo getLatestSystemInfo() {
        return this.systemInfo;
    }

    private final void registerIntentFilter(Context context, String action) {
        block0: {
            IntentFilter filter = new IntentFilter();
            filter.addAction(action);
            Intent intent = this.registerReceiver(context, filter);
            if (intent == null) break block0;
            Intent it = intent;
            boolean bl = false;
            this.onReceive(context, it);
        }
    }

    private final void handleBatteryIntent(Intent intent) {
        int status = intent.getIntExtra("status", 1);
        int level = intent.getIntExtra("level", -1);
        int scale = intent.getIntExtra("scale", 100);
        int pluggedStatus = intent.getIntExtra("plugged", -1);
        SystemInfo.BatteryStatus batteryStatus = SystemInfo.BatteryStatus.Companion.fromAndroidStatus(status);
        boolean batteryPresent = intent.getBooleanExtra("present", true);
        int batteryLevel = MathKt.roundToInt((float)((float)level * 100.0f / (float)scale));
        boolean onExternalPowerSource = PLUGGED_IN_STATUS_VALUES.contains(pluggedStatus) || !batteryPresent;
        boolean batteryFullOrCharging = batteryFullOrChargingStatus.contains((Object)batteryStatus);
        this.systemInfo = SystemInfo.copy$default(this.systemInfo, batteryFullOrCharging, batteryLevel, false, onExternalPowerSource, 4, null);
    }

    private final void handlePowerSaveIntent(Context context) {
        PowerManager powerManager;
        Object object = context.getSystemService("power");
        PowerManager powerManager2 = powerManager = object instanceof PowerManager ? (PowerManager)object : null;
        boolean powerSaveMode = powerManager2 != null ? powerManager2.isPowerSaveMode() : false;
        this.systemInfo = SystemInfo.copy$default(this.systemInfo, false, 0, powerSaveMode, false, 11, null);
    }

    static {
        Object[] objectArray = new SystemInfo.BatteryStatus[]{SystemInfo.BatteryStatus.CHARGING, SystemInfo.BatteryStatus.FULL};
        batteryFullOrChargingStatus = SetsKt.setOf((Object[])objectArray);
        objectArray = new Integer[]{1, 4, 2};
        PLUGGED_IN_STATUS_VALUES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/core/internal/system/BroadcastReceiverSystemInfoProvider$Companion;", "", "()V", "BATTERY_LEVEL_UNKNOWN", "", "BATTERY_UNPLUGGED", "DEFAULT_BATTERY_SCALE", "PLUGGED_IN_STATUS_VALUES", "", "batteryFullOrChargingStatus", "Lcom/datadog/android/core/internal/system/SystemInfo$BatteryStatus;", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

