/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.system;

import android.app.UiModeManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.datadog.android.api.context.DeviceType;
import com.datadog.android.core.internal.system.AndroidInfoProvider;
import com.datadog.android.core.internal.system.DefaultAndroidInfoProvider;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nR\u001b\u0010\u000b\u001a\u00020\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0013\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0014\u0010\u0015\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\rR\u001b\u0010\u0017\u001a\u00020\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0018\u0010\rR\u001b\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u000f\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001f\u001a\u00020\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u000f\u001a\u0004\b \u0010\rR\u0014\u0010\"\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\rR\u0014\u0010$\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\r\u00a8\u0006'"}, d2={"Lcom/datadog/android/core/internal/system/DefaultAndroidInfoProvider;", "Lcom/datadog/android/core/internal/system/AndroidInfoProvider;", "appContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "rawDeviceBrand", "", "rawDeviceModel", "rawDeviceId", "rawOsVersion", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "architecture", "getArchitecture", "()Ljava/lang/String;", "architecture$delegate", "Lkotlin/Lazy;", "deviceBrand", "getDeviceBrand", "deviceBrand$delegate", "deviceBuildId", "getDeviceBuildId", "deviceModel", "getDeviceModel", "deviceName", "getDeviceName", "deviceName$delegate", "deviceType", "Lcom/datadog/android/api/context/DeviceType;", "getDeviceType", "()Lcom/datadog/android/api/context/DeviceType;", "deviceType$delegate", "osMajorVersion", "getOsMajorVersion", "osMajorVersion$delegate", "osName", "getOsName", "osVersion", "getOsVersion", "Companion", "dd-sdk-android-core_release"})
public final class DefaultAndroidInfoProvider
implements AndroidInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy deviceType$delegate;
    @NotNull
    private final Lazy deviceName$delegate;
    @NotNull
    private final Lazy deviceBrand$delegate;
    @NotNull
    private final String deviceModel;
    @NotNull
    private final String deviceBuildId;
    @NotNull
    private final String osName;
    @NotNull
    private final String osVersion;
    @NotNull
    private final Lazy osMajorVersion$delegate;
    @NotNull
    private final Lazy architecture$delegate;
    @NotNull
    public static final String FEATURE_GOOGLE_ANDROID_TV = "com.google.android.tv";
    public static final int MIN_TABLET_WIDTH_DP = 800;

    public DefaultAndroidInfoProvider(@NotNull Context appContext, @NotNull String rawDeviceBrand, @NotNull String rawDeviceModel, @NotNull String rawDeviceId, @NotNull String rawOsVersion) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)rawDeviceBrand, (String)"rawDeviceBrand");
        Intrinsics.checkNotNullParameter((Object)rawDeviceModel, (String)"rawDeviceModel");
        Intrinsics.checkNotNullParameter((Object)rawDeviceId, (String)"rawDeviceId");
        Intrinsics.checkNotNullParameter((Object)rawOsVersion, (String)"rawOsVersion");
        this.deviceType$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<DeviceType>(rawDeviceModel, appContext){
            final /* synthetic */ String $rawDeviceModel;
            final /* synthetic */ Context $appContext;
            {
                this.$rawDeviceModel = $rawDeviceModel;
                this.$appContext = $appContext;
                super(0);
            }

            @NotNull
            public final DeviceType invoke() {
                return com.datadog.android.core.internal.system.DefaultAndroidInfoProvider$Companion.access$resolveDeviceType(DefaultAndroidInfoProvider.Companion, this.$rawDeviceModel, this.$appContext);
            }
        }));
        this.deviceName$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DefaultAndroidInfoProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return StringsKt.isBlank((CharSequence)this.this$0.getDeviceBrand()) ? this.this$0.getDeviceModel() : (StringsKt.contains$default((CharSequence)this.this$0.getDeviceModel(), (CharSequence)this.this$0.getDeviceBrand(), (boolean)false, (int)2, null) ? this.this$0.getDeviceModel() : this.this$0.getDeviceBrand() + " " + this.this$0.getDeviceModel());
            }
        }));
        this.deviceBrand$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<String>(rawDeviceBrand){
            final /* synthetic */ String $rawDeviceBrand;
            {
                this.$rawDeviceBrand = $rawDeviceBrand;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke() {
                String string;
                String string2 = this.$rawDeviceBrand;
                if (((CharSequence)string2).length() > 0) {
                    String string3;
                    void it;
                    char c = string2.charAt(0);
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = false;
                    if (Character.isLowerCase((char)it)) {
                        Locale locale = Locale.US;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                        string3 = CharsKt.titlecase((char)it, (Locale)locale);
                    } else {
                        string3 = String.valueOf((char)it);
                    }
                    StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
                    String string4 = string2;
                    int n = 1;
                    String string5 = string4.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    string = stringBuilder2.append(string5).toString();
                } else {
                    string = string2;
                }
                return string;
            }
        }));
        this.deviceModel = rawDeviceModel;
        this.deviceBuildId = rawDeviceId;
        this.osName = "Android";
        this.osVersion = rawOsVersion;
        this.osMajorVersion$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DefaultAndroidInfoProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                char[] cArray = new char[]{'.'};
                return (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)this.this$0.getOsVersion(), (char[])cArray, (boolean)false, (int)0, (int)6, null));
            }
        }));
        this.architecture$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)architecture.2.INSTANCE);
    }

    public DefaultAndroidInfoProvider(@NotNull Context appContext) {
        String string;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        String string4 = Build.BRAND;
        if (string4 == null) {
            string4 = "";
        }
        if ((string3 = Build.MODEL) == null) {
            string3 = "";
        }
        if ((string2 = Build.ID) == null) {
            string2 = "";
        }
        if ((string = Build.VERSION.RELEASE) == null) {
            string = "";
        }
        this(appContext, string4, string3, string2, string);
    }

    @Override
    @NotNull
    public DeviceType getDeviceType() {
        Lazy lazy = this.deviceType$delegate;
        return (DeviceType)((Object)lazy.getValue());
    }

    @Override
    @NotNull
    public String getDeviceName() {
        Lazy lazy = this.deviceName$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getDeviceBrand() {
        Lazy lazy = this.deviceBrand$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @Override
    @NotNull
    public String getDeviceBuildId() {
        return this.deviceBuildId;
    }

    @Override
    @NotNull
    public String getOsName() {
        return this.osName;
    }

    @Override
    @NotNull
    public String getOsVersion() {
        return this.osVersion;
    }

    @Override
    @NotNull
    public String getOsMajorVersion() {
        Lazy lazy = this.osMajorVersion$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getArchitecture() {
        Lazy lazy = this.architecture$delegate;
        return (String)lazy.getValue();
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/datadog/android/core/internal/system/DefaultAndroidInfoProvider$Companion;", "", "()V", "FEATURE_GOOGLE_ANDROID_TV", "", "MIN_TABLET_WIDTH_DP", "", "hasTvFeature", "", "packageManager", "Landroid/content/pm/PackageManager;", "isMobile", "model", "appContext", "Landroid/content/Context;", "isTablet", "isTv", "resolveDeviceType", "Lcom/datadog/android/api/context/DeviceType;", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final DeviceType resolveDeviceType(String model, Context appContext) {
            return this.isTv(appContext) ? DeviceType.TV : (this.isTablet(model, appContext) ? DeviceType.TABLET : (this.isMobile(model, appContext) ? DeviceType.MOBILE : DeviceType.OTHER));
        }

        private final boolean isTv(Context appContext) {
            UiModeManager uiModeManager;
            Object object = appContext.getSystemService("uimode");
            UiModeManager uiModeManager2 = uiModeManager = object instanceof UiModeManager ? (UiModeManager)object : null;
            boolean bl = uiModeManager2 != null ? uiModeManager2.getCurrentModeType() == 4 : false;
            if (bl) {
                return true;
            }
            PackageManager packageManager = appContext.getPackageManager();
            Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"appContext.packageManager");
            return this.hasTvFeature(packageManager);
        }

        private final boolean hasTvFeature(PackageManager packageManager) {
            return packageManager.hasSystemFeature("android.software.leanback") ? true : packageManager.hasSystemFeature(DefaultAndroidInfoProvider.FEATURE_GOOGLE_ANDROID_TV);
        }

        private final boolean isTablet(String model, Context appContext) {
            String string = model;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            String $this$isTablet_u24lambda_u240 = string2;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)$this$isTablet_u24lambda_u240, (CharSequence)"tablet", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)$this$isTablet_u24lambda_u240, (CharSequence)"sm-t", (boolean)false, (int)2, null)) {
                return true;
            }
            return appContext.getResources().getConfiguration().smallestScreenWidthDp >= 800;
        }

        private final boolean isMobile(String model, Context appContext) {
            TelephonyManager telephonyManager;
            String string = model;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"phone", (boolean)false, (int)2, null)) {
                return true;
            }
            Object object = appContext.getSystemService("phone");
            TelephonyManager telephonyManager2 = telephonyManager = object instanceof TelephonyManager ? (TelephonyManager)object : null;
            return !(telephonyManager2 != null ? telephonyManager2.getPhoneType() == 0 : false);
        }

        public static final /* synthetic */ DeviceType access$resolveDeviceType(Companion $this, String model, Context appContext) {
            return $this.resolveDeviceType(model, appContext);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

