/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.utils;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.utils.ByteArrayExtKt;
import com.datadog.android.lint.InternalApi;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a4\u0010\u0005\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001e\u0010\r\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0003H\u0000\u001a6\u0010\u0011\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\u00012\b\b\u0002\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u0017*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\f\u0010\u0019\u001a\u00020\u0003*\u00020\u0001H\u0000\u001a\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0001H\u0000\u001a\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0001H\u0000\u00a8\u0006\u001e"}, d2={"copyOfRangeSafe", "", "fromIndex", "", "toIndex", "copyTo", "", "srcPos", "dest", "destPos", "length", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "indexOf", "b", "", "startIndex", "join", "", "separator", "prefix", "suffix", "split", "", "delimiter", "toInt", "toLong", "", "toShort", "", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nByteArrayExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteArrayExt.kt\ncom/datadog/android/core/internal/utils/ByteArrayExtKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1#2:181\n*E\n"})
public final class ByteArrayExtKt {
    @NotNull
    public static final List<byte[]> split(@NotNull byte[] $this$split, byte delimiter, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)$this$split, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        List result = new ArrayList();
        int offset = 0;
        int nextIndex = 0;
        do {
            int length;
            int n = length = (nextIndex = ByteArrayExtKt.indexOf($this$split, delimiter, offset)) >= 0 ? nextIndex - offset : $this$split.length - offset;
            if (length > 0) {
                byte[] subArray = new byte[length];
                ByteArrayExtKt.copyTo($this$split, offset, subArray, 0, length, internalLogger);
                result.add(subArray);
            }
            offset = nextIndex + 1;
        } while (nextIndex != -1);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @InternalApi
    @NotNull
    public static final byte[] join(@NotNull Collection<byte[]> $this$join, @NotNull byte[] separator, @NotNull byte[] prefix, @NotNull byte[] suffix, @NotNull InternalLogger internalLogger) {
        Object object;
        Intrinsics.checkNotNullParameter($this$join, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Iterable iterable = $this$join;
        int n = 0;
        for (Object t : iterable) {
            void it;
            object = (byte[])t;
            int n2 = n;
            boolean bl = false;
            int n3 = ((void)it).length;
            n = n2 + n3;
        }
        int dataSize = n;
        int separatorsSize = !$this$join.isEmpty() ? separator.length * ($this$join.size() - 1) : 0;
        int resultSize = prefix.length + dataSize + separatorsSize + suffix.length;
        byte[] result = new byte[resultSize];
        int offset = 0;
        ByteArrayExtKt.copyTo(prefix, 0, result, 0, prefix.length, internalLogger);
        offset += prefix.length;
        object = CollectionsKt.withIndex((Iterable)$this$join).iterator();
        while (object.hasNext()) {
            IndexedValue item = (IndexedValue)object.next();
            ByteArrayExtKt.copyTo((byte[])item.getValue(), 0, result, offset, ((byte[])item.getValue()).length, internalLogger);
            offset += ((byte[])item.getValue()).length;
            if (item.getIndex() == $this$join.size() - 1) continue;
            ByteArrayExtKt.copyTo(separator, 0, result, offset, separator.length, internalLogger);
            offset += separator.length;
        }
        ByteArrayExtKt.copyTo(suffix, 0, result, offset, suffix.length, internalLogger);
        return result;
    }

    public static /* synthetic */ byte[] join$default(Collection collection, byte[] byArray, byte[] byArray2, byte[] byArray3, InternalLogger internalLogger, int n, Object object) {
        if ((n & 2) != 0) {
            byArray2 = new byte[]{};
        }
        if ((n & 4) != 0) {
            byArray3 = new byte[]{};
        }
        return ByteArrayExtKt.join(collection, byArray, byArray2, byArray3, internalLogger);
    }

    public static final int indexOf(@NotNull byte[] $this$indexOf, byte b, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$indexOf, (String)"<this>");
        if (startIndex < 0) {
            return -1;
        }
        int n = $this$indexOf.length;
        for (int i = startIndex; i < n; ++i) {
            if ($this$indexOf[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static /* synthetic */ int indexOf$default(byte[] byArray, byte by, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return ByteArrayExtKt.indexOf(byArray, by, n);
    }

    public static final boolean copyTo(@NotNull byte[] $this$copyTo, int srcPos, @NotNull byte[] dest, int destPos, int length, @NotNull InternalLogger internalLogger) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$copyTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        if (destPos + length > dest.length) {
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, (Function0)copyTo.1.INSTANCE, null, false, null, 56, null);
            bl = false;
        } else if (srcPos + length > $this$copyTo.length) {
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, (Function0)copyTo.2.INSTANCE, null, false, null, 56, null);
            bl = false;
        } else {
            System.arraycopy($this$copyTo, srcPos, dest, destPos, length);
            bl = true;
        }
        return bl;
    }

    public static final long toLong(@NotNull byte[] $this$toLong) {
        Intrinsics.checkNotNullParameter((Object)$this$toLong, (String)"<this>");
        return ByteBuffer.wrap($this$toLong).getLong();
    }

    public static final int toInt(@NotNull byte[] $this$toInt) {
        Intrinsics.checkNotNullParameter((Object)$this$toInt, (String)"<this>");
        return ByteBuffer.wrap($this$toInt).getInt();
    }

    public static final short toShort(@NotNull byte[] $this$toShort) {
        Intrinsics.checkNotNullParameter((Object)$this$toShort, (String)"<this>");
        return ByteBuffer.wrap($this$toShort).getShort();
    }

    @NotNull
    public static final byte[] copyOfRangeSafe(@NotNull byte[] $this$copyOfRangeSafe, int fromIndex, int toIndex) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$copyOfRangeSafe, (String)"<this>");
        try {
            byArray = $this$copyOfRangeSafe;
            byArray = ArraysKt.copyOfRange((byte[])byArray, (int)fromIndex, (int)toIndex);
        }
        catch (IndexOutOfBoundsException e) {
            byArray = new byte[]{};
        }
        catch (IllegalArgumentException e) {
            byArray = new byte[]{};
        }
        return byArray;
    }
}

