/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.utils;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.utils.MapUtilsKt;
import com.datadog.android.core.internal.utils.MiscUtilsKt;
import com.datadog.android.lint.InternalApi;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0007J.\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\t*\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/core/internal/utils/JsonSerializer;", "", "()V", "ITEM_SERIALIZATION_ERROR", "", "toJsonElement", "Lcom/google/gson/JsonElement;", "item", "safeMapValuesToJson", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "dd-sdk-android-core_release"})
@InternalApi
@SourceDebugExtension(value={"SMAP\nMiscUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MiscUtils.kt\ncom/datadog/android/core/internal/utils/JsonSerializer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,186:1\n215#2,2:187\n*S KotlinDebug\n*F\n+ 1 MiscUtils.kt\ncom/datadog/android/core/internal/utils/JsonSerializer\n*L\n108#1:187,2\n*E\n"})
public final class JsonSerializer {
    @NotNull
    public static final JsonSerializer INSTANCE = new JsonSerializer();
    @NotNull
    public static final String ITEM_SERIALIZATION_ERROR = "Error serializing value for key %s, value was dropped.";

    private JsonSerializer() {
    }

    @InternalApi
    @NotNull
    public final JsonElement toJsonElement(@Nullable Object item) {
        JsonElement jsonElement;
        Object object = item;
        if (Intrinsics.areEqual((Object)object, (Object)MapUtilsKt.getNULL_MAP_VALUE())) {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNull, (String)"INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        } else if (object == null) {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNull, (String)"INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        } else if (Intrinsics.areEqual((Object)object, (Object)JsonNull.INSTANCE)) {
            JsonNull jsonNull = JsonNull.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNull, (String)"INSTANCE");
            jsonElement = (JsonElement)jsonNull;
        } else {
            jsonElement = object instanceof Boolean ? (JsonElement)new JsonPrimitive((Boolean)item) : (object instanceof Integer ? (JsonElement)new JsonPrimitive((Number)item) : (object instanceof Long ? (JsonElement)new JsonPrimitive((Number)item) : (object instanceof Float ? (JsonElement)new JsonPrimitive((Number)item) : (object instanceof Double ? (JsonElement)new JsonPrimitive((Number)item) : (object instanceof String ? (JsonElement)new JsonPrimitive((String)item) : (object instanceof Date ? (JsonElement)new JsonPrimitive((Number)((Date)item).getTime()) : (object instanceof JsonArray ? (JsonElement)item : (object instanceof Iterable ? MiscUtilsKt.toJsonArray((Iterable)item) : (object instanceof Map ? MiscUtilsKt.toJsonObject((Map)item) : (object instanceof JsonObject ? (JsonElement)item : (object instanceof JsonPrimitive ? (JsonElement)item : (object instanceof JSONObject ? MiscUtilsKt.toJsonObject((JSONObject)item) : (object instanceof JSONArray ? MiscUtilsKt.toJsonArray((JSONArray)item) : (JsonElement)new JsonPrimitive(item.toString()))))))))))))));
        }
        return jsonElement;
    }

    @InternalApi
    @NotNull
    public final Map<String, JsonElement> safeMapValuesToJson(@NotNull Map<String, ? extends Object> $this$safeMapValuesToJson, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter($this$safeMapValuesToJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Map result = new LinkedHashMap();
        Map<String, ? extends Object> $this$forEach$iv = $this$safeMapValuesToJson;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> it = element$iv = iterator.next();
            boolean bl = false;
            try {
                Map map = result;
                pair = TuplesKt.to((Object)it.getKey(), (Object)INSTANCE.toJsonElement(it.getValue()));
                map.put(pair.getFirst(), pair.getSecond());
            }
            catch (Exception e) {
                pair = new Pair[]{InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])pair), (Function0)new Function0<String>(it){
                    final /* synthetic */ Map.Entry<String, Object> $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        String string = "Error serializing value for key %s, value was dropped.";
                        Locale locale = Locale.US;
                        Object[] objectArray = new Object[]{this.$it.getKey()};
                        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        return string2;
                    }
                }, (Throwable)e, false, null, 48, null);
            }
        }
        return result;
    }
}

