/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.utils;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.utils.JsonSerializer;
import com.datadog.android.core.internal.utils.MiscUtilsKt;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0080\b\u00f8\u0001\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u0000\u001a\u001a\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f*\u00020\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000e*\u0004\u0018\u00010\u000eH\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\u0013H\u0000\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0014H\u0000\u001a\u0014\u0010\u0015\u001a\u00020\u0012*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\fH\u0000\u001a\f\u0010\u0015\u001a\u00020\u0012*\u00020\u0016H\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0017"}, d2={"retryWithDelay", "", "block", "Lkotlin/Function0;", "times", "", "loopsDelayInNanos", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "retryDelayNs", "asDeepMap", "", "", "", "Lcom/google/gson/JsonObject;", "fromJsonElement", "toJsonArray", "Lcom/google/gson/JsonElement;", "", "Lorg/json/JSONArray;", "toJsonObject", "Lorg/json/JSONObject;", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nMiscUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MiscUtils.kt\ncom/datadog/android/core/internal/utils/MiscUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,186:1\n37#1,24:187\n1855#2,2:211\n1855#2,2:215\n215#3,2:213\n*S KotlinDebug\n*F\n+ 1 MiscUtils.kt\ncom/datadog/android/core/internal/utils/MiscUtilsKt\n*L\n27#1:187,24\n147#1:211,2\n181#1:215,2\n155#1:213,2\n*E\n"})
public final class MiscUtilsKt {
    public static final boolean retryWithDelay(int times, long retryDelayNs, @NotNull InternalLogger internalLogger, @NotNull Function0<Boolean> block) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$retryWithDelay = false;
        int retryCounter$iv = 1;
        boolean wasSuccessful$iv = false;
        long loopTimeOrigin$iv = System.nanoTime() - retryDelayNs;
        while (retryCounter$iv <= times && !wasSuccessful$iv) {
            boolean bl;
            if (System.nanoTime() - loopTimeOrigin$iv < retryDelayNs) continue;
            try {
                bl = (Boolean)block.invoke();
            }
            catch (Exception e$iv) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)retryWithDelay.1.INSTANCE, (Throwable)e$iv, false, null, 48, null);
                bl = false;
            }
            wasSuccessful$iv = bl;
            loopTimeOrigin$iv = System.nanoTime();
            ++retryCounter$iv;
        }
        return wasSuccessful$iv;
    }

    public static final boolean retryWithDelay(@NotNull Function0<Boolean> block, int times, long loopsDelayInNanos, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        boolean $i$f$retryWithDelay = false;
        int retryCounter = 1;
        boolean wasSuccessful = false;
        long loopTimeOrigin = System.nanoTime() - loopsDelayInNanos;
        while (retryCounter <= times && !wasSuccessful) {
            boolean bl;
            if (System.nanoTime() - loopTimeOrigin < loopsDelayInNanos) continue;
            try {
                bl = (Boolean)block.invoke();
            }
            catch (Exception e) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)retryWithDelay.1.INSTANCE, (Throwable)e, false, null, 48, null);
                bl = false;
            }
            wasSuccessful = bl;
            loopTimeOrigin = System.nanoTime();
            ++retryCounter;
        }
        return wasSuccessful;
    }

    @Nullable
    public static final Object fromJsonElement(@Nullable Object $this$fromJsonElement) {
        Map<String, Object> map = $this$fromJsonElement;
        return map instanceof JsonNull ? null : (map instanceof JsonPrimitive ? (((JsonPrimitive)$this$fromJsonElement).isBoolean() ? Boolean.valueOf(((JsonPrimitive)$this$fromJsonElement).getAsBoolean()) : (((JsonPrimitive)$this$fromJsonElement).isNumber() ? ((JsonPrimitive)$this$fromJsonElement).getAsNumber() : (((JsonPrimitive)$this$fromJsonElement).isString() ? ((JsonPrimitive)$this$fromJsonElement).getAsString() : $this$fromJsonElement))) : (map instanceof JsonObject ? MiscUtilsKt.asDeepMap((JsonObject)$this$fromJsonElement) : $this$fromJsonElement));
    }

    @NotNull
    public static final JsonElement toJsonArray(@NotNull Iterable<?> $this$toJsonArray) {
        Intrinsics.checkNotNullParameter($this$toJsonArray, (String)"<this>");
        JsonArray array = new JsonArray();
        Iterable<?> $this$forEach$iv = $this$toJsonArray;
        boolean $i$f$forEach = false;
        Iterator<?> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            array.add(JsonSerializer.INSTANCE.toJsonElement(it));
        }
        return (JsonElement)array;
    }

    @NotNull
    public static final JsonElement toJsonObject(@NotNull Map<?, ?> $this$toJsonObject) {
        Intrinsics.checkNotNullParameter($this$toJsonObject, (String)"<this>");
        JsonObject obj = new JsonObject();
        Map<?, ?> $this$forEach$iv = $this$toJsonObject;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<?, ?>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> element$iv;
            Map.Entry<?, ?> it = element$iv = iterator.next();
            boolean bl = false;
            obj.add(String.valueOf(it.getKey()), JsonSerializer.INSTANCE.toJsonElement(it.getValue()));
        }
        return (JsonElement)obj;
    }

    @NotNull
    public static final JsonElement toJsonObject(@NotNull JSONObject $this$toJsonObject) {
        Intrinsics.checkNotNullParameter((Object)$this$toJsonObject, (String)"<this>");
        JsonObject obj = new JsonObject();
        Iterator iterator = $this$toJsonObject.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys()");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String key = (String)iterator2.next();
            obj.add(key, JsonSerializer.INSTANCE.toJsonElement($this$toJsonObject.get(key)));
        }
        return (JsonElement)obj;
    }

    @NotNull
    public static final JsonElement toJsonArray(@NotNull JSONArray $this$toJsonArray) {
        Intrinsics.checkNotNullParameter((Object)$this$toJsonArray, (String)"<this>");
        JsonArray obj = new JsonArray();
        int n = $this$toJsonArray.length();
        for (int index = 0; index < n; ++index) {
            obj.add(JsonSerializer.INSTANCE.toJsonElement($this$toJsonArray.get(index)));
        }
        return (JsonElement)obj;
    }

    @NotNull
    public static final Map<String, Object> asDeepMap(@NotNull JsonObject $this$asDeepMap) {
        Intrinsics.checkNotNullParameter((Object)$this$asDeepMap, (String)"<this>");
        Map map = new LinkedHashMap();
        Set set = $this$asDeepMap.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet()");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object k;
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Map map2 = map;
            Intrinsics.checkNotNullExpressionValue(it.getKey(), (String)"it.key");
            Object object = MiscUtilsKt.fromJsonElement(it.getValue());
            map2.put(k, object);
        }
        return map;
    }
}

