/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.utils;

import android.content.Context;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.data.upload.UploadWorker;
import com.datadog.android.core.internal.utils.WorkManagerUtilsKt;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a \u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"CANCEL_ERROR_MESSAGE", "", "DELAY_MS", "", "SETUP_ERROR_MESSAGE", "TAG_DATADOG_UPLOAD", "UPLOAD_WORKER_NAME", "UPLOAD_WORKER_WAS_SCHEDULED", "cancelUploadWorker", "", "context", "Landroid/content/Context;", "instanceName", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "triggerUploadWorker", "dd-sdk-android-core_release"})
public final class WorkManagerUtilsKt {
    @NotNull
    public static final String CANCEL_ERROR_MESSAGE = "Error cancelling the UploadWorker";
    @NotNull
    public static final String SETUP_ERROR_MESSAGE = "Error while trying to setup the UploadWorker";
    @NotNull
    public static final String UPLOAD_WORKER_WAS_SCHEDULED = "UploadWorker was scheduled.";
    @NotNull
    public static final String UPLOAD_WORKER_NAME = "DatadogUploadWorker";
    @NotNull
    public static final String TAG_DATADOG_UPLOAD = "DatadogBackgroundUpload";
    public static final long DELAY_MS = 5000L;

    public static final void cancelUploadWorker(@NotNull Context context, @NotNull String instanceName, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)instanceName, (String)"instanceName");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        try {
            WorkManager workManager = WorkManager.getInstance((Context)context);
            Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(context)");
            WorkManager workManager2 = workManager;
            workManager2.cancelAllWorkByTag("DatadogBackgroundUpload/" + instanceName);
        }
        catch (IllegalStateException e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)cancelUploadWorker.1.INSTANCE, (Throwable)e, false, null, 48, null);
        }
    }

    public static final void triggerUploadWorker(@NotNull Context context, @NotNull String instanceName, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)instanceName, (String)"instanceName");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        try {
            WorkManager workManager = WorkManager.getInstance((Context)context);
            Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(context)");
            WorkManager workManager2 = workManager;
            Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.NOT_ROAMING).build();
            OneTimeWorkRequest.Builder builder = (OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(UploadWorker.class).setConstraints(constraints)).addTag("DatadogBackgroundUpload/" + instanceName)).setInitialDelay(5000L, TimeUnit.MILLISECONDS);
            Data data = new Data.Builder().putString("_dd.sdk.instanceName", instanceName).build();
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"Builder().putString(Uplo\u2026ME, instanceName).build()");
            OneTimeWorkRequest uploadWorkRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)builder.setInputData(data)).build();
            workManager2.enqueueUniqueWork(UPLOAD_WORKER_NAME, ExistingWorkPolicy.REPLACE, uploadWorkRequest);
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.INFO, InternalLogger.Target.MAINTAINER, (Function0)triggerUploadWorker.1.INSTANCE, null, false, null, 56, null);
        }
        catch (Exception e) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)triggerUploadWorker.2.INSTANCE, (Throwable)e, false, null, 48, null);
        }
    }
}

