/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.sampling;

import androidx.annotation.FloatRange;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.sampling.Sampler;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.UnsignedKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u0015*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0015B%\b\u0016\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB%\b\u0016\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB'\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r\u00a2\u0006\u0002\u0010\u000eJ\r\u0010\u000f\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/core/sampling/DeterministicSampler;", "T", "", "Lcom/datadog/android/core/sampling/Sampler;", "idConverter", "Lkotlin/Function1;", "Lkotlin/ULong;", "sampleRate", "", "(Lkotlin/jvm/functions/Function1;F)V", "", "(Lkotlin/jvm/functions/Function1;D)V", "sampleRateProvider", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getSampleRate", "()Ljava/lang/Float;", "sample", "", "item", "(Ljava/lang/Object;)Z", "Companion", "dd-sdk-android-core_release"})
public class DeterministicSampler<T>
implements Sampler<T> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<T, ULong> idConverter;
    @NotNull
    private final Function0<Float> sampleRateProvider;
    @Deprecated
    public static final float SAMPLE_ALL_RATE = 100.0f;
    private static final long SAMPLER_HASHER = 1111111111111111111L;
    private static final long MAX_ID = -1L;

    public DeterministicSampler(@NotNull Function1<? super T, ULong> idConverter, @NotNull Function0<Float> sampleRateProvider) {
        Intrinsics.checkNotNullParameter(idConverter, (String)"idConverter");
        Intrinsics.checkNotNullParameter(sampleRateProvider, (String)"sampleRateProvider");
        this.idConverter = idConverter;
        this.sampleRateProvider = sampleRateProvider;
    }

    public DeterministicSampler(@NotNull Function1<? super T, ULong> idConverter, final @FloatRange(from=0.0, to=100.0) float sampleRate) {
        Intrinsics.checkNotNullParameter(idConverter, (String)"idConverter");
        this(idConverter, (Function0<Float>)((Function0)new Function0<Float>(){

            @NotNull
            public final Float invoke() {
                return Float.valueOf(sampleRate);
            }
        }));
    }

    public DeterministicSampler(@NotNull Function1<? super T, ULong> idConverter, @FloatRange(from=0.0, to=100.0) double sampleRate) {
        Intrinsics.checkNotNullParameter(idConverter, (String)"idConverter");
        this(idConverter, (float)sampleRate);
    }

    @Override
    public boolean sample(@NotNull T item) {
        long threshold;
        long hash;
        Intrinsics.checkNotNullParameter(item, (String)"item");
        float sampleRate = this.getSampleRate().floatValue();
        return sampleRate >= 100.0f ? true : (sampleRate <= 0.0f ? false : Long.compareUnsigned(hash = ULong.constructor-impl((long)(((ULong)this.idConverter.invoke(item)).unbox-impl() * 1111111111111111111L)), threshold = UnsignedKt.doubleToULong((double)(UnsignedKt.ulongToDouble((long)-1L) * (double)sampleRate / (double)100.0f))) < 0);
    }

    @Override
    @NotNull
    public Float getSampleRate() {
        float f;
        float rawSampleRate = ((Number)this.sampleRateProvider.invoke()).floatValue();
        if (rawSampleRate < 0.0f) {
            InternalLogger.DefaultImpls.log$default(InternalLogger.Companion.getUNBOUND(), InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(rawSampleRate){
                final /* synthetic */ float $rawSampleRate;
                {
                    this.$rawSampleRate = $rawSampleRate;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Sample rate value provided " + this.$rawSampleRate + " is below 0, setting it to 0.";
                }
            }, null, false, null, 56, null);
            f = 0.0f;
        } else if (rawSampleRate > 100.0f) {
            InternalLogger.DefaultImpls.log$default(InternalLogger.Companion.getUNBOUND(), InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(rawSampleRate){
                final /* synthetic */ float $rawSampleRate;
                {
                    this.$rawSampleRate = $rawSampleRate;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Sample rate value provided " + this.$rawSampleRate + " is above 100, setting it to 100.";
                }
            }, null, false, null, 56, null);
            f = 100.0f;
        } else {
            f = rawSampleRate;
        }
        return Float.valueOf(f);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082T\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0016\u0010\u0006\u001a\u00020\u0004X\u0082T\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\t"}, d2={"Lcom/datadog/android/core/sampling/DeterministicSampler$Companion;", "", "()V", "MAX_ID", "Lkotlin/ULong;", "J", "SAMPLER_HASHER", "SAMPLE_ALL_RATE", "", "dd-sdk-android-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

