/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.sampling;

import androidx.annotation.FloatRange;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.sampling.RateBasedSampler;
import com.datadog.android.core.sampling.Sampler;
import java.security.SecureRandom;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u0018*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0018B\u0011\b\u0016\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0011\b\u0016\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0013\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\u0002\u0010\u000bJ\r\u0010\u0012\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/core/sampling/RateBasedSampler;", "T", "", "Lcom/datadog/android/core/sampling/Sampler;", "sampleRate", "", "(F)V", "", "(D)V", "sampleRateProvider", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "random", "Ljava/security/SecureRandom;", "getRandom", "()Ljava/security/SecureRandom;", "random$delegate", "Lkotlin/Lazy;", "getSampleRate", "()Ljava/lang/Float;", "sample", "", "item", "(Ljava/lang/Object;)Z", "Companion", "dd-sdk-android-core_release"})
public class RateBasedSampler<T>
implements Sampler<T> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Float> sampleRateProvider;
    @NotNull
    private final Lazy random$delegate;
    @Deprecated
    public static final float SAMPLE_ALL_RATE = 100.0f;

    public RateBasedSampler(@NotNull Function0<Float> sampleRateProvider) {
        Intrinsics.checkNotNullParameter(sampleRateProvider, (String)"sampleRateProvider");
        this.sampleRateProvider = sampleRateProvider;
        this.random$delegate = LazyKt.lazy((Function0)random.2.INSTANCE);
    }

    public RateBasedSampler(final @FloatRange(from=0.0, to=100.0) float sampleRate) {
        this((Function0<Float>)((Function0)new Function0<Float>(){

            @NotNull
            public final Float invoke() {
                return Float.valueOf(sampleRate);
            }
        }));
    }

    public RateBasedSampler(@FloatRange(from=0.0, to=100.0) double sampleRate) {
        this((float)sampleRate);
    }

    private final SecureRandom getRandom() {
        Lazy lazy = this.random$delegate;
        return (SecureRandom)lazy.getValue();
    }

    @Override
    public boolean sample(@NotNull T item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        float sampleRate = this.getSampleRate().floatValue();
        return sampleRate == 0.0f ? false : (sampleRate == 100.0f ? true : this.getRandom().nextFloat() * (float)100 <= sampleRate);
    }

    @Override
    @NotNull
    public Float getSampleRate() {
        float f;
        float rawSampleRate = ((Number)this.sampleRateProvider.invoke()).floatValue();
        if (rawSampleRate < 0.0f) {
            InternalLogger.DefaultImpls.log$default(InternalLogger.Companion.getUNBOUND(), InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(rawSampleRate){
                final /* synthetic */ float $rawSampleRate;
                {
                    this.$rawSampleRate = $rawSampleRate;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Sample rate value provided " + this.$rawSampleRate + " is below 0, setting it to 0.";
                }
            }, null, false, null, 56, null);
            f = 0.0f;
        } else if (rawSampleRate > 100.0f) {
            InternalLogger.DefaultImpls.log$default(InternalLogger.Companion.getUNBOUND(), InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(rawSampleRate){
                final /* synthetic */ float $rawSampleRate;
                {
                    this.$rawSampleRate = $rawSampleRate;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Sample rate value provided " + this.$rawSampleRate + " is above 100, setting it to 100.";
                }
            }, null, false, null, 56, null);
            f = 100.0f;
        } else {
            f = rawSampleRate;
        }
        return Float.valueOf(f);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/sampling/RateBasedSampler$Companion;", "", "()V", "SAMPLE_ALL_RATE", "", "dd-sdk-android-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

