/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.ndk.internal;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.NetworkInfo;
import com.datadog.android.api.context.UserInfo;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.core.internal.persistence.Deserializer;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FileReader;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.ndk.internal.DatadogNdkCrashHandler;
import com.datadog.android.ndk.internal.NdkCrashHandler;
import com.datadog.android.ndk.internal.NdkCrashLog;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u000f\b\u0000\u0018\u0000 Q2\u00020\u0001:\u0001QB\u0081\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0007\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014\u0012\b\b\u0002\u0010\u0016\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0003J\b\u0010@\u001a\u00020;H\u0002J\b\u0010A\u001a\u00020;H\u0002J&\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0C2\b\u0010\"\u001a\u0004\u0018\u00010\u00152\u0006\u0010D\u001a\u00020\tH\u0002J\u0018\u0010E\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J@\u0010F\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\b\u0010D\u001a\u0004\u0018\u00010\t2\b\u0010G\u001a\u0004\u0018\u00010\u00152\b\u0010'\u001a\u0004\u0018\u00010\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010>\u001a\u00020?H\u0003J\b\u0010H\u001a\u00020;H\u0016J\b\u0010I\u001a\u00020;H\u0003J \u0010J\u001a\u0004\u0018\u00010\b2\u0006\u0010K\u001a\u00020\u00032\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0003JH\u0010M\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010N\u001a\u00020\b2\u0012\u0010O\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0C2\u0006\u0010D\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\b\u0010'\u001a\u0004\u0018\u00010\rH\u0003J(\u0010P\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010N\u001a\u00020\b2\u0006\u0010D\u001a\u00020\t2\u0006\u0010G\u001a\u00020\u0015H\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010'\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0014\u0010\u0016\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u000202X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u000202X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00104\"\u0004\b9\u00106R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/datadog/android/ndk/internal/DatadogNdkCrashHandler;", "Lcom/datadog/android/ndk/internal/NdkCrashHandler;", "storageDir", "Ljava/io/File;", "dataPersistenceExecutorService", "Ljava/util/concurrent/ExecutorService;", "ndkCrashLogDeserializer", "Lcom/datadog/android/core/internal/persistence/Deserializer;", "", "Lcom/datadog/android/ndk/internal/NdkCrashLog;", "networkInfoDeserializer", "Lcom/datadog/android/api/context/NetworkInfo;", "userInfoDeserializer", "Lcom/datadog/android/api/context/UserInfo;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "envFileReader", "Lcom/datadog/android/core/internal/persistence/file/FileReader;", "", "lastRumViewEventProvider", "Lkotlin/Function0;", "Lcom/google/gson/JsonObject;", "nativeCrashSourceType", "(Ljava/io/File;Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/core/internal/persistence/Deserializer;Lcom/datadog/android/core/internal/persistence/Deserializer;Lcom/datadog/android/core/internal/persistence/Deserializer;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/core/internal/persistence/file/FileReader;Lkotlin/jvm/functions/Function0;Ljava/lang/String;)V", "lastNdkCrashLog", "getLastNdkCrashLog$dd_sdk_android_core_release", "()Lcom/datadog/android/ndk/internal/NdkCrashLog;", "setLastNdkCrashLog$dd_sdk_android_core_release", "(Lcom/datadog/android/ndk/internal/NdkCrashLog;)V", "lastNetworkInfo", "getLastNetworkInfo$dd_sdk_android_core_release", "()Lcom/datadog/android/api/context/NetworkInfo;", "setLastNetworkInfo$dd_sdk_android_core_release", "(Lcom/datadog/android/api/context/NetworkInfo;)V", "lastRumViewEvent", "getLastRumViewEvent$dd_sdk_android_core_release", "()Lcom/google/gson/JsonObject;", "setLastRumViewEvent$dd_sdk_android_core_release", "(Lcom/google/gson/JsonObject;)V", "lastUserInfo", "getLastUserInfo$dd_sdk_android_core_release", "()Lcom/datadog/android/api/context/UserInfo;", "setLastUserInfo$dd_sdk_android_core_release", "(Lcom/datadog/android/api/context/UserInfo;)V", "getNativeCrashSourceType$dd_sdk_android_core_release", "()Ljava/lang/String;", "ndkCrashDataDirectory", "getNdkCrashDataDirectory$dd_sdk_android_core_release", "()Ljava/io/File;", "processedForLogs", "", "getProcessedForLogs$dd_sdk_android_core_release", "()Z", "setProcessedForLogs$dd_sdk_android_core_release", "(Z)V", "processedForRum", "getProcessedForRum$dd_sdk_android_core_release", "setProcessedForRum$dd_sdk_android_core_release", "checkAndHandleNdkCrashReport", "", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "reportTarget", "Lcom/datadog/android/ndk/internal/NdkCrashHandler$ReportTarget;", "clearAllReferences", "clearCrashLog", "generateLogAttributes", "", "ndkCrashLog", "handleNdkCrash", "handleNdkCrashLog", "lastViewEvent", "prepareData", "readCrashData", "readFileContent", "file", "fileReader", "sendCrashLogEvent", "errorLogMessage", "logAttributes", "sendCrashRumEvent", "Companion", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nDatadogNdkCrashHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatadogNdkCrashHandler.kt\ncom/datadog/android/ndk/internal/DatadogNdkCrashHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,404:1\n13309#2:405\n13310#2:407\n13309#2,2:408\n1#3:406\n*S KotlinDebug\n*F\n+ 1 DatadogNdkCrashHandler.kt\ncom/datadog/android/ndk/internal/DatadogNdkCrashHandler\n*L\n80#1:405\n80#1:407\n325#1:408,2\n*E\n"})
public final class DatadogNdkCrashHandler
implements NdkCrashHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutorService dataPersistenceExecutorService;
    @NotNull
    private final Deserializer<String, NdkCrashLog> ndkCrashLogDeserializer;
    @NotNull
    private final Deserializer<String, NetworkInfo> networkInfoDeserializer;
    @NotNull
    private final Deserializer<String, UserInfo> userInfoDeserializer;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final FileReader<byte[]> envFileReader;
    @NotNull
    private final Function0<JsonObject> lastRumViewEventProvider;
    @NotNull
    private final String nativeCrashSourceType;
    @NotNull
    private final File ndkCrashDataDirectory;
    @Nullable
    private JsonObject lastRumViewEvent;
    @Nullable
    private UserInfo lastUserInfo;
    @Nullable
    private NetworkInfo lastNetworkInfo;
    @Nullable
    private NdkCrashLog lastNdkCrashLog;
    private boolean processedForLogs;
    private boolean processedForRum;
    @NotNull
    private static final String RUM_VIEW_EVENT_FILE_NAME = "last_view_event";
    @NotNull
    public static final String CRASH_DATA_FILE_NAME = "crash_log";
    @NotNull
    public static final String USER_INFO_FILE_NAME = "user_information";
    @NotNull
    public static final String NETWORK_INFO_FILE_NAME = "network_information";
    @NotNull
    public static final String LOGGER_NAME = "ndk_crash";
    @NotNull
    public static final String LOG_CRASH_MSG = "NDK crash detected with signal: %s";
    @NotNull
    public static final String ERROR_READ_NDK_DIR = "Error while trying to read the NDK crash directory";
    @NotNull
    public static final String WARN_CANNOT_READ_VIEW_INFO_DATA = "Cannot read application, session, view IDs data from view event.";
    @NotNull
    public static final String INFO_LOGS_FEATURE_NOT_REGISTERED = "Logs feature is not registered, won't report NDK crash info as log.";
    @NotNull
    public static final String INFO_RUM_FEATURE_NOT_REGISTERED = "RUM feature is not registered, won't report NDK crash info as RUM error.";
    private static final int STORAGE_VERSION = 2;
    @NotNull
    public static final String NDK_CRASH_REPORTS_FOLDER_NAME = "ndk_crash_reports_v2";
    @NotNull
    private static final String NDK_CRASH_REPORTS_PENDING_FOLDER_NAME = "ndk_crash_reports_intermediary_v2";

    public DatadogNdkCrashHandler(@NotNull File storageDir, @NotNull ExecutorService dataPersistenceExecutorService, @NotNull Deserializer<String, NdkCrashLog> ndkCrashLogDeserializer, @NotNull Deserializer<String, NetworkInfo> networkInfoDeserializer, @NotNull Deserializer<String, UserInfo> userInfoDeserializer, @NotNull InternalLogger internalLogger, @NotNull FileReader<byte[]> envFileReader, @NotNull Function0<JsonObject> lastRumViewEventProvider, @NotNull String nativeCrashSourceType) {
        Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
        Intrinsics.checkNotNullParameter((Object)dataPersistenceExecutorService, (String)"dataPersistenceExecutorService");
        Intrinsics.checkNotNullParameter(ndkCrashLogDeserializer, (String)"ndkCrashLogDeserializer");
        Intrinsics.checkNotNullParameter(networkInfoDeserializer, (String)"networkInfoDeserializer");
        Intrinsics.checkNotNullParameter(userInfoDeserializer, (String)"userInfoDeserializer");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter(envFileReader, (String)"envFileReader");
        Intrinsics.checkNotNullParameter(lastRumViewEventProvider, (String)"lastRumViewEventProvider");
        Intrinsics.checkNotNullParameter((Object)nativeCrashSourceType, (String)"nativeCrashSourceType");
        this.dataPersistenceExecutorService = dataPersistenceExecutorService;
        this.ndkCrashLogDeserializer = ndkCrashLogDeserializer;
        this.networkInfoDeserializer = networkInfoDeserializer;
        this.userInfoDeserializer = userInfoDeserializer;
        this.internalLogger = internalLogger;
        this.envFileReader = envFileReader;
        this.lastRumViewEventProvider = lastRumViewEventProvider;
        this.nativeCrashSourceType = nativeCrashSourceType;
        this.ndkCrashDataDirectory = DatadogNdkCrashHandler.Companion.getNdkGrantedDir(storageDir);
    }

    public /* synthetic */ DatadogNdkCrashHandler(File file, ExecutorService executorService, Deserializer deserializer, Deserializer deserializer2, Deserializer deserializer3, InternalLogger internalLogger, FileReader fileReader, Function0 function0, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x100) != 0) {
            string = "ndk";
        }
        this(file, executorService, deserializer, deserializer2, deserializer3, internalLogger, fileReader, (Function0<JsonObject>)function0, string);
    }

    @NotNull
    public final String getNativeCrashSourceType$dd_sdk_android_core_release() {
        return this.nativeCrashSourceType;
    }

    @NotNull
    public final File getNdkCrashDataDirectory$dd_sdk_android_core_release() {
        return this.ndkCrashDataDirectory;
    }

    @Nullable
    public final JsonObject getLastRumViewEvent$dd_sdk_android_core_release() {
        return this.lastRumViewEvent;
    }

    public final void setLastRumViewEvent$dd_sdk_android_core_release(@Nullable JsonObject jsonObject) {
        this.lastRumViewEvent = jsonObject;
    }

    @Nullable
    public final UserInfo getLastUserInfo$dd_sdk_android_core_release() {
        return this.lastUserInfo;
    }

    public final void setLastUserInfo$dd_sdk_android_core_release(@Nullable UserInfo userInfo) {
        this.lastUserInfo = userInfo;
    }

    @Nullable
    public final NetworkInfo getLastNetworkInfo$dd_sdk_android_core_release() {
        return this.lastNetworkInfo;
    }

    public final void setLastNetworkInfo$dd_sdk_android_core_release(@Nullable NetworkInfo networkInfo) {
        this.lastNetworkInfo = networkInfo;
    }

    @Nullable
    public final NdkCrashLog getLastNdkCrashLog$dd_sdk_android_core_release() {
        return this.lastNdkCrashLog;
    }

    public final void setLastNdkCrashLog$dd_sdk_android_core_release(@Nullable NdkCrashLog ndkCrashLog) {
        this.lastNdkCrashLog = ndkCrashLog;
    }

    public final boolean getProcessedForLogs$dd_sdk_android_core_release() {
        return this.processedForLogs;
    }

    public final void setProcessedForLogs$dd_sdk_android_core_release(boolean bl) {
        this.processedForLogs = bl;
    }

    public final boolean getProcessedForRum$dd_sdk_android_core_release() {
        return this.processedForRum;
    }

    public final void setProcessedForRum$dd_sdk_android_core_release(boolean bl) {
        this.processedForRum = bl;
    }

    @Override
    public void prepareData() {
        ConcurrencyExtKt.submitSafe(this.dataPersistenceExecutorService, "NDK crash check", this.internalLogger, () -> DatadogNdkCrashHandler.prepareData$lambda$0(this));
    }

    @Override
    public void handleNdkCrash(@NotNull FeatureSdkCore sdkCore, @NotNull NdkCrashHandler.ReportTarget reportTarget) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)((Object)reportTarget), (String)"reportTarget");
        ConcurrencyExtKt.submitSafe(this.dataPersistenceExecutorService, "NDK crash report ", this.internalLogger, () -> DatadogNdkCrashHandler.handleNdkCrash$lambda$1(this, sdkCore, reportTarget));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private final void readCrashData() {
        block26: {
            if (!FileExtKt.existsSafe(this.ndkCrashDataDirectory, this.internalLogger)) {
                return;
            }
            try {
                this.lastRumViewEvent = (JsonObject)this.lastRumViewEventProvider.invoke();
                File[] fileArray = FileExtKt.listFilesSafe(this.ndkCrashDataDirectory, this.internalLogger);
                if (fileArray == null) break block26;
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File file = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    String string = file.getName();
                    if (string == null) continue;
                    int n2 = -1;
                    switch (string.hashCode()) {
                        case 1847397036: {
                            if (string.equals(CRASH_DATA_FILE_NAME)) {
                                n2 = 1;
                            }
                            break;
                        }
                        case -528983909: {
                            if (string.equals(NETWORK_INFO_FILE_NAME)) {
                                n2 = 2;
                            }
                            break;
                        }
                        case 408381112: {
                            if (string.equals(USER_INFO_FILE_NAME)) {
                                n2 = 3;
                            }
                            break;
                        }
                    }
                    switch (n2) {
                        case 1: {
                            NdkCrashLog ndkCrashLog;
                            String it;
                            DatadogNdkCrashHandler datadogNdkCrashHandler;
                            DatadogNdkCrashHandler datadogNdkCrashHandler2 = this;
                            if (FileExtKt.readTextSafe$default(file, null, this.internalLogger, 1, null) != null) {
                                datadogNdkCrashHandler = datadogNdkCrashHandler2;
                                boolean bl2 = false;
                                ndkCrashLog = this.ndkCrashLogDeserializer.deserialize(it);
                                datadogNdkCrashHandler2 = datadogNdkCrashHandler;
                            } else {
                                ndkCrashLog = null;
                            }
                            datadogNdkCrashHandler2.lastNdkCrashLog = ndkCrashLog;
                            break;
                        }
                        case 3: {
                            UserInfo userInfo;
                            String it;
                            DatadogNdkCrashHandler datadogNdkCrashHandler;
                            DatadogNdkCrashHandler datadogNdkCrashHandler3 = this;
                            String string2 = this.readFileContent(file, this.envFileReader);
                            if (string2 != null) {
                                it = string2;
                                datadogNdkCrashHandler = datadogNdkCrashHandler3;
                                boolean bl3 = false;
                                userInfo = this.userInfoDeserializer.deserialize(it);
                                datadogNdkCrashHandler3 = datadogNdkCrashHandler;
                            } else {
                                userInfo = null;
                            }
                            datadogNdkCrashHandler3.lastUserInfo = userInfo;
                            break;
                        }
                        case 2: {
                            NetworkInfo networkInfo;
                            String it;
                            DatadogNdkCrashHandler datadogNdkCrashHandler;
                            DatadogNdkCrashHandler datadogNdkCrashHandler4 = this;
                            String string2 = this.readFileContent(file, this.envFileReader);
                            if (string2 != null) {
                                it = string2;
                                datadogNdkCrashHandler = datadogNdkCrashHandler4;
                                boolean bl4 = false;
                                networkInfo = this.networkInfoDeserializer.deserialize(it);
                                datadogNdkCrashHandler4 = datadogNdkCrashHandler;
                            } else {
                                networkInfo = null;
                            }
                            datadogNdkCrashHandler4.lastNetworkInfo = networkInfo;
                        }
                    }
                }
            }
            catch (SecurityException e) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)readCrashData.2.INSTANCE, (Throwable)e, false, null, 48, null);
            }
            finally {
                this.clearCrashLog();
            }
        }
    }

    @WorkerThread
    private final String readFileContent(File file, FileReader<byte[]> fileReader) {
        String string;
        byte[] content = fileReader.readData(file);
        if (content.length == 0) {
            string = null;
        } else {
            String string2;
            String it = string2 = new String(content, Charsets.UTF_8);
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)it, (CharSequence)"\\u0000", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)"\u0000", (boolean)false, (int)2, null)) {
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.TELEMETRY, (Function0)new Function0<String>(file, it, content){
                    final /* synthetic */ File $file;
                    final /* synthetic */ String $it;
                    final /* synthetic */ byte[] $content;
                    {
                        this.$file = $file;
                        this.$it = $it;
                        this.$content = $content;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Decoded file (" + this.$file.getName() + ") content contains NULL character, file content={" + this.$it + "}, raw_bytes=" + ArraysKt.joinToString$default((byte[])this.$content, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                    }
                }, null, false, null, 56, null);
            }
            string = string2;
        }
        return string;
    }

    @WorkerThread
    private final void checkAndHandleNdkCrashReport(FeatureSdkCore sdkCore, NdkCrashHandler.ReportTarget reportTarget) {
        if (this.lastNdkCrashLog != null) {
            this.handleNdkCrashLog(sdkCore, this.lastNdkCrashLog, this.lastRumViewEvent, this.lastUserInfo, this.lastNetworkInfo, reportTarget);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[reportTarget.ordinal()]) {
            case 1: {
                this.processedForRum = true;
                break;
            }
            case 2: {
                this.processedForLogs = true;
            }
        }
        if (this.processedForRum && this.processedForLogs) {
            this.clearAllReferences();
        }
    }

    private final void clearAllReferences() {
        this.lastRumViewEvent = null;
        this.lastNetworkInfo = null;
        this.lastUserInfo = null;
        this.lastNdkCrashLog = null;
    }

    @WorkerThread
    private final void handleNdkCrashLog(FeatureSdkCore sdkCore, NdkCrashLog ndkCrashLog, JsonObject lastViewEvent2, UserInfo lastUserInfo, NetworkInfo lastNetworkInfo, NdkCrashHandler.ReportTarget reportTarget) {
        if (ndkCrashLog == null) {
            return;
        }
        String string = LOG_CRASH_MSG;
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{ndkCrashLog.getSignalName()};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String errorLogMessage = string2;
        switch (WhenMappings.$EnumSwitchMapping$0[reportTarget.ordinal()]) {
            case 1: {
                if (lastViewEvent2 == null) break;
                this.sendCrashRumEvent(sdkCore, errorLogMessage, ndkCrashLog, lastViewEvent2);
                break;
            }
            case 2: {
                this.sendCrashLogEvent(sdkCore, errorLogMessage, this.generateLogAttributes(lastViewEvent2, ndkCrashLog), ndkCrashLog, lastNetworkInfo, lastUserInfo);
            }
        }
    }

    private final Map<String, String> generateLogAttributes(JsonObject lastRumViewEvent, NdkCrashLog ndkCrashLog) {
        Map map;
        Function1 function1;
        if (lastRumViewEvent != null) {
            Pair[] pairArray;
            Function1 extractId2;
            try {
                extractId2 = (Function1)new Function1<String, String>(lastRumViewEvent){
                    final /* synthetic */ JsonObject $lastRumViewEvent;
                    {
                        this.$lastRumViewEvent = $lastRumViewEvent;
                        super(1);
                    }

                    public final String invoke(@NotNull String property) {
                        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                        return this.$lastRumViewEvent.getAsJsonObject(property).getAsJsonPrimitive("id").getAsString();
                    }
                };
                String applicationId = (String)extractId2.invoke((Object)"application");
                String sessionId = (String)extractId2.invoke((Object)"session");
                String viewId = (String)extractId2.invoke((Object)"view");
                extractId2 = new Triple((Object)applicationId, (Object)sessionId, (Object)viewId);
            }
            catch (Exception e) {
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, (Function0)generateLogAttributes.logAttributes.1.INSTANCE, (Throwable)e, false, null, 48, null);
                extractId2 = new Triple(null, null, null);
            }
            function1 = extractId2;
            String applicationId = (String)function1.component1();
            String sessionId = (String)function1.component2();
            String viewId = (String)function1.component3();
            if (applicationId != null && sessionId != null && viewId != null) {
                pairArray = new Pair[]{TuplesKt.to((Object)"session_id", (Object)sessionId), TuplesKt.to((Object)"application_id", (Object)applicationId), TuplesKt.to((Object)"view.id", (Object)viewId), TuplesKt.to((Object)"error.stack", (Object)ndkCrashLog.getStacktrace()), TuplesKt.to((Object)"error.source_type", (Object)this.nativeCrashSourceType)};
                map = MapsKt.mapOf((Pair[])pairArray);
            } else {
                pairArray = new Pair[]{TuplesKt.to((Object)"error.stack", (Object)ndkCrashLog.getStacktrace()), TuplesKt.to((Object)"error.source_type", (Object)this.nativeCrashSourceType)};
                map = MapsKt.mapOf((Pair[])pairArray);
            }
        } else {
            function1 = new Function1[]{TuplesKt.to((Object)"error.stack", (Object)ndkCrashLog.getStacktrace()), TuplesKt.to((Object)"error.source_type", (Object)this.nativeCrashSourceType)};
            map = MapsKt.mapOf((Pair[])function1);
        }
        Map logAttributes2 = map;
        return logAttributes2;
    }

    @WorkerThread
    private final void sendCrashRumEvent(FeatureSdkCore sdkCore, String errorLogMessage, NdkCrashLog ndkCrashLog, JsonObject lastViewEvent2) {
        FeatureScope rumFeature = sdkCore.getFeature("rum");
        if (rumFeature != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)LOGGER_NAME), TuplesKt.to((Object)"sourceType", (Object)this.nativeCrashSourceType), TuplesKt.to((Object)"timestamp", (Object)ndkCrashLog.getTimestamp()), TuplesKt.to((Object)"timeSinceAppStartMs", (Object)ndkCrashLog.getTimeSinceAppStartMs()), TuplesKt.to((Object)"signalName", (Object)ndkCrashLog.getSignalName()), TuplesKt.to((Object)"stacktrace", (Object)ndkCrashLog.getStacktrace()), TuplesKt.to((Object)"message", (Object)errorLogMessage), TuplesKt.to((Object)"lastViewEvent", (Object)lastViewEvent2)};
            rumFeature.sendEvent(MapsKt.mapOf((Pair[])pairArray));
        } else {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.INFO, InternalLogger.Target.USER, (Function0)sendCrashRumEvent.1.INSTANCE, null, false, null, 56, null);
        }
    }

    @WorkerThread
    private final void sendCrashLogEvent(FeatureSdkCore sdkCore, String errorLogMessage, Map<String, String> logAttributes2, NdkCrashLog ndkCrashLog, NetworkInfo lastNetworkInfo, UserInfo lastUserInfo) {
        FeatureScope logsFeature = sdkCore.getFeature("logs");
        if (logsFeature != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"loggerName", (Object)LOGGER_NAME), TuplesKt.to((Object)"type", (Object)LOGGER_NAME), TuplesKt.to((Object)"message", (Object)errorLogMessage), TuplesKt.to((Object)"attributes", logAttributes2), TuplesKt.to((Object)"timestamp", (Object)ndkCrashLog.getTimestamp()), TuplesKt.to((Object)"networkInfo", (Object)lastNetworkInfo), TuplesKt.to((Object)"userInfo", (Object)lastUserInfo)};
            logsFeature.sendEvent(MapsKt.mapOf((Pair[])pairArray));
        } else {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.INFO, InternalLogger.Target.USER, (Function0)sendCrashLogEvent.1.INSTANCE, null, false, null, 56, null);
        }
    }

    private final void clearCrashLog() {
        if (FileExtKt.existsSafe(this.ndkCrashDataDirectory, this.internalLogger)) {
            try {
                File[] fileArray = FileExtKt.listFilesSafe(this.ndkCrashDataDirectory, this.internalLogger);
                if (fileArray != null) {
                    File[] $this$forEach$iv = fileArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        FilesKt.deleteRecursively((File)it);
                    }
                }
            }
            catch (Throwable e) {
                InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(this){
                    final /* synthetic */ DatadogNdkCrashHandler this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Unable to clear the NDK crash report file: " + this.this$0.getNdkCrashDataDirectory$dd_sdk_android_core_release().getAbsolutePath();
                    }
                }, e, false, null, 48, null);
            }
        }
    }

    private static final void prepareData$lambda$0(DatadogNdkCrashHandler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.readCrashData();
    }

    private static final void handleNdkCrash$lambda$1(DatadogNdkCrashHandler this$0, FeatureSdkCore $sdkCore, NdkCrashHandler.ReportTarget $reportTarget) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sdkCore, (String)"$sdkCore");
        Intrinsics.checkNotNullParameter((Object)((Object)$reportTarget), (String)"$reportTarget");
        this$0.checkAndHandleNdkCrashReport($sdkCore, $reportTarget);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b\u0019J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0015\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/datadog/android/ndk/internal/DatadogNdkCrashHandler$Companion;", "", "()V", "CRASH_DATA_FILE_NAME", "", "ERROR_READ_NDK_DIR", "INFO_LOGS_FEATURE_NOT_REGISTERED", "INFO_RUM_FEATURE_NOT_REGISTERED", "LOGGER_NAME", "LOG_CRASH_MSG", "NDK_CRASH_REPORTS_FOLDER_NAME", "NDK_CRASH_REPORTS_PENDING_FOLDER_NAME", "NETWORK_INFO_FILE_NAME", "RUM_VIEW_EVENT_FILE_NAME", "STORAGE_VERSION", "", "USER_INFO_FILE_NAME", "WARN_CANNOT_READ_VIEW_INFO_DATA", "getGrantedNetworkInfoFile", "Ljava/io/File;", "storageDir", "getGrantedNetworkInfoFile$dd_sdk_android_core_release", "getGrantedUserInfoFile", "getGrantedUserInfoFile$dd_sdk_android_core_release", "getLastViewEventFile", "getLastViewEventFile$dd_sdk_android_core_release", "getNdkGrantedDir", "getNdkPendingDir", "getPendingNetworkInfoFile", "getPendingNetworkInfoFile$dd_sdk_android_core_release", "getPendingUserInfoFile", "getPendingUserInfoFile$dd_sdk_android_core_release", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final File getNdkGrantedDir(File storageDir) {
            return new File(storageDir, DatadogNdkCrashHandler.NDK_CRASH_REPORTS_FOLDER_NAME);
        }

        private final File getNdkPendingDir(File storageDir) {
            return new File(storageDir, DatadogNdkCrashHandler.NDK_CRASH_REPORTS_PENDING_FOLDER_NAME);
        }

        @Deprecated(message="We will still process this path to check file from the old SDK versions, but don't use it anymore for writing.")
        @NotNull
        public final File getLastViewEventFile$dd_sdk_android_core_release(@NotNull File storageDir) {
            Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
            return new File(this.getNdkGrantedDir(storageDir), DatadogNdkCrashHandler.RUM_VIEW_EVENT_FILE_NAME);
        }

        @NotNull
        public final File getPendingNetworkInfoFile$dd_sdk_android_core_release(@NotNull File storageDir) {
            Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
            return new File(this.getNdkPendingDir(storageDir), DatadogNdkCrashHandler.NETWORK_INFO_FILE_NAME);
        }

        @NotNull
        public final File getGrantedNetworkInfoFile$dd_sdk_android_core_release(@NotNull File storageDir) {
            Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
            return new File(this.getNdkGrantedDir(storageDir), DatadogNdkCrashHandler.NETWORK_INFO_FILE_NAME);
        }

        @NotNull
        public final File getPendingUserInfoFile$dd_sdk_android_core_release(@NotNull File storageDir) {
            Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
            return new File(this.getNdkPendingDir(storageDir), DatadogNdkCrashHandler.USER_INFO_FILE_NAME);
        }

        @NotNull
        public final File getGrantedUserInfoFile$dd_sdk_android_core_release(@NotNull File storageDir) {
            Intrinsics.checkNotNullParameter((Object)storageDir, (String)"storageDir");
            return new File(this.getNdkGrantedDir(storageDir), DatadogNdkCrashHandler.USER_INFO_FILE_NAME);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NdkCrashHandler.ReportTarget.values().length];
            try {
                nArray[NdkCrashHandler.ReportTarget.RUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NdkCrashHandler.ReportTarget.LOGS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

