/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.gradle.plugin;

import com.datadog.gradle.plugin.SdkCheckLevel;
import com.datadog.gradle.plugin.internal.MissingSdkException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u001b\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0000\u00a2\u0006\u0002\b\u001aR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\bR\u001c\u0010\u000e\u001a\u00020\u000f8AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcom/datadog/gradle/plugin/CheckSdkDepsTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "sdkCheckLevel", "Lorg/gradle/api/provider/Property;", "Lcom/datadog/gradle/plugin/SdkCheckLevel;", "getSdkCheckLevel", "()Lorg/gradle/api/provider/Property;", "configurationName", "", "getConfigurationName", "variantName", "getVariantName", "isLastRunSuccessful", "", "isLastRunSuccessful$dd_sdk_android_gradle_plugin", "()Z", "setLastRunSuccessful$dd_sdk_android_gradle_plugin", "(Z)V", "applyTask", "", "isDatadogDependencyPresent", "dependencies", "", "Lorg/gradle/api/artifacts/ResolvedDependency;", "isDatadogDependencyPresent$dd_sdk_android_gradle_plugin", "Companion", "dd-sdk-android-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nCheckSdkDepsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckSdkDepsTask.kt\ncom/datadog/gradle/plugin/CheckSdkDepsTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n295#2,2:145\n*S KotlinDebug\n*F\n+ 1 CheckSdkDepsTask.kt\ncom/datadog/gradle/plugin/CheckSdkDepsTask\n*L\n60#1:145,2\n*E\n"})
public abstract class CheckSdkDepsTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isLastRunSuccessful = true;
    @NotNull
    public static final String MISSING_DD_SDK_MESSAGE = "Following application variant doesn't have Datadog SDK included: %s";
    @NotNull
    public static final String CANNOT_FIND_CONFIGURATION_MESSAGE = "Cannot find configuration %s for the variant %s in the configurations list, please report the issue at https://github.com/DataDog/dd-sdk-android-gradle-plugin/issues";
    @NotNull
    public static final String DD_SDK_V1_NAME = "dd-sdk-android";
    @NotNull
    public static final String DD_SDK_V2_CORE_NAME = "dd-sdk-android-core";
    @NotNull
    public static final String DD_SDK_GROUP = "com.datadoghq";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"DdCheckSdkDepsTask");

    public CheckSdkDepsTask() {
        this.setGroup("datadog");
        this.setDescription("Checks for the Datadog SDK into your variant dependencies.");
        this.getOutputs().upToDateWhen(arg_0 -> CheckSdkDepsTask._init_$lambda$1(CheckSdkDepsTask::_init_$lambda$0, arg_0));
    }

    @Input
    @NotNull
    public abstract Property<SdkCheckLevel> getSdkCheckLevel();

    @Input
    @NotNull
    public abstract Property<String> getConfigurationName();

    @Input
    @NotNull
    public abstract Property<String> getVariantName();

    @Internal
    public final boolean isLastRunSuccessful$dd_sdk_android_gradle_plugin() {
        return this.isLastRunSuccessful;
    }

    public final void setLastRunSuccessful$dd_sdk_android_gradle_plugin(boolean bl) {
        this.isLastRunSuccessful = bl;
    }

    @TaskAction
    public final void applyTask() {
        block11: {
            block10: {
                Object v1;
                Object $this$firstOrNull$iv;
                block9: {
                    ConfigurationContainer configurationContainer = this.getProject().getConfigurations();
                    Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
                    $this$firstOrNull$iv = (Iterable)configurationContainer;
                    boolean $i$f$firstOrNull = false;
                    Iterator iterator = $this$firstOrNull$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        Configuration it = (Configuration)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.getConfigurationName().get())) continue;
                        v1 = element$iv;
                        break block9;
                    }
                    v1 = null;
                }
                Configuration configuration = v1;
                if (configuration == null) {
                    $this$firstOrNull$iv = CANNOT_FIND_CONFIGURATION_MESSAGE;
                    Object[] $i$f$firstOrNull = new Object[]{this.getConfigurationName().get(), this.getVariantName().get()};
                    String string = String.format((String)$this$firstOrNull$iv, Arrays.copyOf($i$f$firstOrNull, $i$f$firstOrNull.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                    LOGGER.info(string);
                    return;
                }
                ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
                if (resolvedConfiguration.hasError()) {
                    try {
                        resolvedConfiguration.rethrowFailure();
                        throw new IllegalStateException("Expected to throw " + Reflection.getOrCreateKotlinClass(ResolveException.class).getQualifiedName() + ", but this didn't happen");
                    }
                    catch (ResolveException re) {
                        ResolveException error = re;
                        LOGGER.warn("Couldn't resolve configuration " + this.getConfigurationName().get(), (Throwable)error);
                        return;
                    }
                }
                Set topDependencies = resolvedConfiguration.getFirstLevelModuleDependencies();
                Intrinsics.checkNotNull((Object)topDependencies);
                if (this.isDatadogDependencyPresent$dd_sdk_android_gradle_plugin(topDependencies)) break block10;
                this.isLastRunSuccessful = false;
                SdkCheckLevel sdkCheckLevel = (SdkCheckLevel)((Object)this.getSdkCheckLevel().get());
                switch (sdkCheckLevel == null ? -1 : WhenMappings.$EnumSwitchMapping$0[sdkCheckLevel.ordinal()]) {
                    case 1: {
                        String string = MISSING_DD_SDK_MESSAGE;
                        Object[] objectArray = new Object[]{this.getVariantName().get()};
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                        throw new MissingSdkException(string2);
                    }
                    case 2: {
                        String string = MISSING_DD_SDK_MESSAGE;
                        Object[] objectArray = new Object[]{this.getVariantName().get()};
                        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                        LOGGER.warn(string3);
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("This should never happen, value=" + this.getSdkCheckLevel() + " is not handled");
                    }
                }
            }
            this.isLastRunSuccessful = true;
        }
    }

    public final boolean isDatadogDependencyPresent$dd_sdk_android_gradle_plugin(@NotNull Set<? extends ResolvedDependency> dependencies) {
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Queue queue = new LinkedList(dependencies);
        while (!((Collection)queue).isEmpty()) {
            ResolvedDependency dep = (ResolvedDependency)queue.remove();
            if (Intrinsics.areEqual((Object)dep.getModuleGroup(), (Object)DD_SDK_GROUP) && (Intrinsics.areEqual((Object)dep.getModuleName(), (Object)DD_SDK_V1_NAME) || Intrinsics.areEqual((Object)dep.getModuleName(), (Object)DD_SDK_V2_CORE_NAME))) {
                return true;
            }
            Set set = dep.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getChildren(...)");
            queue.addAll(set);
        }
        return false;
    }

    private static final boolean _init_$lambda$0(Task it) {
        return it instanceof CheckSdkDepsTask && ((CheckSdkDepsTask)it).isLastRunSuccessful;
    }

    private static final boolean _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/datadog/gradle/plugin/CheckSdkDepsTask$Companion;", "", "<init>", "()V", "MISSING_DD_SDK_MESSAGE", "", "CANNOT_FIND_CONFIGURATION_MESSAGE", "DD_SDK_V1_NAME", "DD_SDK_V2_CORE_NAME", "DD_SDK_GROUP", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOGGER$dd_sdk_android_gradle_plugin", "()Lorg/slf4j/Logger;", "Lorg/slf4j/Logger;", "dd-sdk-android-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOGGER$dd_sdk_android_gradle_plugin() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SdkCheckLevel.values().length];
            try {
                nArray[SdkCheckLevel.FAIL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SdkCheckLevel.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

