/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.gradle.plugin;

import com.datadog.gradle.plugin.internal.variant.AppVariant;
import java.io.File;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0007R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/datadog/gradle/plugin/GenerateBuildIdTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "buildIdDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getBuildIdDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "buildIdFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "getBuildIdFile", "()Lorg/gradle/api/provider/Provider;", "variantName", "Lorg/gradle/api/provider/Property;", "", "getVariantName", "()Lorg/gradle/api/provider/Property;", "generateBuildId", "", "Companion", "dd-sdk-android-gradle-plugin"})
public abstract class GenerateBuildIdTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Provider<RegularFile> buildIdFile;
    @NotNull
    private static final String TASK_NAME = "generateBuildId";
    @NotNull
    public static final String BUILD_ID_FILE_NAME = "datadog.buildId";

    public GenerateBuildIdTask() {
        Provider provider = this.getBuildIdDirectory().file(BUILD_ID_FILE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"file(...)");
        this.buildIdFile = provider;
        this.getOutputs().upToDateWhen(arg_0 -> GenerateBuildIdTask._init_$lambda$1(GenerateBuildIdTask::_init_$lambda$0, arg_0));
        this.setDescription("Generates a unique build ID to associate mapping file and application.");
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getBuildIdDirectory();

    @Internal
    @NotNull
    public final Provider<RegularFile> getBuildIdFile() {
        return this.buildIdFile;
    }

    @Internal
    @NotNull
    public abstract Property<String> getVariantName();

    @TaskAction
    public final void generateBuildId() {
        File buildIdDirectory = ((Directory)this.getBuildIdDirectory().get()).getAsFile();
        buildIdDirectory.mkdirs();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String buildId = string;
        this.getLogger().info("Generated buildId=" + buildId + " for variant=" + this.getVariantName().get());
        File file = ((RegularFile)this.buildIdFile.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        FilesKt.writeText$default((File)file, (String)buildId, null, (int)2, null);
    }

    private static final boolean _init_$lambda$0(Task it) {
        return false;
    }

    private static final boolean _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/datadog/gradle/plugin/GenerateBuildIdTask$Companion;", "", "<init>", "()V", "TASK_NAME", "", "BUILD_ID_FILE_NAME", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/datadog/gradle/plugin/GenerateBuildIdTask;", "target", "Lorg/gradle/api/Project;", "variant", "Lcom/datadog/gradle/plugin/internal/variant/AppVariant;", "buildIdDirectory", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "dd-sdk-android-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TaskProvider<GenerateBuildIdTask> register(@NotNull Project target, @NotNull AppVariant variant, @NotNull Provider<Directory> buildIdDirectory) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Intrinsics.checkNotNullParameter(buildIdDirectory, (String)"buildIdDirectory");
            TaskProvider generateBuildIdTask = target.getTasks().register(GenerateBuildIdTask.TASK_NAME + StringsKt.capitalize((String)variant.getName()), GenerateBuildIdTask.class, arg_0 -> Companion.register$lambda$1(arg_0 -> Companion.register$lambda$0(buildIdDirectory, variant, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)generateBuildIdTask);
            variant.bindWith((TaskProvider<GenerateBuildIdTask>)generateBuildIdTask, buildIdDirectory);
            return generateBuildIdTask;
        }

        private static final Unit register$lambda$0(Provider $buildIdDirectory, AppVariant $variant, GenerateBuildIdTask it) {
            it.getBuildIdDirectory().set($buildIdDirectory);
            it.getVariantName().set((Object)$variant.getName());
            return Unit.INSTANCE;
        }

        private static final void register$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

