/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.gradle.plugin;

import com.datadog.gradle.plugin.DdAndroidGradlePlugin;
import com.datadog.gradle.plugin.FileUploadTask;
import com.datadog.gradle.plugin.RepositoryDetector;
import com.datadog.gradle.plugin.internal.Uploader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 )2\u00020\u0001:\u0001)B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0010\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\"H\u0002J*\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u000e2\u0018\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u000e0'0\u001eH\u0002R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR(\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u00020\u00148GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lcom/datadog/gradle/plugin/MappingFileUploadTask;", "Lcom/datadog/gradle/plugin/FileUploadTask;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "repositoryDetector", "Lcom/datadog/gradle/plugin/RepositoryDetector;", "<init>", "(Lorg/gradle/api/provider/ProviderFactory;Lcom/datadog/gradle/plugin/RepositoryDetector;)V", "mappingFile", "Lorg/gradle/api/file/RegularFileProperty;", "getMappingFile", "()Lorg/gradle/api/file/RegularFileProperty;", "mappingFilePackagesAliases", "", "", "getMappingFilePackagesAliases", "()Ljava/util/Map;", "setMappingFilePackagesAliases", "(Ljava/util/Map;)V", "mappingFileTrimIndents", "", "getMappingFileTrimIndents", "()Z", "setMappingFileTrimIndents", "(Z)V", "applicationId", "Lorg/gradle/api/provider/Property;", "getApplicationId", "()Lorg/gradle/api/provider/Property;", "getFilesList", "", "Lcom/datadog/gradle/plugin/internal/Uploader$UploadFileInfo;", "getFilesList$dd_sdk_android_gradle_plugin", "validateMappingFile", "Ljava/io/File;", "shrinkMappingFile", "applyShortAliases", "line", "replacements", "Lkotlin/Pair;", "Lkotlin/text/Regex;", "Companion", "dd-sdk-android-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nMappingFileUploadTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappingFileUploadTask.kt\ncom/datadog/gradle/plugin/MappingFileUploadTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,207:1\n1#2:208\n1#2:226\n535#3:209\n520#3,6:210\n1062#4:216\n1557#4:217\n1628#4,3:218\n1797#4,3:229\n284#5,5:221\n1317#6,2:227\n*S KotlinDebug\n*F\n+ 1 MappingFileUploadTask.kt\ncom/datadog/gradle/plugin/MappingFileUploadTask\n*L\n139#1:226\n105#1:209\n105#1:210,6\n125#1:216\n126#1:217\n126#1:218,3\n174#1:229,3\n139#1:221,5\n144#1:227,2\n*E\n"})
public abstract class MappingFileUploadTask
extends FileUploadTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, String> mappingFilePackagesAliases;
    private boolean mappingFileTrimIndents;
    @NotNull
    public static final String TYPE_JVM_MAPPING_FILE = "jvm_mapping_file";
    @NotNull
    public static final String KEY_JVM_MAPPING_FILE = "jvm_mapping_file";
    @NotNull
    public static final String KEY_JVM_MAPPING_FILE_NAME = "jvm_mapping";
    @NotNull
    public static final String MEDIA_TYPE_TXT = "text/plain";
    @NotNull
    private static final String MAPPING_FILE_CHANGE_DELIMITER = "->";
    private static final char MAPPING_FILE_COMMENT_CHAR = '#';
    @NotNull
    public static final String MAPPING_OPTIMIZED_FILE_NAME = "mapping-shrinked.txt";
    public static final int MAPPING_OPTIMIZED_FILE_WRITE_BUFFER_SIZE = 32768;
    @NotNull
    public static final String API_KEY_MISSING_ERROR = "Make sure you define an API KEY to upload your mapping files to Datadog. Create a DD_API_KEY or DATADOG_API_KEY environment variable, gradle property or define it in datadog-ci.json file.";
    @NotNull
    public static final String INVALID_API_KEY_FORMAT_ERROR = "DD_API_KEY provided shouldn't contain quotes or apostrophes.";
    @NotNull
    public static final String MISSING_BUILD_ID_ERROR = "Build ID is missing, you need to run upload task only after APK/AAB file is generated.";

    @Inject
    public MappingFileUploadTask(@NotNull ProviderFactory providerFactory, @NotNull RepositoryDetector repositoryDetector) {
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)repositoryDetector, (String)"repositoryDetector");
        super(providerFactory, repositoryDetector);
        this.mappingFilePackagesAliases = MapsKt.emptyMap();
        this.setGroup("datadog");
        this.setDescription("Uploads the Proguard/R8 mapping file to Datadog");
        this.getOutputs().upToDateWhen(arg_0 -> MappingFileUploadTask._init_$lambda$1(MappingFileUploadTask::_init_$lambda$0, arg_0));
    }

    @InputFiles
    @NotNull
    public abstract RegularFileProperty getMappingFile();

    @Input
    @NotNull
    public final Map<String, String> getMappingFilePackagesAliases() {
        return this.mappingFilePackagesAliases;
    }

    public final void setMappingFilePackagesAliases(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.mappingFilePackagesAliases = map;
    }

    @Input
    public final boolean getMappingFileTrimIndents() {
        return this.mappingFileTrimIndents;
    }

    public final void setMappingFileTrimIndents(boolean bl) {
        this.mappingFileTrimIndents = bl;
    }

    @Input
    @NotNull
    public abstract Property<String> getApplicationId();

    @Override
    @NotNull
    public List<Uploader.UploadFileInfo> getFilesList$dd_sdk_android_gradle_plugin() {
        File mappingFile;
        if (!this.getMappingFile().isPresent()) {
            boolean bl = false;
            String string = "No mapping file value in the input property.";
            throw new IllegalStateException(string.toString());
        }
        File file = mappingFile = ((RegularFile)this.getMappingFile().get()).getAsFile();
        Intrinsics.checkNotNull((Object)file);
        if (!this.validateMappingFile(file)) {
            return CollectionsKt.emptyList();
        }
        file = mappingFile;
        Intrinsics.checkNotNull((Object)file);
        mappingFile = this.shrinkMappingFile(file);
        return CollectionsKt.listOf((Object)new Uploader.UploadFileInfo("jvm_mapping_file", mappingFile, MEDIA_TYPE_TXT, "jvm_mapping_file", KEY_JVM_MAPPING_FILE_NAME, null, 32, null));
    }

    private final boolean validateMappingFile(File mappingFile) {
        if (!mappingFile.exists()) {
            System.out.println((Object)("There's no mapping file " + mappingFile.getAbsolutePath() + ", nothing to upload"));
            return false;
        }
        if (!mappingFile.isFile()) {
            boolean $i$a$-check-MappingFileUploadTask$validateMappingFile$32 = false;
            String $i$a$-check-MappingFileUploadTask$validateMappingFile$32 = "Expected " + mappingFile.getAbsolutePath() + " to be a file";
            throw new IllegalStateException($i$a$-check-MappingFileUploadTask$validateMappingFile$32.toString());
        }
        if (!mappingFile.canRead()) {
            boolean bl = false;
            String string = "Cannot read file " + mappingFile.getAbsolutePath();
            throw new IllegalStateException(string.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final File shrinkMappingFile(File mappingFile) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Iterable $this$filterTo$iv$iv;
        if (!this.mappingFileTrimIndents && this.mappingFilePackagesAliases.isEmpty()) {
            return mappingFile;
        }
        FileUploadTask.Companion.getLOGGER$dd_sdk_android_gradle_plugin().info("Size of " + mappingFile.getPath() + " before optimization is " + mappingFile.length() + " bytes");
        Map<String, String> $this$filter$iv = this.mappingFilePackagesAliases;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            Object object2 = this.getApplicationId().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            if (StringsKt.startsWith$default((String)((String)object2), (String)((String)it.getKey()), (boolean)false, (int)2, null)) {
                DdAndroidGradlePlugin.Companion.getLOGGER$dd_sdk_android_gradle_plugin().warn("Renaming of package prefix=" + it.getKey() + " will be skipped, because it belongs to the application package.");
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterable $this$sortedByDescending$iv = destination$iv$iv.entrySet();
        boolean $i$f$sortedByDescending = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((String)it.getKey()).length());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((String)it.getKey()).length()));
            }
        });
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
            it = item$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl = false;
            String lookup = StringsKt.replace$default((String)StringsKt.replace$default((String)((String)it.getKey()), (String)".*", (String)"", (boolean)false, (int)4, null), (String)".", (String)"\\.", (boolean)false, (int)4, null);
            object3.add(TuplesKt.to((Object)new Regex("(?<=^|\\W)" + lookup + "(?=\\W)"), it.getValue()));
        }
        List replacements = (List)destination$iv$iv;
        File shrinkedFile = new File(mappingFile.getParent(), MAPPING_OPTIMIZED_FILE_NAME);
        if (shrinkedFile.exists()) {
            shrinkedFile.delete();
        }
        Object object4 = shrinkedFile;
        int destination$iv$iv2 = 32768;
        object = Charsets.UTF_8;
        Object $i$f$mapTo22 = object4;
        object4 = ($i$f$mapTo22 = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)$i$f$mapTo22), (Charset)object)) instanceof BufferedWriter ? (BufferedWriter)$i$f$mapTo22 : new BufferedWriter((Writer)$i$f$mapTo22, destination$iv$iv2);
        object = null;
        try {
            BufferedWriter shrinkedFileWriter = (BufferedWriter)object4;
            boolean bl = false;
            File $this$useLines_u24default$iv = mappingFile;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$useLines = false;
            Object object5 = $this$useLines_u24default$iv;
            int n = 8192;
            Object object6 = object5;
            object6 = new InputStreamReader((InputStream)new FileInputStream((File)object6), charset$iv);
            object5 = object6 instanceof BufferedReader ? (BufferedReader)object6 : new BufferedReader((Reader)object6, n);
            Throwable throwable = null;
            try {
                void $this$forEach$iv;
                BufferedReader it$iv = (BufferedReader)object5;
                boolean bl3 = false;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl4 = false;
                Sequence $this$shrinkMappingFile_u24lambda_u2413_u24lambda_u2412_u24lambda_u249 = lines;
                boolean bl5 = false;
                Sequence sequence = SequencesKt.map((Sequence)(this.mappingFileTrimIndents ? SequencesKt.map((Sequence)$this$shrinkMappingFile_u24lambda_u2413_u24lambda_u2412_u24lambda_u249, MappingFileUploadTask::shrinkMappingFile$lambda$13$lambda$12$lambda$9$lambda$8) : $this$shrinkMappingFile_u24lambda_u2413_u24lambda_u2412_u24lambda_u249), arg_0 -> MappingFileUploadTask.shrinkMappingFile$lambda$13$lambda$12$lambda$10(this, replacements, arg_0));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it2 = (String)element$iv;
                    boolean bl6 = false;
                    Appendable appendable = ((Appendable)shrinkedFileWriter).append(it2);
                    Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
                }
                shrinkedFileWriter.flush();
                object6 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object5, (Throwable)throwable);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object4, (Throwable)object);
        }
        FileUploadTask.Companion.getLOGGER$dd_sdk_android_gradle_plugin().info("Size of optimized file is " + shrinkedFile.length() + " bytes");
        return shrinkedFile;
    }

    /*
     * WARNING - void declaration
     */
    private final String applyShortAliases(String line, List<Pair<Regex, String>> replacements) {
        Object object;
        boolean isLineWithRename;
        boolean bl = isLineWithRename = !StringsKt.startsWith$default((CharSequence)line, (char)'#', (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)line, (CharSequence)MAPPING_FILE_CHANGE_DELIMITER, (boolean)false, (int)2, null);
        if (isLineWithRename) {
            String[] stringArray = new String[]{MAPPING_FILE_CHANGE_DELIMITER};
            List parts = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 2) {
                FileUploadTask.Companion.getLOGGER$dd_sdk_android_gradle_plugin().info("Unexpected number of '->' (" + (parts.size() - 1) + ") in the obfuscation line.");
                object = line;
            } else {
                String source = (String)parts.get(0);
                String obfuscated = (String)parts.get(1);
                Iterable $this$fold$iv = replacements;
                boolean $i$f$fold = false;
                String accumulator$iv = source;
                for (Object element$iv : $this$fold$iv) {
                    void entry;
                    Pair pair = (Pair)element$iv;
                    String state = accumulator$iv;
                    boolean bl2 = false;
                    Regex from = (Regex)entry.component1();
                    String to = (String)entry.component2();
                    accumulator$iv = from.replace((CharSequence)state, to);
                }
                String aliasedSource = accumulator$iv;
                object = aliasedSource + MAPPING_FILE_CHANGE_DELIMITER + obfuscated;
            }
        } else {
            object = line;
        }
        return object;
    }

    private static final boolean _init_$lambda$0(Task it) {
        return false;
    }

    private static final boolean _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String shrinkMappingFile$lambda$13$lambda$12$lambda$9$lambda$8(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trimStart((CharSequence)it)).toString();
    }

    private static final String shrinkMappingFile$lambda$13$lambda$12$lambda$10(MappingFileUploadTask this$0, List $replacements, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.applyShortAliases(it, $replacements);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/datadog/gradle/plugin/MappingFileUploadTask$Companion;", "", "<init>", "()V", "TYPE_JVM_MAPPING_FILE", "", "KEY_JVM_MAPPING_FILE", "KEY_JVM_MAPPING_FILE_NAME", "MEDIA_TYPE_TXT", "MAPPING_FILE_CHANGE_DELIMITER", "MAPPING_FILE_COMMENT_CHAR", "", "MAPPING_OPTIMIZED_FILE_NAME", "MAPPING_OPTIMIZED_FILE_WRITE_BUFFER_SIZE", "", "API_KEY_MISSING_ERROR", "INVALID_API_KEY_FORMAT_ERROR", "MISSING_BUILD_ID_ERROR", "dd-sdk-android-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

