/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.gradle.plugin;

import com.datadog.gradle.plugin.DdExtensionConfiguration;
import com.datadog.gradle.plugin.FileUploadTask;
import com.datadog.gradle.plugin.GenerateBuildIdTask;
import com.datadog.gradle.plugin.RepositoryDetector;
import com.datadog.gradle.plugin.TaskUtils;
import com.datadog.gradle.plugin.internal.ApiKey;
import com.datadog.gradle.plugin.internal.TaskExtKt;
import com.datadog.gradle.plugin.internal.Uploader;
import com.datadog.gradle.plugin.internal.variant.AppVariant;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0010\u00a2\u0006\u0002\b\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u0013\u0010\n\u001a\u00020\u000b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/datadog/gradle/plugin/NdkSymbolFileUploadTask;", "Lcom/datadog/gradle/plugin/FileUploadTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "repositoryDetector", "Lcom/datadog/gradle/plugin/RepositoryDetector;", "<init>", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/provider/ProviderFactory;Lcom/datadog/gradle/plugin/RepositoryDetector;)V", "searchDirectories", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getSearchDirectories", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "getFilesList", "", "Lcom/datadog/gradle/plugin/internal/Uploader$UploadFileInfo;", "getFilesList$dd_sdk_android_gradle_plugin", "findSoFiles", "", "Ljava/io/File;", "searchDirectory", "SupportedArchitectureMapping", "Companion", "dd-sdk-android-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nNdkSymbolFileUploadTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NdkSymbolFileUploadTask.kt\ncom/datadog/gradle/plugin/NdkSymbolFileUploadTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1368#2:132\n1454#2,5:133\n1863#2:138\n295#2,2:139\n1864#2:141\n*S KotlinDebug\n*F\n+ 1 NdkSymbolFileUploadTask.kt\ncom/datadog/gradle/plugin/NdkSymbolFileUploadTask\n*L\n43#1:132\n43#1:133,5\n45#1:138\n47#1:139,2\n45#1:141\n*E\n"})
public abstract class NdkSymbolFileUploadTask
extends FileUploadTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigurableFileCollection searchDirectories;
    @NotNull
    public static final String TASK_NAME = "uploadNdkSymbolFiles";
    @NotNull
    public static final String KEY_NDK_SYMBOL_FILE = "ndk_symbol_file";
    @NotNull
    public static final String TYPE_NDK_SYMBOL_FILE = "ndk_symbol_file";
    @NotNull
    public static final String ENCODING = "application/octet-stream";
    @NotNull
    private static final Set<SupportedArchitectureMapping> SUPPORTED_ARCHS;

    @Inject
    public NdkSymbolFileUploadTask(@NotNull ObjectFactory objectFactory, @NotNull ProviderFactory providerFactory, @NotNull RepositoryDetector repositoryDetector) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter((Object)repositoryDetector, (String)"repositoryDetector");
        super(providerFactory, repositoryDetector);
        ConfigurableFileCollection configurableFileCollection = objectFactory.fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"fileCollection(...)");
        this.searchDirectories = configurableFileCollection;
        this.setDescription("Uploads NDK symbol files to Datadog servers to perform native crash symbolication.");
    }

    @InputFiles
    @NotNull
    public final ConfigurableFileCollection getSearchDirectories() {
        return this.searchDirectories;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Uploader.UploadFileInfo> getFilesList$dd_sdk_android_gradle_plugin() {
        void $this$flatMapTo$iv$iv;
        List files = new ArrayList();
        Iterable $this$flatMap$iv = (Iterable)this.searchDirectories;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File p0 = (File)element$iv$iv;
            boolean $i$f$getFilesList$stub_for_inlining = false;
            boolean bl = false;
            Iterable list$iv$iv = this.findSoFiles(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            File file;
            block4: {
                file = (File)element$iv;
                boolean bl = false;
                String arch = file.getParentFile().getName();
                Iterable $this$firstOrNull$iv = SUPPORTED_ARCHS;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    SupportedArchitectureMapping it = (SupportedArchitectureMapping)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getArch(), (Object)arch)) continue;
                    v0 = element$iv2;
                    break block4;
                }
                v0 = null;
            }
            SupportedArchitectureMapping archMapping = v0;
            if (!(archMapping != null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            files.add(new Uploader.UploadFileInfo("ndk_symbol_file", file, ENCODING, "ndk_symbol_file", string, MapsKt.mapOf((Pair)TuplesKt.to((Object)"arch", (Object)archMapping.getUploadArch()))));
        }
        return files;
    }

    private final Collection<File> findSoFiles(File searchDirectory) {
        return searchDirectory.exists() && searchDirectory.isDirectory() ? (Collection)SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)searchDirectory)), NdkSymbolFileUploadTask::findSoFiles$lambda$2)) : (Collection)SetsKt.emptySet();
    }

    private static final boolean findSoFiles$lambda$2(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"so");
    }

    static {
        Object[] objectArray = new SupportedArchitectureMapping[]{new SupportedArchitectureMapping("armeabi-v7a", "arm"), new SupportedArchitectureMapping("arm64-v8a", "arm64"), new SupportedArchitectureMapping("x86", "x86"), new SupportedArchitectureMapping("x86_64", "x64")};
        SUPPORTED_ARCHS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/datadog/gradle/plugin/NdkSymbolFileUploadTask$Companion;", "", "<init>", "()V", "TASK_NAME", "", "KEY_NDK_SYMBOL_FILE", "TYPE_NDK_SYMBOL_FILE", "ENCODING", "SUPPORTED_ARCHS", "", "Lcom/datadog/gradle/plugin/NdkSymbolFileUploadTask$SupportedArchitectureMapping;", "getSUPPORTED_ARCHS$dd_sdk_android_gradle_plugin", "()Ljava/util/Set;", "register", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/datadog/gradle/plugin/NdkSymbolFileUploadTask;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/datadog/gradle/plugin/internal/variant/AppVariant;", "buildIdTask", "Lcom/datadog/gradle/plugin/GenerateBuildIdTask;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "apiKey", "Lcom/datadog/gradle/plugin/internal/ApiKey;", "extensionConfiguration", "Lcom/datadog/gradle/plugin/DdExtensionConfiguration;", "repositoryDetector", "Lcom/datadog/gradle/plugin/RepositoryDetector;", "dd-sdk-android-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nNdkSymbolFileUploadTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NdkSymbolFileUploadTask.kt\ncom/datadog/gradle/plugin/NdkSymbolFileUploadTask$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,131:1\n37#2,2:132\n*S KotlinDebug\n*F\n+ 1 NdkSymbolFileUploadTask.kt\ncom/datadog/gradle/plugin/NdkSymbolFileUploadTask$Companion\n*L\n117#1:132,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<SupportedArchitectureMapping> getSUPPORTED_ARCHS$dd_sdk_android_gradle_plugin() {
            return SUPPORTED_ARCHS;
        }

        @NotNull
        public final TaskProvider<NdkSymbolFileUploadTask> register(@NotNull Project project, @NotNull AppVariant variant, @NotNull TaskProvider<GenerateBuildIdTask> buildIdTask, @NotNull ProviderFactory providerFactory, @NotNull ApiKey apiKey, @NotNull DdExtensionConfiguration extensionConfiguration, @NotNull RepositoryDetector repositoryDetector) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Intrinsics.checkNotNullParameter(buildIdTask, (String)"buildIdTask");
            Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Intrinsics.checkNotNullParameter((Object)extensionConfiguration, (String)"extensionConfiguration");
            Intrinsics.checkNotNullParameter((Object)repositoryDetector, (String)"repositoryDetector");
            Object[] objectArray = new Object[]{repositoryDetector};
            Object[] $this$register_u24lambda_u243 = objectArray = project.getTasks().register(NdkSymbolFileUploadTask.TASK_NAME + StringsKt.capitalize((String)variant.getName()), NdkSymbolFileUploadTask.class, objectArray);
            boolean bl = false;
            $this$register_u24lambda_u243.configure(arg_0 -> Companion.register$lambda$3$lambda$2(arg_0 -> Companion.register$lambda$3$lambda$1(variant, project, extensionConfiguration, apiKey, buildIdTask, providerFactory, arg_0), arg_0));
            Object[] objectArray2 = objectArray;
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"apply(...)");
            return objectArray2;
        }

        private static final Unit register$lambda$3$lambda$1(AppVariant $variant, Project $project, DdExtensionConfiguration $extensionConfiguration, ApiKey $apiKey, TaskProvider $buildIdTask, ProviderFactory $providerFactory, NdkSymbolFileUploadTask task) {
            task.getSourceSetRoots().set($variant.collectJavaAndKotlinSourceDirectories());
            Intrinsics.checkNotNull((Object)((Object)task));
            $variant.bindWith(task);
            File file = $project.getRootDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getRootDir(...)");
            task.setDatadogCiFile(TaskUtils.INSTANCE.findDatadogCiFile(file));
            task.setRepositoryFile(TaskUtils.INSTANCE.resolveDatadogRepositoryFile($project));
            List<String> list = $extensionConfiguration.getAdditionalSymbolFilesLocations();
            if (list != null) {
                List<String> it = list;
                boolean bl = false;
                Object[] objectArray = new Object[1];
                Collection $this$toTypedArray$iv = it;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                objectArray[0] = thisCollection$iv.toArray(new String[0]);
                task.getSearchDirectories().from(objectArray);
            }
            task.configureWith$dd_sdk_android_gradle_plugin($apiKey, $extensionConfiguration, $variant);
            task.getBuildId().set(TaskExtKt.lazyBuildIdProvider((TaskProvider<GenerateBuildIdTask>)$buildIdTask, $providerFactory));
            return Unit.INSTANCE;
        }

        private static final void register$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/datadog/gradle/plugin/NdkSymbolFileUploadTask$SupportedArchitectureMapping;", "", "arch", "", "uploadArch", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getArch", "()Ljava/lang/String;", "getUploadArch", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "dd-sdk-android-gradle-plugin"})
    public static final class SupportedArchitectureMapping {
        @NotNull
        private final String arch;
        @NotNull
        private final String uploadArch;

        public SupportedArchitectureMapping(@NotNull String arch, @NotNull String uploadArch) {
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            Intrinsics.checkNotNullParameter((Object)uploadArch, (String)"uploadArch");
            this.arch = arch;
            this.uploadArch = uploadArch;
        }

        @NotNull
        public final String getArch() {
            return this.arch;
        }

        @NotNull
        public final String getUploadArch() {
            return this.uploadArch;
        }

        @NotNull
        public final String component1() {
            return this.arch;
        }

        @NotNull
        public final String component2() {
            return this.uploadArch;
        }

        @NotNull
        public final SupportedArchitectureMapping copy(@NotNull String arch, @NotNull String uploadArch) {
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            Intrinsics.checkNotNullParameter((Object)uploadArch, (String)"uploadArch");
            return new SupportedArchitectureMapping(arch, uploadArch);
        }

        public static /* synthetic */ SupportedArchitectureMapping copy$default(SupportedArchitectureMapping supportedArchitectureMapping, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = supportedArchitectureMapping.arch;
            }
            if ((n & 2) != 0) {
                string2 = supportedArchitectureMapping.uploadArch;
            }
            return supportedArchitectureMapping.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "SupportedArchitectureMapping(arch=" + this.arch + ", uploadArch=" + this.uploadArch + ")";
        }

        public int hashCode() {
            int result = this.arch.hashCode();
            result = result * 31 + this.uploadArch.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SupportedArchitectureMapping)) {
                return false;
            }
            SupportedArchitectureMapping supportedArchitectureMapping = (SupportedArchitectureMapping)other;
            if (!Intrinsics.areEqual((Object)this.arch, (Object)supportedArchitectureMapping.arch)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.uploadArch, (Object)supportedArchitectureMapping.uploadArch);
        }
    }
}

