/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.gradle.plugin;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/datadog/gradle/plugin/RepositoryInfo;", "", "url", "", "hash", "sourceFiles", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getUrl", "()Ljava/lang/String;", "getHash", "getSourceFiles", "()Ljava/util/List;", "toJson", "Lorg/json/JSONObject;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "dd-sdk-android-gradle-plugin"})
public final class RepositoryInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final String hash;
    @NotNull
    private final List<String> sourceFiles;
    @NotNull
    public static final String KEY_REMOTE_URL = "repository_url";
    @NotNull
    public static final String KEY_COMMIT_HASH = "hash";
    @NotNull
    public static final String KEY_TRACKED_FILES = "files";

    public RepositoryInfo(@NotNull String url, @NotNull String hash, @NotNull List<String> sourceFiles) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)hash, (String)KEY_COMMIT_HASH);
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        this.url = url;
        this.hash = hash;
        this.sourceFiles = sourceFiles;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getHash() {
        return this.hash;
    }

    @NotNull
    public final List<String> getSourceFiles() {
        return this.sourceFiles;
    }

    @NotNull
    public final JSONObject toJson() {
        JSONObject repository = new JSONObject();
        repository.put(KEY_REMOTE_URL, (Object)this.url);
        repository.put(KEY_COMMIT_HASH, (Object)this.hash);
        repository.put(KEY_TRACKED_FILES, (Object)new JSONArray((Collection)this.sourceFiles));
        return repository;
    }

    @NotNull
    public final String component1() {
        return this.url;
    }

    @NotNull
    public final String component2() {
        return this.hash;
    }

    @NotNull
    public final List<String> component3() {
        return this.sourceFiles;
    }

    @NotNull
    public final RepositoryInfo copy(@NotNull String url, @NotNull String hash, @NotNull List<String> sourceFiles) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)hash, (String)KEY_COMMIT_HASH);
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        return new RepositoryInfo(url, hash, sourceFiles);
    }

    public static /* synthetic */ RepositoryInfo copy$default(RepositoryInfo repositoryInfo, String string, String string2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = repositoryInfo.url;
        }
        if ((n & 2) != 0) {
            string2 = repositoryInfo.hash;
        }
        if ((n & 4) != 0) {
            list = repositoryInfo.sourceFiles;
        }
        return repositoryInfo.copy(string, string2, list);
    }

    @NotNull
    public String toString() {
        return "RepositoryInfo(url=" + this.url + ", hash=" + this.hash + ", sourceFiles=" + this.sourceFiles + ")";
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = result * 31 + this.hash.hashCode();
        result = result * 31 + ((Object)this.sourceFiles).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RepositoryInfo)) {
            return false;
        }
        RepositoryInfo repositoryInfo = (RepositoryInfo)other;
        if (!Intrinsics.areEqual((Object)this.url, (Object)repositoryInfo.url)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.hash, (Object)repositoryInfo.hash)) {
            return false;
        }
        return Intrinsics.areEqual(this.sourceFiles, repositoryInfo.sourceFiles);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/gradle/plugin/RepositoryInfo$Companion;", "", "<init>", "()V", "KEY_REMOTE_URL", "", "KEY_COMMIT_HASH", "KEY_TRACKED_FILES", "dd-sdk-android-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

