/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.gradle.plugin;

import com.android.builder.model.Version;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0007J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J(\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u0005J(\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/datadog/gradle/plugin/TaskUtils;", "", "<init>", "()V", "MAX_DATADOG_CI_FILE_LOOKUP_LEVELS", "", "resolveDatadogRepositoryFile", "Ljava/io/File;", "target", "Lorg/gradle/api/Project;", "findDatadogCiFile", "projectDir", "isAgpAbove", "", "major", "minor", "patch", "isGradleAbove", "project", "isVersionAbove", "refVersion", "", "dd-sdk-android-gradle-plugin"})
public final class TaskUtils {
    @NotNull
    public static final TaskUtils INSTANCE = new TaskUtils();
    private static final int MAX_DATADOG_CI_FILE_LOOKUP_LEVELS = 4;

    private TaskUtils() {
    }

    @NotNull
    public final File resolveDatadogRepositoryFile(@NotNull Project target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        File outputsDir = new File(target.getBuildDir(), "outputs");
        File reportsDir = new File(outputsDir, "reports");
        File datadogDir = new File(reportsDir, "datadog");
        return new File(datadogDir, "repository.json");
    }

    @Nullable
    public final File findDatadogCiFile(@NotNull File projectDir) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        File currentDir = projectDir;
        for (int levelsUp = 0; currentDir != null && levelsUp < 4; currentDir = currentDir.getParentFile(), ++levelsUp) {
            File datadogCiFile = new File(currentDir, "datadog-ci.json");
            if (!datadogCiFile.exists()) continue;
            return datadogCiFile;
        }
        return null;
    }

    public final boolean isAgpAbove(int major, int minor, int patch) {
        String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
        return this.isVersionAbove(string, major, minor, patch);
    }

    public final boolean isGradleAbove(@NotNull Project project, int major, int minor, int patch) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = project.getGradle().getGradleVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGradleVersion(...)");
        return this.isVersionAbove(string, major, minor, patch);
    }

    public static /* synthetic */ boolean isGradleAbove$default(TaskUtils taskUtils, Project project, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        return taskUtils.isGradleAbove(project, n, n2, n3);
    }

    private final boolean isVersionAbove(String refVersion, int major, int minor, int patch) {
        String[] stringArray = new String[]{"."};
        List groups = StringsKt.split$default((CharSequence)refVersion, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (groups.size() < 2) {
            return false;
        }
        Integer n = StringsKt.toIntOrNull((String)((String)groups.get(0)));
        int currentMajor = n != null ? n : 0;
        Integer n2 = StringsKt.toIntOrNull((String)((String)groups.get(1)));
        int currentMinor = n2 != null ? n2 : 0;
        Object object = (String)CollectionsKt.getOrNull((List)groups, (int)2);
        int currentPatch = object != null && (object = StringsKt.substringBefore$default((String)object, (String)"-", null, (int)2, null)) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
        return currentMajor >= major && currentMinor >= minor && currentPatch >= patch;
    }
}

