/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.gradle.plugin.internal;

import com.datadog.gradle.plugin.DdAndroidGradlePlugin;
import com.datadog.gradle.plugin.RepositoryDetector;
import com.datadog.gradle.plugin.RepositoryInfo;
import com.datadog.gradle.plugin.internal.ProjectExtKt;
import com.datadog.gradle.plugin.internal.sanitizer.GitRemoteUrlSanitizer;
import com.datadog.gradle.plugin.internal.sanitizer.UrlSanitizer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.process.ExecOperations;
import org.gradle.process.internal.ExecException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/datadog/gradle/plugin/internal/GitRepositoryDetector;", "Lcom/datadog/gradle/plugin/RepositoryDetector;", "execOperations", "Lorg/gradle/process/ExecOperations;", "urlSanitizer", "Lcom/datadog/gradle/plugin/internal/sanitizer/UrlSanitizer;", "<init>", "(Lorg/gradle/process/ExecOperations;Lcom/datadog/gradle/plugin/internal/sanitizer/UrlSanitizer;)V", "detectRepositories", "", "Lcom/datadog/gradle/plugin/RepositoryInfo;", "sourceSetRoots", "Ljava/io/File;", "extensionProvidedRemoteUrl", "", "sanitizeUrl", "remoteUrl", "resolveRemoteUrl", "listTrackedFilesPath", "listFilePathsInFolder", "", "sourceSetRoot", "files", "", "dd-sdk-android-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGitRepositoryDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepositoryDetector.kt\ncom/datadog/gradle/plugin/internal/GitRepositoryDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1863#2,2:99\n*S KotlinDebug\n*F\n+ 1 GitRepositoryDetector.kt\ncom/datadog/gradle/plugin/internal/GitRepositoryDetector\n*L\n68#1:99,2\n*E\n"})
public final class GitRepositoryDetector
implements RepositoryDetector {
    @NotNull
    private final ExecOperations execOperations;
    @NotNull
    private final UrlSanitizer urlSanitizer;

    public GitRepositoryDetector(@NotNull ExecOperations execOperations, @NotNull UrlSanitizer urlSanitizer) {
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        Intrinsics.checkNotNullParameter((Object)urlSanitizer, (String)"urlSanitizer");
        this.execOperations = execOperations;
        this.urlSanitizer = urlSanitizer;
    }

    public /* synthetic */ GitRepositoryDetector(ExecOperations execOperations, UrlSanitizer urlSanitizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            urlSanitizer = new GitRemoteUrlSanitizer(null, 1, null);
        }
        this(execOperations, urlSanitizer);
    }

    @Override
    @NotNull
    public List<RepositoryInfo> detectRepositories(@NotNull List<? extends File> sourceSetRoots, @NotNull String extensionProvidedRemoteUrl) {
        Intrinsics.checkNotNullParameter(sourceSetRoots, (String)"sourceSetRoots");
        Intrinsics.checkNotNullParameter((Object)extensionProvidedRemoteUrl, (String)"extensionProvidedRemoteUrl");
        try {
            String[] stringArray = new String[]{"git", "rev-parse", "--is-inside-work-tree"};
            ProjectExtKt.execShell(this.execOperations, stringArray);
        }
        catch (ExecException e) {
            DdAndroidGradlePlugin.Companion.getLOGGER$dd_sdk_android_gradle_plugin().error("Project is not a git repository", (Throwable)e);
            return CollectionsKt.emptyList();
        }
        String remoteUrl = this.sanitizeUrl(this.resolveRemoteUrl(extensionProvidedRemoteUrl));
        String[] stringArray = new String[]{"git", "rev-parse", "HEAD"};
        String commitHash = ((Object)StringsKt.trim((CharSequence)ProjectExtKt.execShell(this.execOperations, stringArray))).toString();
        List<String> trackedFiles = this.listTrackedFilesPath(sourceSetRoots);
        return CollectionsKt.listOf((Object)new RepositoryInfo(remoteUrl, commitHash, trackedFiles));
    }

    private final String sanitizeUrl(String remoteUrl) {
        return this.urlSanitizer.sanitize(remoteUrl);
    }

    private final String resolveRemoteUrl(String extensionProvidedRemoteUrl) {
        String string;
        if (((CharSequence)extensionProvidedRemoteUrl).length() > 0) {
            string = extensionProvidedRemoteUrl;
        } else {
            String[] stringArray = new String[]{"git", "remote", "get-url", "origin"};
            string = ((Object)StringsKt.trim((CharSequence)ProjectExtKt.execShell(this.execOperations, stringArray))).toString();
        }
        return string;
    }

    private final List<String> listTrackedFilesPath(List<? extends File> sourceSetRoots) {
        List files = new ArrayList();
        Iterable $this$forEach$iv = sourceSetRoots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File sourceSetRoot = (File)element$iv;
            boolean bl = false;
            DdAndroidGradlePlugin.Companion.getLOGGER$dd_sdk_android_gradle_plugin().info("Listing " + sourceSetRoot.getAbsolutePath());
            if (!sourceSetRoot.exists() || !sourceSetRoot.isDirectory()) continue;
            this.listFilePathsInFolder(sourceSetRoot, files);
        }
        return files;
    }

    private final void listFilePathsInFolder(File sourceSetRoot, List<String> files) {
        String[] stringArray = new String[]{"git", "ls-files", "--full-name", sourceSetRoot.getAbsolutePath()};
        Set sourceSetFiles = CollectionsKt.toSet((Iterable)StringsKt.lines((CharSequence)((Object)StringsKt.trim((CharSequence)ProjectExtKt.execShell(this.execOperations, stringArray))).toString()));
        files.addAll(sourceSetFiles);
    }
}

