/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.gradle.plugin.internal;

import com.datadog.gradle.plugin.DatadogSite;
import com.datadog.gradle.plugin.DdAndroidGradlePlugin;
import com.datadog.gradle.plugin.RepositoryInfo;
import com.datadog.gradle.plugin.internal.DdAppIdentifier;
import com.datadog.gradle.plugin.internal.MaxSizeExceededException;
import com.datadog.gradle.plugin.internal.Uploader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JL\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J,\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J*\u0010\u001b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001f\u0010\u001e\u001a\u0004\u0018\u00010\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u001fJ\f\u0010 \u001a\u00020!*\u00020!H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Lcom/datadog/gradle/plugin/internal/OkHttpUploader;", "Lcom/datadog/gradle/plugin/internal/Uploader;", "<init>", "()V", "client", "Lokhttp3/OkHttpClient;", "getClient$dd_sdk_android_gradle_plugin", "()Lokhttp3/OkHttpClient;", "upload", "", "site", "Lcom/datadog/gradle/plugin/DatadogSite;", "fileInfo", "Lcom/datadog/gradle/plugin/internal/Uploader$UploadFileInfo;", "repositoryFile", "Ljava/io/File;", "apiKey", "", "identifier", "Lcom/datadog/gradle/plugin/internal/DdAppIdentifier;", "repositoryInfo", "Lcom/datadog/gradle/plugin/RepositoryInfo;", "useGzip", "", "emulateNetworkCall", "createBody", "Lokhttp3/MultipartBody;", "handleResponse", "response", "Lokhttp3/Response;", "validateApiKey", "(Lcom/datadog/gradle/plugin/DatadogSite;Ljava/lang/String;)Ljava/lang/Boolean;", "gzip", "Lokhttp3/RequestBody;", "InvalidApiKeyException", "Companion", "dd-sdk-android-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nOkHttpUploader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpUploader.kt\ncom/datadog/gradle/plugin/internal/OkHttpUploader\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,300:1\n216#2,2:301\n66#3:303\n52#3,21:304\n*S KotlinDebug\n*F\n+ 1 OkHttpUploader.kt\ncom/datadog/gradle/plugin/internal/OkHttpUploader\n*L\n123#1:301,2\n193#1:303\n193#1:304,21\n*E\n"})
public final class OkHttpUploader
implements Uploader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String VERSION = "1.13.0";
    @NotNull
    public static final String HEADER_API_KEY = "DD-API-KEY";
    @NotNull
    public static final String HEADER_EVP_ORIGIN = "DD-EVP-ORIGIN";
    @NotNull
    public static final String HEADER_EVP_ORIGIN_VERSION = "DD-EVP-ORIGIN-VERSION";
    @NotNull
    public static final String HEADER_REQUEST_ID = "DD-REQUEST-ID";
    @NotNull
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    @NotNull
    public static final String ENCODING_GZIP = "gzip";
    @NotNull
    public static final String KEY_EVENT = "event";
    @NotNull
    public static final String KEY_REPOSITORY = "repository";
    private static final long NETWORK_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(120L);
    @Nullable
    private static final MediaType MEDIA_TYPE_JSON = MediaType.Companion.parse("application/json");
    @NotNull
    public static final String MAX_MAP_SIZE_EXCEEDED_ERROR = "Unable to upload mapping file for %s because mapping file is too large; please refer to documentation regarding the limits";
    @NotNull
    private static final Integer[] successfulCodes;

    @NotNull
    public final OkHttpClient getClient$dd_sdk_android_gradle_plugin() {
        return new OkHttpClient.Builder().callTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(NETWORK_TIMEOUT_MS, TimeUnit.MILLISECONDS).connectTimeout(NETWORK_TIMEOUT_MS, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public void upload(@NotNull DatadogSite site, @NotNull Uploader.UploadFileInfo fileInfo, @Nullable File repositoryFile, @NotNull String apiKey, @NotNull DdAppIdentifier identifier, @Nullable RepositoryInfo repositoryInfo, boolean useGzip, boolean emulateNetworkCall) {
        Response response;
        Request request;
        Intrinsics.checkNotNullParameter((Object)((Object)site), (String)"site");
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        DdAndroidGradlePlugin.Companion.getLOGGER$dd_sdk_android_gradle_plugin().info("Uploading file " + fileInfo.getFileName() + " with tags " + identifier + " (site=" + site.getDomain$dd_sdk_android_gradle_plugin() + "):");
        if (!fileInfo.getExtraAttributes().isEmpty()) {
            DdAndroidGradlePlugin.Companion.getLOGGER$dd_sdk_android_gradle_plugin().info("  extra attributes: " + fileInfo.getExtraAttributes());
        }
        DdAndroidGradlePlugin.Companion.getLOGGER$dd_sdk_android_gradle_plugin().info("\n");
        MultipartBody body = this.createBody(identifier, fileInfo, repositoryFile, repositoryInfo);
        Request.Builder requestBuilder = new Request.Builder().url(site.uploadEndpoint$dd_sdk_android_gradle_plugin()).header(HEADER_EVP_ORIGIN, "dd-sdk-android-gradle-plugin").header(HEADER_EVP_ORIGIN_VERSION, VERSION).header(HEADER_API_KEY, apiKey);
        if (useGzip) {
            DdAndroidGradlePlugin.Companion.getLOGGER$dd_sdk_android_gradle_plugin().info("Creating request with GZIP encoding.");
            request = requestBuilder.post(this.gzip((RequestBody)body)).header(HEADER_CONTENT_ENCODING, ENCODING_GZIP).build();
        } else {
            DdAndroidGradlePlugin.Companion.getLOGGER$dd_sdk_android_gradle_plugin().info("Creating request without GZIP encoding.");
            request = requestBuilder.post((RequestBody)body).build();
        }
        Request request2 = request;
        Call call = this.getClient$dd_sdk_android_gradle_plugin().newCall(request2);
        try {
            response = emulateNetworkCall ? new Response.Builder().request(request2).protocol(Protocol.HTTP_2).message("fake-response").code(202).build() : call.execute();
        }
        catch (Throwable e) {
            DdAndroidGradlePlugin.Companion.getLOGGER$dd_sdk_android_gradle_plugin().error("Error uploading the mapping file for " + identifier, e);
            response = null;
        }
        Response response2 = response;
        this.handleResponse(response2, site, apiKey, identifier);
    }

    private final MultipartBody createBody(DdAppIdentifier identifier, Uploader.UploadFileInfo fileInfo, File repositoryFile, RepositoryInfo repositoryInfo) {
        RequestBody mappingFileBody = RequestBody.Companion.create(fileInfo.getFile(), MediaType.Companion.parse(fileInfo.getEncoding()));
        JSONObject eventJson = new JSONObject();
        eventJson.put("version", (Object)identifier.getVersion());
        eventJson.put("service", (Object)identifier.getServiceName());
        eventJson.put("variant", (Object)identifier.getVariant());
        eventJson.put("build_id", (Object)identifier.getBuildId());
        eventJson.put("version_code", identifier.getVersionCode());
        eventJson.put("type", (Object)fileInfo.getFileType());
        Map<String, String> $this$forEach$iv = fileInfo.getExtraAttributes();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            String value = entry.getValue();
            eventJson.put(key, (Object)value);
        }
        DdAndroidGradlePlugin.Companion.getLOGGER$dd_sdk_android_gradle_plugin().info("  event: " + eventJson.toString(0));
        MultipartBody.Builder builder = new MultipartBody.Builder(null, 1, null);
        MultipartBody.Builder builder2 = builder.setType(MultipartBody.FORM);
        String string = eventJson.toString(0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        builder2.addFormDataPart(KEY_EVENT, KEY_EVENT, RequestBody.Companion.create(string, MEDIA_TYPE_JSON)).addFormDataPart(fileInfo.getFileKey(), fileInfo.getFileName(), mappingFileBody);
        if (repositoryFile != null) {
            RequestBody repositoryFileBody = RequestBody.Companion.create(repositoryFile, MEDIA_TYPE_JSON);
            builder.addFormDataPart(KEY_REPOSITORY, KEY_REPOSITORY, repositoryFileBody);
        }
        if (repositoryInfo != null) {
            builder.addFormDataPart("git_repository_url", repositoryInfo.getUrl());
            builder.addFormDataPart("git_commit_sha", repositoryInfo.getHash());
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleResponse(Response response, DatadogSite site, String apiKey, DdAppIdentifier identifier) {
        Response response2 = response;
        Integer statusCode = response2 != null ? Integer.valueOf(response2.code()) : null;
        if (statusCode == null) {
            throw new RuntimeException("Unable to upload mapping file with tags " + identifier + "; check your network connection");
        }
        if (ArraysKt.contains((Object[])successfulCodes, (Object)statusCode)) {
            DdAndroidGradlePlugin.Companion.getLOGGER$dd_sdk_android_gradle_plugin().quiet("Mapping file upload successful with tags " + identifier + ". \nMake sure the SDK is initialized with the same values to ensure proper deobfuscation. Mapping files will be processed and ready within the next five minutes.");
        } else {
            int n = 403;
            if (statusCode == n) {
                throw new InvalidApiKeyException(identifier, site);
            }
            n = 408;
            if (statusCode == n) {
                throw new RuntimeException("Unable to upload mapping file with tags " + identifier + " because of a request timeout; check your network connection");
            }
            n = 413;
            if (statusCode == n) {
                String string = MAX_MAP_SIZE_EXCEEDED_ERROR;
                Locale locale = Locale.US;
                Object[] objectArray = new Object[]{identifier};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                throw new MaxSizeExceededException(string2);
            }
            if (statusCode >= 400) {
                Throwable thrown$iv;
                Object result$iv;
                block20: {
                    n = 400;
                    if (statusCode == n && Intrinsics.areEqual((Object)this.validateApiKey(site, apiKey), (Object)false)) {
                        throw new InvalidApiKeyException(identifier, site);
                    }
                    Closeable $this$use$iv = (Closeable)response.body();
                    boolean $i$f$use = false;
                    result$iv = null;
                    thrown$iv = null;
                    try {
                        try {
                            ResponseBody it = (ResponseBody)$this$use$iv;
                            boolean bl = false;
                            ResponseBody responseBody = it;
                            throw new IllegalStateException("Unable to upload mapping file with tags " + identifier + " (" + statusCode + ");\n" + (responseBody != null ? responseBody.string() : null));
                        }
                        catch (Throwable t$iv) {
                            thrown$iv = t$iv;
                            try {
                                Closeable closeable = $this$use$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv2) {
                                if (thrown$iv == null) {
                                    thrown$iv = t$iv2;
                                    break block20;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            Closeable closeable = $this$use$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv) {
                            thrown$iv = t$iv;
                        }
                        throw throwable;
                    }
                }
                Throwable throwable = thrown$iv;
                if (throwable != null) {
                    throw throwable;
                }
                Intrinsics.checkNotNull(result$iv);
                throw new KotlinNothingValueException();
            }
        }
    }

    private final Boolean validateApiKey(DatadogSite site, String apiKey) {
        Boolean bl;
        Response response;
        Request request = new Request.Builder().url(site.apiKeyVerificationEndpoint$dd_sdk_android_gradle_plugin()).header(HEADER_API_KEY, apiKey).build();
        Call call = this.getClient$dd_sdk_android_gradle_plugin().newCall(request);
        try {
            response = call.execute();
        }
        catch (Throwable e) {
            DdAndroidGradlePlugin.Companion.getLOGGER$dd_sdk_android_gradle_plugin().error("Error checking the validity of API key", e);
            response = null;
        }
        Response response2 = response;
        if (response2 == null) {
            return null;
        }
        Response response3 = response2;
        switch (response3.code()) {
            case 200: {
                String body;
                ResponseBody responseBody = response3.body();
                String string = body = responseBody != null ? responseBody.string() : null;
                if (body != null) {
                    Boolean bl2;
                    try {
                        JSONObject json = new JSONObject(new JSONTokener(body));
                        bl2 = json.getBoolean("valid");
                    }
                    catch (JSONException jse) {
                        DdAndroidGradlePlugin.Companion.getLOGGER$dd_sdk_android_gradle_plugin().error("Unexpected format of API key validity check response", (Throwable)jse);
                        bl2 = null;
                    }
                    bl = bl2;
                    break;
                }
                bl = null;
                break;
            }
            case 403: {
                bl = false;
                break;
            }
            default: {
                bl = null;
            }
        }
        return bl;
    }

    private final RequestBody gzip(RequestBody $this$gzip) {
        RequestBody uncompressedBody = $this$gzip;
        return new RequestBody(uncompressedBody){
            final /* synthetic */ RequestBody $uncompressedBody;
            {
                this.$uncompressedBody = $uncompressedBody;
            }

            public MediaType contentType() {
                return this.$uncompressedBody.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                BufferedSink gzipSink = Okio.buffer((Sink)((Sink)new GzipSink((Sink)sink)));
                this.$uncompressedBody.writeTo(gzipSink);
                gzipSink.close();
            }

            public boolean isOneShot() {
                return this.$uncompressedBody.isOneShot();
            }
        };
    }

    static {
        Integer[] integerArray = new Integer[]{200, 201, 202};
        successfulCodes = integerArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lcom/datadog/gradle/plugin/internal/OkHttpUploader$Companion;", "", "<init>", "()V", "VERSION", "", "HEADER_API_KEY", "HEADER_EVP_ORIGIN", "HEADER_EVP_ORIGIN_VERSION", "HEADER_REQUEST_ID", "HEADER_CONTENT_ENCODING", "ENCODING_GZIP", "KEY_EVENT", "KEY_REPOSITORY", "NETWORK_TIMEOUT_MS", "", "getNETWORK_TIMEOUT_MS$dd_sdk_android_gradle_plugin", "()J", "MEDIA_TYPE_JSON", "Lokhttp3/MediaType;", "getMEDIA_TYPE_JSON$dd_sdk_android_gradle_plugin", "()Lokhttp3/MediaType;", "MAX_MAP_SIZE_EXCEEDED_ERROR", "successfulCodes", "", "", "getSuccessfulCodes$dd_sdk_android_gradle_plugin", "()[Ljava/lang/Integer;", "[Ljava/lang/Integer;", "dd-sdk-android-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final long getNETWORK_TIMEOUT_MS$dd_sdk_android_gradle_plugin() {
            return NETWORK_TIMEOUT_MS;
        }

        @Nullable
        public final MediaType getMEDIA_TYPE_JSON$dd_sdk_android_gradle_plugin() {
            return MEDIA_TYPE_JSON;
        }

        @NotNull
        public final Integer[] getSuccessfulCodes$dd_sdk_android_gradle_plugin() {
            return successfulCodes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/datadog/gradle/plugin/internal/OkHttpUploader$InvalidApiKeyException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "uploadIdentifier", "Lcom/datadog/gradle/plugin/internal/DdAppIdentifier;", "site", "Lcom/datadog/gradle/plugin/DatadogSite;", "<init>", "(Lcom/datadog/gradle/plugin/internal/OkHttpUploader;Lcom/datadog/gradle/plugin/internal/DdAppIdentifier;Lcom/datadog/gradle/plugin/DatadogSite;)V", "dd-sdk-android-gradle-plugin"})
    public final class InvalidApiKeyException
    extends RuntimeException {
        public InvalidApiKeyException(@NotNull DdAppIdentifier uploadIdentifier, DatadogSite site) {
            Intrinsics.checkNotNullParameter((Object)uploadIdentifier, (String)"uploadIdentifier");
            Intrinsics.checkNotNullParameter((Object)((Object)site), (String)"site");
            super("Unable to upload mapping file for " + uploadIdentifier + " (site=" + site.getDomain$dd_sdk_android_gradle_plugin() + "); verify that you're using a valid API Key");
        }
    }
}

