/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.gradle.plugin.internal.sanitizer;

import com.datadog.gradle.plugin.internal.sanitizer.FullUriGitRemoteUrlSanitizer;
import com.datadog.gradle.plugin.internal.sanitizer.ShortUriGitRemoteUrlSanitizer;
import com.datadog.gradle.plugin.internal.sanitizer.UriParsingException;
import com.datadog.gradle.plugin.internal.sanitizer.UrlSanitizer;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/gradle/plugin/internal/sanitizer/GitRemoteUrlSanitizer;", "Lcom/datadog/gradle/plugin/internal/sanitizer/UrlSanitizer;", "sanitizerResolver", "Lkotlin/Function1;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "sanitize", "url", "Companion", "dd-sdk-android-gradle-plugin"})
public final class GitRemoteUrlSanitizer
implements UrlSanitizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, UrlSanitizer> sanitizerResolver;
    @NotNull
    public static final String WRONG_URL_FORMAT_ERROR_MESSAGE = "The detected GIT remote url: [%s] is not a valid GIT url and it will not be browsable from the Error Tracking panel. You can provide a different URL through the plugin extension.";
    @NotNull
    public static final String VALID_SCHEMA_URL_FORMAT_PATTERN = "^(ssh|http|https)://(.+)$";
    @NotNull
    private static final Regex VALID_SCHEMA_URL_FORMAT_REGEX = new Regex("^(ssh|http|https)://(.+)$", RegexOption.IGNORE_CASE);

    public GitRemoteUrlSanitizer(@NotNull Function1<? super String, ? extends UrlSanitizer> sanitizerResolver) {
        Intrinsics.checkNotNullParameter(sanitizerResolver, (String)"sanitizerResolver");
        this.sanitizerResolver = sanitizerResolver;
    }

    public /* synthetic */ GitRemoteUrlSanitizer(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = GitRemoteUrlSanitizer::_init_$lambda$0;
        }
        this((Function1<? super String, ? extends UrlSanitizer>)function1);
    }

    @Override
    @NotNull
    public String sanitize(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            return ((UrlSanitizer)this.sanitizerResolver.invoke((Object)url)).sanitize(url);
        }
        catch (Exception e) {
            String string = WRONG_URL_FORMAT_ERROR_MESSAGE;
            Object[] objectArray = new Object[]{url, Locale.US};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new UriParsingException(string2, e);
        }
    }

    private static final UrlSanitizer _init_$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence charSequence = it;
        return VALID_SCHEMA_URL_FORMAT_REGEX.matches(charSequence) ? (UrlSanitizer)new FullUriGitRemoteUrlSanitizer() : (UrlSanitizer)new ShortUriGitRemoteUrlSanitizer();
    }

    public GitRemoteUrlSanitizer() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/datadog/gradle/plugin/internal/sanitizer/GitRemoteUrlSanitizer$Companion;", "", "<init>", "()V", "WRONG_URL_FORMAT_ERROR_MESSAGE", "", "VALID_SCHEMA_URL_FORMAT_PATTERN", "VALID_SCHEMA_URL_FORMAT_REGEX", "Lkotlin/text/Regex;", "getVALID_SCHEMA_URL_FORMAT_REGEX", "()Lkotlin/text/Regex;", "dd-sdk-android-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getVALID_SCHEMA_URL_FORMAT_REGEX() {
            return VALID_SCHEMA_URL_FORMAT_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

