/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.internal.utils;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import com.datadog.android.internal.utils.IntExtKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\"\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/internal/utils/ImageViewUtils;", "", "()V", "calculateClipping", "Landroid/graphics/Rect;", "parentRect", "childRect", "density", "", "positionRectAtEnd", "positionRectAtStart", "positionRectInCenter", "resolveContentRectWithScaling", "imageView", "Landroid/widget/ImageView;", "drawable", "Landroid/graphics/drawable/Drawable;", "customScaleType", "Landroid/widget/ImageView$ScaleType;", "resolveParentRectAbsPosition", "view", "Landroid/view/View;", "scaleRectToCenterCrop", "scaleRectToCenterInsideParent", "scaleRectToFitParent", "dd-sdk-android-internal_release"})
public final class ImageViewUtils {
    @NotNull
    public static final ImageViewUtils INSTANCE = new ImageViewUtils();

    private ImageViewUtils() {
    }

    @NotNull
    public final Rect resolveParentRectAbsPosition(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        int[] coords = new int[2];
        view.getLocationOnScreen(coords);
        int leftPadding = view.getPaddingLeft();
        int rightPadding = view.getPaddingRight();
        int topPadding = view.getPaddingTop();
        int bottomPadding = view.getPaddingBottom();
        return new Rect(coords[0] + leftPadding, coords[1] + topPadding, coords[0] + view.getWidth() - rightPadding, coords[1] + view.getHeight() - bottomPadding);
    }

    @NotNull
    public final Rect calculateClipping(@NotNull Rect parentRect, @NotNull Rect childRect, float density) {
        Intrinsics.checkNotNullParameter((Object)parentRect, (String)"parentRect");
        Intrinsics.checkNotNullParameter((Object)childRect, (String)"childRect");
        int left = childRect.left < parentRect.left ? parentRect.left - childRect.left : 0;
        int top = childRect.top < parentRect.top ? parentRect.top - childRect.top : 0;
        int right = childRect.right > parentRect.right ? childRect.right - parentRect.right : 0;
        int bottom = childRect.bottom > parentRect.bottom ? childRect.bottom - parentRect.bottom : 0;
        return new Rect(IntExtKt.densityNormalized(left, density), IntExtKt.densityNormalized(top, density), IntExtKt.densityNormalized(right, density), IntExtKt.densityNormalized(bottom, density));
    }

    @NotNull
    public final Rect resolveContentRectWithScaling(@NotNull ImageView imageView, @NotNull Drawable drawable, @Nullable ImageView.ScaleType customScaleType) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        int drawableWidthPx = drawable.getIntrinsicWidth();
        int drawableHeightPx = drawable.getIntrinsicHeight();
        Rect parentRect = this.resolveParentRectAbsPosition((View)imageView);
        Rect childRect = new Rect(0, 0, drawableWidthPx, drawableHeightPx);
        Rect resultRect = null;
        ImageView.ScaleType scaleType = customScaleType;
        if (scaleType == null) {
            scaleType = imageView.getScaleType();
        }
        switch (scaleType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[scaleType.ordinal()]) {
            case 1: {
                Rect contentRect = this.scaleRectToFitParent(parentRect, childRect);
                resultRect = this.positionRectAtStart(parentRect, contentRect);
                break;
            }
            case 2: {
                Rect contentRect = this.scaleRectToFitParent(parentRect, childRect);
                resultRect = this.positionRectAtEnd(parentRect, contentRect);
                break;
            }
            case 3: {
                Rect contentRect = this.scaleRectToFitParent(parentRect, childRect);
                resultRect = this.positionRectInCenter(parentRect, contentRect);
                break;
            }
            case 4: {
                Rect contentRect = this.scaleRectToCenterInsideParent(parentRect, childRect);
                resultRect = this.positionRectInCenter(parentRect, contentRect);
                break;
            }
            case 5: {
                resultRect = this.positionRectInCenter(parentRect, childRect);
                break;
            }
            case 6: {
                Rect contentRect = this.scaleRectToCenterCrop(parentRect, childRect);
                resultRect = this.positionRectInCenter(parentRect, contentRect);
                break;
            }
            case -1: 
            case 7: 
            case 8: {
                resultRect = new Rect(parentRect.left, parentRect.top, parentRect.right, parentRect.bottom);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return resultRect;
    }

    public static /* synthetic */ Rect resolveContentRectWithScaling$default(ImageViewUtils imageViewUtils, ImageView imageView, Drawable drawable, ImageView.ScaleType scaleType, int n, Object object) {
        if ((n & 4) != 0) {
            scaleType = null;
        }
        return imageViewUtils.resolveContentRectWithScaling(imageView, drawable, scaleType);
    }

    private final Rect scaleRectToCenterInsideParent(Rect parentRect, Rect childRect) {
        float scaleY;
        if (parentRect.width() > childRect.width() && parentRect.height() > childRect.height()) {
            return childRect;
        }
        float scaleX = (float)parentRect.width() / (float)childRect.width();
        float scaleFactor = Math.min(scaleX, scaleY = (float)parentRect.height() / (float)childRect.height());
        if (scaleFactor >= 1.0f) {
            scaleFactor = 1.0f;
        }
        float newWidth = (float)childRect.width() * scaleFactor;
        float newHeight = (float)childRect.height() * scaleFactor;
        Rect resultRect = new Rect();
        resultRect.left = parentRect.left;
        resultRect.top = parentRect.top;
        resultRect.right = resultRect.left + (int)newWidth;
        resultRect.bottom = resultRect.top + (int)newHeight;
        return resultRect;
    }

    private final Rect scaleRectToCenterCrop(Rect parentRect, Rect childRect) {
        float scaleX = (float)parentRect.width() / (float)childRect.width();
        float scaleY = (float)parentRect.height() / (float)childRect.height();
        float scaleFactor = Math.max(scaleX, scaleY);
        float newWidth = (float)childRect.width() * scaleFactor;
        float newHeight = (float)childRect.height() * scaleFactor;
        Rect resultRect = new Rect();
        resultRect.left = 0;
        resultRect.top = 0;
        resultRect.right = (int)newWidth;
        resultRect.bottom = (int)newHeight;
        return resultRect;
    }

    private final Rect scaleRectToFitParent(Rect parentRect, Rect childRect) {
        float scaleX = (float)parentRect.width() / (float)childRect.width();
        float scaleY = (float)parentRect.height() / (float)childRect.height();
        float scaleFactor = Math.min(scaleX, scaleY);
        float newWidth = (float)childRect.width() * scaleFactor;
        float newHeight = (float)childRect.height() * scaleFactor;
        Rect resultRect = new Rect();
        resultRect.left = 0;
        resultRect.top = 0;
        resultRect.right = (int)newWidth;
        resultRect.bottom = (int)newHeight;
        return resultRect;
    }

    private final Rect positionRectInCenter(Rect parentRect, Rect childRect) {
        int centerXParentPx = parentRect.centerX();
        int centerYParentPx = parentRect.centerY();
        int childRectWidthPx = childRect.width();
        int childRectHeightPx = childRect.height();
        Rect resultRect = new Rect();
        resultRect.left = centerXParentPx - childRectWidthPx / 2;
        resultRect.top = centerYParentPx - childRectHeightPx / 2;
        resultRect.right = resultRect.left + childRectWidthPx;
        resultRect.bottom = resultRect.top + childRectHeightPx;
        return resultRect;
    }

    private final Rect positionRectAtStart(Rect parentRect, Rect childRect) {
        int childRectWidthPx = childRect.width();
        int childRectHeightPx = childRect.height();
        Rect resultRect = new Rect();
        resultRect.left = parentRect.left;
        resultRect.top = parentRect.top;
        resultRect.right = resultRect.left + childRectWidthPx;
        resultRect.bottom = resultRect.top + childRectHeightPx;
        return resultRect;
    }

    private final Rect positionRectAtEnd(Rect parentRect, Rect childRect) {
        int childRectWidthPx = childRect.width();
        int childRectHeightPx = childRect.height();
        Rect resultRect = new Rect();
        resultRect.right = parentRect.right;
        resultRect.bottom = parentRect.bottom;
        resultRect.left = parentRect.right - childRectWidthPx;
        resultRect.top = parentRect.bottom - childRectHeightPx;
        return resultRect;
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageView.ScaleType.values().length];
            try {
                nArray[ImageView.ScaleType.FIT_START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.FIT_END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.FIT_CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.CENTER_INSIDE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.CENTER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.CENTER_CROP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.FIT_XY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.MATRIX.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

