/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.ktx.rum;

import android.content.Context;
import android.content.res.Resources;
import androidx.annotation.RawRes;
import com.datadog.android.Datadog;
import com.datadog.android.api.SdkCore;
import com.datadog.android.rum.resource.RumResourceInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a&\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u0003*\u00020\u00042\b\b\u0001\u0010\u000b\u001a\u00020\u00012\b\b\u0002\u0010\b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"HEX_RADIX", "", "getAssetAsRumResource", "Ljava/io/InputStream;", "Landroid/content/Context;", "fileName", "", "accessMode", "sdkCore", "Lcom/datadog/android/api/SdkCore;", "getRawResAsRumResource", "id", "dd-sdk-android-ktx_release"})
public final class ContextExtKt {
    public static final int HEX_RADIX = 16;

    @NotNull
    public static final InputStream getAssetAsRumResource(@NotNull Context $this$getAssetAsRumResource, @NotNull String fileName, int accessMode, @NotNull SdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)$this$getAssetAsRumResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        InputStream inputStream = $this$getAssetAsRumResource.getAssets().open(fileName, accessMode);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"assets.open(fileName, accessMode)");
        return (InputStream)new RumResourceInputStream(inputStream, "assets://" + fileName, sdkCore);
    }

    public static /* synthetic */ InputStream getAssetAsRumResource$default(Context context, String string, int n, SdkCore sdkCore, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        if ((n2 & 4) != 0) {
            sdkCore = Datadog.getInstance$default(null, (int)1, null);
        }
        return ContextExtKt.getAssetAsRumResource(context, string, n, sdkCore);
    }

    @NotNull
    public static final InputStream getRawResAsRumResource(@NotNull Context $this$getRawResAsRumResource, @RawRes int id, @NotNull SdkCore sdkCore) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getRawResAsRumResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        try {
            object = $this$getRawResAsRumResource.getResources().getResourceName(id);
        }
        catch (Resources.NotFoundException e) {
            String string = Integer.toString(id, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            object = "res/0x" + string;
        }
        String resName = object;
        InputStream inputStream = $this$getRawResAsRumResource.getResources().openRawResource(id);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"resources.openRawResource(id)");
        Intrinsics.checkNotNullExpressionValue((Object)resName, (String)"resName");
        return (InputStream)new RumResourceInputStream(inputStream, resName, sdkCore);
    }

    public static /* synthetic */ InputStream getRawResAsRumResource$default(Context context, int n, SdkCore sdkCore, int n2, Object object) {
        if ((n2 & 2) != 0) {
            sdkCore = Datadog.getInstance$default(null, (int)1, null);
        }
        return ContextExtKt.getRawResAsRumResource(context, n, sdkCore);
    }
}

