/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log.internal.domain;

import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.context.NetworkInfo;
import com.datadog.android.api.context.UserInfo;
import com.datadog.android.core.feature.event.ThreadDump;
import com.datadog.android.log.internal.domain.LogGenerator;
import com.datadog.android.log.internal.utils.LogUtilsKt;
import com.datadog.android.log.model.LogEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u00a6\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u00a0\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010&\u001a\u0004\u0018\u00010'2\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016J\u0092\u0001\u0010+\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\b\u0010,\u001a\u0004\u0018\u00010-2\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002JL\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00170/2\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010 \u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u001eH\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u00102\u001a\u0002032\u0006\u0010\n\u001a\u00020\u000b2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0012\u00104\u001a\u0004\u0018\u0001052\u0006\u0010$\u001a\u00020%H\u0002J$\u00106\u001a\b\u0012\u0004\u0012\u00020\u0003072\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019H\u0002J\u001a\u00108\u001a\u0002092\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/datadog/android/log/internal/domain/DatadogLogGenerator;", "Lcom/datadog/android/log/internal/domain/LogGenerator;", "serviceName", "", "(Ljava/lang/String;)V", "getServiceName$dd_sdk_android_logs_release", "()Ljava/lang/String;", "simpleDateFormat", "Ljava/text/SimpleDateFormat;", "appVersionTag", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "envTag", "generateLog", "Lcom/datadog/android/log/model/LogEvent;", "level", "", "message", "errorKind", "errorMessage", "errorStack", "attributes", "", "", "tags", "", "timestamp", "", "threadName", "attachNetworkInfo", "", "loggerName", "bundleWithTraces", "bundleWithRum", "userInfo", "Lcom/datadog/android/api/context/UserInfo;", "networkInfo", "Lcom/datadog/android/api/context/NetworkInfo;", "throwable", "", "threads", "", "Lcom/datadog/android/core/feature/event/ThreadDump;", "internalGenerateLog", "error", "Lcom/datadog/android/log/model/LogEvent$Error;", "resolveAttributes", "", "resolveLogLevelStatus", "Lcom/datadog/android/log/model/LogEvent$Status;", "resolveNetworkInfo", "Lcom/datadog/android/log/model/LogEvent$Network;", "resolveSimCarrier", "Lcom/datadog/android/log/model/LogEvent$SimCarrier;", "resolveTags", "", "resolveUserInfo", "Lcom/datadog/android/log/model/LogEvent$Usr;", "variantTag", "Companion", "dd-sdk-android-logs_release"})
@SourceDebugExtension(value={"SMAP\nDatadogLogGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatadogLogGenerator.kt\ncom/datadog/android/log/internal/domain/DatadogLogGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,332:1\n1549#2:333\n1620#2,3:334\n1#3:337\n*S KotlinDebug\n*F\n+ 1 DatadogLogGenerator.kt\ncom/datadog/android/log/internal/domain/DatadogLogGenerator\n*L\n56#1:333\n56#1:334,3\n*E\n"})
public final class DatadogLogGenerator
implements LogGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String serviceName;
    @NotNull
    private final SimpleDateFormat simpleDateFormat;
    @NotNull
    public static final String ISO_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final int CRASH = 9;

    public DatadogLogGenerator(@Nullable String serviceName) {
        this.serviceName = serviceName;
        this.simpleDateFormat = LogUtilsKt.buildLogDateFormat();
    }

    public /* synthetic */ DatadogLogGenerator(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    @Nullable
    public final String getServiceName$dd_sdk_android_logs_release() {
        return this.serviceName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LogEvent generateLog(int level, @NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes, @NotNull Set<String> tags, long timestamp, @NotNull String threadName, @NotNull DatadogContext datadogContext, boolean attachNetworkInfo, @NotNull String loggerName, boolean bundleWithTraces, boolean bundleWithRum, @Nullable UserInfo userInfo, @Nullable NetworkInfo networkInfo, @NotNull List<ThreadDump> threads) {
        LogEvent.Error error;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        Intrinsics.checkNotNullParameter(threads, (String)"threads");
        Map mutableAttributes = MapsKt.toMutableMap(attributes);
        Throwable throwable2 = throwable;
        if (throwable2 != null) {
            Collection collection;
            void $this$mapTo$iv$iv;
            Throwable it = throwable2;
            boolean bl = false;
            Object v = mutableAttributes.remove("_dd.error.fingerprint");
            String fingerprint = v instanceof String ? (String)v : null;
            String string = it.getClass().getCanonicalName();
            if (string == null) {
                string = it.getClass().getSimpleName();
            }
            String kind = string;
            String string2 = ExceptionsKt.stackTraceToString((Throwable)it);
            String string3 = it.getMessage();
            Iterable $this$map$iv = threads;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void thread;
                ThreadDump threadDump = (ThreadDump)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(new LogEvent.Thread(thread.getName(), thread.getCrashed(), thread.getStack(), thread.getState()));
            }
            Collection collection3 = (List)destination$iv$iv;
            if (collection3.isEmpty()) {
                boolean bl3 = false;
                collection = null;
            } else {
                collection = collection3;
            }
            List list = (List)collection;
            error = new LogEvent.Error(kind, string3, string2, null, fingerprint, list, 8, null);
        } else {
            error = null;
        }
        LogEvent.Error error2 = error;
        return this.internalGenerateLog(level, message, error2, mutableAttributes, tags, timestamp, threadName, datadogContext, attachNetworkInfo, loggerName, bundleWithTraces, bundleWithRum, userInfo, networkInfo);
    }

    @Override
    @NotNull
    public LogEvent generateLog(int level, @NotNull String message, @Nullable String errorKind, @Nullable String errorMessage, @Nullable String errorStack, @NotNull Map<String, ? extends Object> attributes, @NotNull Set<String> tags, long timestamp, @NotNull String threadName, @NotNull DatadogContext datadogContext, boolean attachNetworkInfo, @NotNull String loggerName, boolean bundleWithTraces, boolean bundleWithRum, @Nullable UserInfo userInfo, @Nullable NetworkInfo networkInfo) {
        LogEvent.Error error;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        Map mutableAttributes = MapsKt.toMutableMap(attributes);
        if (errorKind != null || errorMessage != null || errorStack != null) {
            Object v = mutableAttributes.remove("_dd.error.source_type");
            String sourceType = v instanceof String ? (String)v : null;
            Object v2 = mutableAttributes.remove("_dd.error.fingerprint");
            String fingerprint = v2 instanceof String ? (String)v2 : null;
            error = new LogEvent.Error(errorKind, errorMessage, errorStack, sourceType, fingerprint, null, 32, null);
        } else {
            error = null;
        }
        LogEvent.Error error2 = error;
        return this.internalGenerateLog(level, message, error2, mutableAttributes, tags, timestamp, threadName, datadogContext, attachNetworkInfo, loggerName, bundleWithTraces, bundleWithRum, userInfo, networkInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LogEvent internalGenerateLog(int level, String message, LogEvent.Error error, Map<String, ? extends Object> attributes, Set<String> tags, long timestamp, String threadName, DatadogContext datadogContext, boolean attachNetworkInfo, String loggerName, boolean bundleWithTraces, boolean bundleWithRum, UserInfo userInfo, NetworkInfo networkInfo) {
        String $i$a$-synchronized-DatadogLogGenerator$internalGenerateLog$formattedDate$22;
        long resolvedTimestamp = timestamp + datadogContext.getTime().getServerTimeOffsetMs();
        Map<String, Object> combinedAttributes = this.resolveAttributes(datadogContext, attributes, bundleWithTraces, threadName, bundleWithRum);
        SimpleDateFormat simpleDateFormat = this.simpleDateFormat;
        synchronized (simpleDateFormat) {
            boolean $i$a$-synchronized-DatadogLogGenerator$internalGenerateLog$formattedDate$22 = false;
            $i$a$-synchronized-DatadogLogGenerator$internalGenerateLog$formattedDate$22 = this.simpleDateFormat.format(new Date(resolvedTimestamp));
        }
        String formattedDate = $i$a$-synchronized-DatadogLogGenerator$internalGenerateLog$formattedDate$22;
        Set<String> combinedTags = this.resolveTags(datadogContext, tags);
        LogEvent.Usr usr = this.resolveUserInfo(datadogContext, userInfo);
        LogEvent.Network network = networkInfo != null || attachNetworkInfo ? this.resolveNetworkInfo(datadogContext, networkInfo) : null;
        LogEvent.Logger loggerInfo = new LogEvent.Logger(loggerName, threadName, datadogContext.getSdkVersion());
        String string = this.serviceName;
        if (string == null) {
            string = datadogContext.getService();
        }
        String string2 = string;
        LogEvent.Status status = this.resolveLogLevelStatus(level);
        String string3 = datadogContext.getAppBuildId();
        LogEvent.Dd dd = new LogEvent.Dd(new LogEvent.Device(datadogContext.getDeviceInfo().getArchitecture()));
        String string4 = CollectionsKt.joinToString$default((Iterable)combinedTags, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        Intrinsics.checkNotNullExpressionValue((Object)formattedDate, (String)"formattedDate");
        return new LogEvent(status, string2, message, formattedDate, loggerInfo, dd, usr, network, error, string3, string4, combinedAttributes);
    }

    private final String envTag(DatadogContext datadogContext) {
        String envName = datadogContext.getEnv();
        return ((CharSequence)envName).length() > 0 ? "env:" + envName : null;
    }

    private final String appVersionTag(DatadogContext datadogContext) {
        String appVersion = datadogContext.getVersion();
        return ((CharSequence)appVersion).length() > 0 ? "version:" + appVersion : null;
    }

    private final String variantTag(DatadogContext datadogContext) {
        String variant = datadogContext.getVariant();
        return ((CharSequence)variant).length() > 0 ? "variant:" + variant : null;
    }

    private final LogEvent.Network resolveNetworkInfo(DatadogContext datadogContext, NetworkInfo networkInfo) {
        NetworkInfo networkInfo2 = networkInfo;
        if (networkInfo2 == null) {
            networkInfo2 = datadogContext.getNetworkInfo();
        }
        NetworkInfo $this$resolveNetworkInfo_u24lambda_u244 = networkInfo2;
        boolean bl = false;
        Long l = $this$resolveNetworkInfo_u24lambda_u244.getStrength();
        Long l2 = $this$resolveNetworkInfo_u24lambda_u244.getDownKbps();
        Long l3 = $this$resolveNetworkInfo_u24lambda_u244.getUpKbps();
        return new LogEvent.Network(new LogEvent.Client(this.resolveSimCarrier($this$resolveNetworkInfo_u24lambda_u244), l != null ? l.toString() : null, l2 != null ? l2.toString() : null, l3 != null ? l3.toString() : null, $this$resolveNetworkInfo_u24lambda_u244.getConnectivity().toString()));
    }

    private final LogEvent.Usr resolveUserInfo(DatadogContext datadogContext, UserInfo userInfo) {
        UserInfo userInfo2 = userInfo;
        if (userInfo2 == null) {
            userInfo2 = datadogContext.getUserInfo();
        }
        UserInfo $this$resolveUserInfo_u24lambda_u245 = userInfo2;
        boolean bl = false;
        String string = $this$resolveUserInfo_u24lambda_u245.getName();
        String string2 = $this$resolveUserInfo_u24lambda_u245.getEmail();
        String string3 = $this$resolveUserInfo_u24lambda_u245.getId();
        Map map2 = MapsKt.toMutableMap((Map)$this$resolveUserInfo_u24lambda_u245.getAdditionalProperties());
        return new LogEvent.Usr(string3, string, string2, map2);
    }

    private final Set<String> resolveTags(DatadogContext datadogContext, Set<String> tags) {
        Set combinedTags;
        block2: {
            Set set;
            Set $this$resolveTags_u24lambda_u246 = set = (Set)new LinkedHashSet();
            boolean bl = false;
            $this$resolveTags_u24lambda_u246.addAll((Collection)tags);
            combinedTags = set;
            String string = this.envTag(datadogContext);
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                combinedTags.add(it);
            }
            String string2 = this.appVersionTag(datadogContext);
            if (string2 != null) {
                String it = string2;
                boolean bl3 = false;
                combinedTags.add(it);
            }
            String string3 = this.variantTag(datadogContext);
            if (string3 == null) break block2;
            String it = string3;
            boolean bl4 = false;
            combinedTags.add(it);
        }
        return combinedTags;
    }

    private final Map<String, Object> resolveAttributes(DatadogContext datadogContext, Map<String, ? extends Object> attributes, boolean bundleWithTraces, String threadName, boolean bundleWithRum) {
        Map combinedAttributes;
        block4: {
            Map map2;
            Map $this$resolveAttributes_u24lambda_u2410 = map2 = (Map)new LinkedHashMap();
            boolean bl = false;
            $this$resolveAttributes_u24lambda_u2410.putAll(attributes);
            combinedAttributes = map2;
            if (bundleWithTraces) {
                Map map3 = (Map)datadogContext.getFeaturesContext().get("tracing");
                if (map3 != null) {
                    Map threadLocalContext;
                    Map it = map3;
                    boolean bl2 = false;
                    Object v = it.get("context@" + threadName);
                    Map map4 = threadLocalContext = v instanceof Map ? (Map)v : null;
                    if (threadLocalContext != null) {
                        combinedAttributes.put("dd.trace_id", threadLocalContext.get("trace_id"));
                        combinedAttributes.put("dd.span_id", threadLocalContext.get("span_id"));
                    }
                }
            }
            if (!bundleWithRum) break block4;
            Map map5 = (Map)datadogContext.getFeaturesContext().get("rum");
            if (map5 != null) {
                Map it = map5;
                boolean bl3 = false;
                combinedAttributes.put("application_id", it.get("application_id"));
                combinedAttributes.put("session_id", it.get("session_id"));
                combinedAttributes.put("view.id", it.get("view_id"));
                combinedAttributes.put("user_action.id", it.get("action_id"));
            }
        }
        return combinedAttributes;
    }

    private final LogEvent.Status resolveLogLevelStatus(int level) {
        LogEvent.Status status;
        switch (level) {
            case 7: {
                status = LogEvent.Status.CRITICAL;
                break;
            }
            case 6: {
                status = LogEvent.Status.ERROR;
                break;
            }
            case 5: {
                status = LogEvent.Status.WARN;
                break;
            }
            case 4: {
                status = LogEvent.Status.INFO;
                break;
            }
            case 3: {
                status = LogEvent.Status.DEBUG;
                break;
            }
            case 2: {
                status = LogEvent.Status.TRACE;
                break;
            }
            case 9: {
                status = LogEvent.Status.EMERGENCY;
                break;
            }
            default: {
                status = LogEvent.Status.DEBUG;
            }
        }
        return status;
    }

    private final LogEvent.SimCarrier resolveSimCarrier(NetworkInfo networkInfo) {
        LogEvent.SimCarrier simCarrier;
        if (networkInfo.getCarrierId() != null || networkInfo.getCarrierName() != null) {
            Long l = networkInfo.getCarrierId();
            simCarrier = new LogEvent.SimCarrier(l != null ? l.toString() : null, networkInfo.getCarrierName());
        } else {
            simCarrier = null;
        }
        return simCarrier;
    }

    public DatadogLogGenerator() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/log/internal/domain/DatadogLogGenerator$Companion;", "", "()V", "CRASH", "", "ISO_8601", "", "dd-sdk-android-logs_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

