/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log.internal.logger;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.EventType;
import com.datadog.android.core.sampling.RateBasedSampler;
import com.datadog.android.core.sampling.Sampler;
import com.datadog.android.log.internal.LogsFeature;
import com.datadog.android.log.internal.domain.LogGenerator;
import com.datadog.android.log.internal.logger.DatadogLogHandler;
import com.datadog.android.log.internal.logger.LogHandler;
import com.datadog.android.log.model.LogEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\b\u0000\u0018\u0000 ;2\u00020\u0001:\u0001;Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014Jt\u0010%\u001a\u0004\u0018\u00010\n2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00032\b\u0010*\u001a\u0004\u0018\u00010\u00032\b\u0010+\u001a\u0004\u0018\u00010\u00032\b\u0010,\u001a\u0004\u0018\u00010\u00032\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010/0.2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0003012\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u000204H\u0002J`\u0010%\u001a\u0004\u0018\u00010\n2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00032\b\u00105\u001a\u0004\u0018\u0001062\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010/0.2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0003012\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u000204H\u0002Ji\u00107\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00032\b\u0010*\u001a\u0004\u0018\u00010\u00032\b\u0010+\u001a\u0004\u0018\u00010\u00032\b\u00108\u001a\u0004\u0018\u00010\u00032\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010/0.2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0003012\b\u00103\u001a\u0004\u0018\u000104H\u0016\u00a2\u0006\u0002\u00109JU\u00107\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00032\b\u00105\u001a\u0004\u0018\u0001062\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010/0.2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0003012\b\u00103\u001a\u0004\u0018\u000104H\u0016\u00a2\u0006\u0002\u0010:R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u000e\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0014\u0010\r\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006<"}, d2={"Lcom/datadog/android/log/internal/logger/DatadogLogHandler;", "Lcom/datadog/android/log/internal/logger/LogHandler;", "loggerName", "", "logGenerator", "Lcom/datadog/android/log/internal/domain/LogGenerator;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "writer", "Lcom/datadog/android/api/storage/DataWriter;", "Lcom/datadog/android/log/model/LogEvent;", "attachNetworkInfo", "", "bundleWithTraces", "bundleWithRum", "sampler", "Lcom/datadog/android/core/sampling/Sampler;", "", "minLogPriority", "", "(Ljava/lang/String;Lcom/datadog/android/log/internal/domain/LogGenerator;Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/android/api/storage/DataWriter;ZZZLcom/datadog/android/core/sampling/Sampler;I)V", "getAttachNetworkInfo$dd_sdk_android_logs_release", "()Z", "getBundleWithRum$dd_sdk_android_logs_release", "getBundleWithTraces$dd_sdk_android_logs_release", "getLogGenerator$dd_sdk_android_logs_release", "()Lcom/datadog/android/log/internal/domain/LogGenerator;", "getLoggerName$dd_sdk_android_logs_release", "()Ljava/lang/String;", "getMinLogPriority$dd_sdk_android_logs_release", "()I", "getSampler$dd_sdk_android_logs_release", "()Lcom/datadog/android/core/sampling/Sampler;", "getSdkCore$dd_sdk_android_logs_release", "()Lcom/datadog/android/api/feature/FeatureSdkCore;", "getWriter$dd_sdk_android_logs_release", "()Lcom/datadog/android/api/storage/DataWriter;", "createLog", "level", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "message", "errorKind", "errorMessage", "errorStack", "attributes", "", "", "tags", "", "threadName", "timestamp", "", "throwable", "", "handleLog", "errorStacktrace", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Set;Ljava/lang/Long;)V", "(ILjava/lang/String;Ljava/lang/Throwable;Ljava/util/Map;Ljava/util/Set;Ljava/lang/Long;)V", "Companion", "dd-sdk-android-logs_release"})
public final class DatadogLogHandler
implements LogHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String loggerName;
    @NotNull
    private final LogGenerator logGenerator;
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final DataWriter<LogEvent> writer;
    private final boolean attachNetworkInfo;
    private final boolean bundleWithTraces;
    private final boolean bundleWithRum;
    @NotNull
    private final Sampler<Unit> sampler;
    private final int minLogPriority;
    @Deprecated
    public static final float DEFAULT_SAMPLE_RATE = 100.0f;
    @Deprecated
    @NotNull
    public static final String LOGS_FEATURE_NOT_REGISTERED = "Requested to write log, but Logs feature is not registered.";
    @Deprecated
    @NotNull
    public static final String RUM_FEATURE_NOT_REGISTERED = "Requested to forward error log to RUM, but RUM feature is not registered.";

    public DatadogLogHandler(@NotNull String loggerName, @NotNull LogGenerator logGenerator, @NotNull FeatureSdkCore sdkCore, @NotNull DataWriter<LogEvent> writer, boolean attachNetworkInfo, boolean bundleWithTraces, boolean bundleWithRum, @NotNull Sampler<Unit> sampler, int minLogPriority) {
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        Intrinsics.checkNotNullParameter((Object)logGenerator, (String)"logGenerator");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        Intrinsics.checkNotNullParameter(sampler, (String)"sampler");
        this.loggerName = loggerName;
        this.logGenerator = logGenerator;
        this.sdkCore = sdkCore;
        this.writer = writer;
        this.attachNetworkInfo = attachNetworkInfo;
        this.bundleWithTraces = bundleWithTraces;
        this.bundleWithRum = bundleWithRum;
        this.sampler = sampler;
        this.minLogPriority = minLogPriority;
    }

    public /* synthetic */ DatadogLogHandler(String string, LogGenerator logGenerator, FeatureSdkCore featureSdkCore, DataWriter dataWriter, boolean bl, boolean bl2, boolean bl3, Sampler sampler, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x40) != 0) {
            bl3 = true;
        }
        if ((n2 & 0x80) != 0) {
            sampler = (Sampler)new RateBasedSampler(100.0f);
        }
        if ((n2 & 0x100) != 0) {
            n = -1;
        }
        this(string, logGenerator, featureSdkCore, (DataWriter<LogEvent>)dataWriter, bl, bl2, bl3, (Sampler<Unit>)sampler, n);
    }

    @NotNull
    public final String getLoggerName$dd_sdk_android_logs_release() {
        return this.loggerName;
    }

    @NotNull
    public final LogGenerator getLogGenerator$dd_sdk_android_logs_release() {
        return this.logGenerator;
    }

    @NotNull
    public final FeatureSdkCore getSdkCore$dd_sdk_android_logs_release() {
        return this.sdkCore;
    }

    @NotNull
    public final DataWriter<LogEvent> getWriter$dd_sdk_android_logs_release() {
        return this.writer;
    }

    public final boolean getAttachNetworkInfo$dd_sdk_android_logs_release() {
        return this.attachNetworkInfo;
    }

    public final boolean getBundleWithTraces$dd_sdk_android_logs_release() {
        return this.bundleWithTraces;
    }

    public final boolean getBundleWithRum$dd_sdk_android_logs_release() {
        return this.bundleWithRum;
    }

    @NotNull
    public final Sampler<Unit> getSampler$dd_sdk_android_logs_release() {
        return this.sampler;
    }

    public final int getMinLogPriority$dd_sdk_android_logs_release() {
        return this.minLogPriority;
    }

    @Override
    public void handleLog(int level, @NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes, @NotNull Set<String> tags, @Nullable Long timestamp) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        if (level < this.minLogPriority) {
            return;
        }
        Long l = timestamp;
        long resolvedTimeStamp = l != null ? l : System.currentTimeMillis();
        Map combinedAttributes = new LinkedHashMap();
        FeatureScope logsFeature = this.sdkCore.getFeature("logs");
        if (logsFeature != null) {
            combinedAttributes.putAll(MapsKt.toMutableMap(((LogsFeature)logsFeature.unwrap()).getAttributes$dd_sdk_android_logs_release()));
        }
        combinedAttributes.putAll(attributes);
        if (this.sampler.sample((Object)Unit.INSTANCE)) {
            if (logsFeature != null) {
                String threadName = Thread.currentThread().getName();
                FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)logsFeature, (boolean)false, (Function2)((Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, level, message, throwable, (Map<String, Object>)combinedAttributes, tags, threadName, resolvedTimeStamp){
                    final /* synthetic */ DatadogLogHandler this$0;
                    final /* synthetic */ int $level;
                    final /* synthetic */ String $message;
                    final /* synthetic */ Throwable $throwable;
                    final /* synthetic */ Map<String, Object> $combinedAttributes;
                    final /* synthetic */ Set<String> $tags;
                    final /* synthetic */ String $threadName;
                    final /* synthetic */ long $resolvedTimeStamp;
                    {
                        this.this$0 = $receiver;
                        this.$level = $level;
                        this.$message = $message;
                        this.$throwable = $throwable;
                        this.$combinedAttributes = $combinedAttributes;
                        this.$tags = $tags;
                        this.$threadName = $threadName;
                        this.$resolvedTimeStamp = $resolvedTimeStamp;
                        super(2);
                    }

                    public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                        Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                        String string = this.$threadName;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"threadName");
                        LogEvent log = DatadogLogHandler.access$createLog(this.this$0, this.$level, datadogContext, this.$message, this.$throwable, this.$combinedAttributes, this.$tags, string, this.$resolvedTimeStamp);
                        if (log != null) {
                            this.this$0.getWriter$dd_sdk_android_logs_release().write(eventBatchWriter, (Object)log, EventType.DEFAULT);
                        }
                    }
                }), (int)1, null);
            } else {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)handleLog.2.INSTANCE, null, (boolean)false, null, (int)56, null);
            }
        }
        if (level >= 6) {
            FeatureScope rumFeature = this.sdkCore.getFeature("rum");
            if (rumFeature != null) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"logger_error"), TuplesKt.to((Object)"message", (Object)message), TuplesKt.to((Object)"throwable", (Object)throwable), TuplesKt.to((Object)"attributes", (Object)combinedAttributes)};
                rumFeature.sendEvent((Object)MapsKt.mapOf((Pair[])pairArray));
            } else {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)handleLog.3.INSTANCE, null, (boolean)false, null, (int)56, null);
            }
        }
    }

    @Override
    public void handleLog(int level, @NotNull String message, @Nullable String errorKind, @Nullable String errorMessage, @Nullable String errorStacktrace, @NotNull Map<String, ? extends Object> attributes, @NotNull Set<String> tags, @Nullable Long timestamp) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        if (level < this.minLogPriority) {
            return;
        }
        Long l = timestamp;
        long resolvedTimeStamp = l != null ? l : System.currentTimeMillis();
        Map combinedAttributes = new LinkedHashMap();
        FeatureScope logsFeature = this.sdkCore.getFeature("logs");
        if (logsFeature != null) {
            combinedAttributes.putAll(MapsKt.toMutableMap(((LogsFeature)logsFeature.unwrap()).getAttributes$dd_sdk_android_logs_release()));
        }
        combinedAttributes.putAll(attributes);
        if (this.sampler.sample((Object)Unit.INSTANCE)) {
            if (logsFeature != null) {
                String threadName = Thread.currentThread().getName();
                FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)logsFeature, (boolean)false, (Function2)((Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, level, message, errorKind, errorMessage, errorStacktrace, (Map<String, Object>)combinedAttributes, tags, threadName, resolvedTimeStamp){
                    final /* synthetic */ DatadogLogHandler this$0;
                    final /* synthetic */ int $level;
                    final /* synthetic */ String $message;
                    final /* synthetic */ String $errorKind;
                    final /* synthetic */ String $errorMessage;
                    final /* synthetic */ String $errorStacktrace;
                    final /* synthetic */ Map<String, Object> $combinedAttributes;
                    final /* synthetic */ Set<String> $tags;
                    final /* synthetic */ String $threadName;
                    final /* synthetic */ long $resolvedTimeStamp;
                    {
                        this.this$0 = $receiver;
                        this.$level = $level;
                        this.$message = $message;
                        this.$errorKind = $errorKind;
                        this.$errorMessage = $errorMessage;
                        this.$errorStacktrace = $errorStacktrace;
                        this.$combinedAttributes = $combinedAttributes;
                        this.$tags = $tags;
                        this.$threadName = $threadName;
                        this.$resolvedTimeStamp = $resolvedTimeStamp;
                        super(2);
                    }

                    public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                        Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                        String string = this.$threadName;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"threadName");
                        LogEvent log = DatadogLogHandler.access$createLog(this.this$0, this.$level, datadogContext, this.$message, this.$errorKind, this.$errorMessage, this.$errorStacktrace, this.$combinedAttributes, this.$tags, string, this.$resolvedTimeStamp);
                        if (log != null) {
                            this.this$0.getWriter$dd_sdk_android_logs_release().write(eventBatchWriter, (Object)log, EventType.DEFAULT);
                        }
                    }
                }), (int)1, null);
            } else {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)handleLog.5.INSTANCE, null, (boolean)false, null, (int)56, null);
            }
        }
        if (level >= 6) {
            FeatureScope rumFeature = this.sdkCore.getFeature("rum");
            if (rumFeature != null) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"type", (Object)"logger_error_with_stacktrace"), TuplesKt.to((Object)"message", (Object)message), TuplesKt.to((Object)"stacktrace", (Object)errorStacktrace), TuplesKt.to((Object)"attributes", (Object)combinedAttributes)};
                rumFeature.sendEvent((Object)MapsKt.mapOf((Pair[])pairArray));
            } else {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)handleLog.6.INSTANCE, null, (boolean)false, null, (int)56, null);
            }
        }
    }

    private final LogEvent createLog(int level, DatadogContext datadogContext, String message, Throwable throwable, Map<String, ? extends Object> attributes, Set<String> tags, String threadName, long timestamp) {
        LogGenerator logGenerator = this.logGenerator;
        boolean bl = this.attachNetworkInfo;
        String string = this.loggerName;
        boolean bl2 = this.bundleWithRum;
        boolean bl3 = this.bundleWithTraces;
        return LogGenerator.DefaultImpls.generateLog$default(logGenerator, level, message, throwable, attributes, tags, timestamp, threadName, datadogContext, bl, string, bl3, bl2, null, null, null, 28672, null);
    }

    private final LogEvent createLog(int level, DatadogContext datadogContext, String message, String errorKind, String errorMessage, String errorStack, Map<String, ? extends Object> attributes, Set<String> tags, String threadName, long timestamp) {
        LogGenerator logGenerator = this.logGenerator;
        boolean bl = this.attachNetworkInfo;
        String string = this.loggerName;
        boolean bl2 = this.bundleWithRum;
        boolean bl3 = this.bundleWithTraces;
        return LogGenerator.DefaultImpls.generateLog$default(logGenerator, level, message, errorKind, errorMessage, errorStack, attributes, tags, timestamp, threadName, datadogContext, bl, string, bl3, bl2, null, null, 49152, null);
    }

    public static final /* synthetic */ LogEvent access$createLog(DatadogLogHandler $this, int level, DatadogContext datadogContext, String message, Throwable throwable, Map attributes, Set tags, String threadName, long timestamp) {
        return $this.createLog(level, datadogContext, message, throwable, attributes, tags, threadName, timestamp);
    }

    public static final /* synthetic */ LogEvent access$createLog(DatadogLogHandler $this, int level, DatadogContext datadogContext, String message, String errorKind, String errorMessage, String errorStack, Map attributes, Set tags, String threadName, long timestamp) {
        return $this.createLog(level, datadogContext, message, errorKind, errorMessage, errorStack, attributes, tags, threadName, timestamp);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/log/internal/logger/DatadogLogHandler$Companion;", "", "()V", "DEFAULT_SAMPLE_RATE", "", "LOGS_FEATURE_NOT_REGISTERED", "", "RUM_FEATURE_NOT_REGISTERED", "dd-sdk-android-logs_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

