/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.datadog.android.Datadog;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.api.feature.Feature;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.core.InternalSdkCore;
import com.datadog.android.core.internal.net.FirstPartyHostHeaderTypeResolver;
import com.datadog.android.core.sampling.RateBasedSampler;
import com.datadog.android.core.sampling.Sampler;
import com.datadog.android.rum.GlobalRumMonitor;
import com.datadog.android.rum.Rum;
import com.datadog.android.rum.RumConfiguration;
import com.datadog.android.rum.RumSessionListener;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.metric.SessionEndedMetricDispatcher;
import com.datadog.android.rum.internal.monitor.DatadogRumMonitor;
import com.datadog.android.rum.internal.vitals.VitalMonitor;
import com.datadog.android.rum.metric.interactiontonextview.LastInteractionIdentifier;
import com.datadog.android.rum.metric.networksettled.InitialResourceIdentifier;
import com.datadog.android.telemetry.internal.TelemetryEventHandler;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\t\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/datadog/android/rum/Rum;", "", "()V", "INVALID_APPLICATION_ID_ERROR_MESSAGE", "", "RUM_FEATURE_ALREADY_ENABLED", "UNEXPECTED_SDK_CORE_TYPE", "createMonitor", "Lcom/datadog/android/rum/internal/monitor/DatadogRumMonitor;", "sdkCore", "Lcom/datadog/android/core/InternalSdkCore;", "rumFeature", "Lcom/datadog/android/rum/internal/RumFeature;", "enable", "", "rumConfiguration", "Lcom/datadog/android/rum/RumConfiguration;", "Lcom/datadog/android/api/SdkCore;", "dd-sdk-android-rum_release"})
public final class Rum {
    @NotNull
    public static final Rum INSTANCE = new Rum();
    @NotNull
    public static final String UNEXPECTED_SDK_CORE_TYPE = "SDK instance provided doesn't implement InternalSdkCore.";
    @NotNull
    public static final String INVALID_APPLICATION_ID_ERROR_MESSAGE = "You're trying to create a RumMonitor instance, but the RUM application id was empty. No RUM data will be sent.";
    @NotNull
    public static final String RUM_FEATURE_ALREADY_ENABLED = "RUM Feature is already enabled in this SDK core, ignoring the call to enable it.";

    private Rum() {
    }

    @JvmStatic
    @JvmOverloads
    public static final void enable(@NotNull RumConfiguration rumConfiguration, @NotNull SdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)rumConfiguration, (String)"rumConfiguration");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        if (!(sdkCore instanceof InternalSdkCore)) {
            FeatureSdkCore featureSdkCore = sdkCore instanceof FeatureSdkCore ? (FeatureSdkCore)sdkCore : null;
            if (featureSdkCore == null || (featureSdkCore = featureSdkCore.getInternalLogger()) == null) {
                featureSdkCore = InternalLogger.Companion.getUNBOUND();
            }
            FeatureSdkCore logger = featureSdkCore;
            InternalLogger.DefaultImpls.log$default((InternalLogger)logger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)enable.1.INSTANCE, null, (boolean)false, null, (int)56, null);
            return;
        }
        if (StringsKt.isBlank((CharSequence)rumConfiguration.getApplicationId$dd_sdk_android_rum_release())) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)((InternalSdkCore)sdkCore).getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)enable.2.INSTANCE, null, (boolean)false, null, (int)56, null);
            return;
        }
        if (((InternalSdkCore)sdkCore).getFeature("rum") != null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)((InternalSdkCore)sdkCore).getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)enable.3.INSTANCE, null, (boolean)false, null, (int)56, null);
            return;
        }
        RumFeature rumFeature2 = new RumFeature((FeatureSdkCore)sdkCore, rumConfiguration.getApplicationId$dd_sdk_android_rum_release(), rumConfiguration.getFeatureConfiguration$dd_sdk_android_rum_release(), null, 8, null);
        ((InternalSdkCore)sdkCore).registerFeature((Feature)rumFeature2);
        DatadogRumMonitor rumMonitor2 = INSTANCE.createMonitor((InternalSdkCore)sdkCore, rumFeature2);
        if (Build.VERSION.SDK_INT >= 30) {
            rumFeature2.consumeLastFatalAnr$dd_sdk_android_rum_release(rumMonitor2.getExecutorService$dd_sdk_android_rum_release());
        }
        GlobalRumMonitor.INSTANCE.registerIfAbsent$dd_sdk_android_rum_release(rumMonitor2, sdkCore);
        rumMonitor2.start();
    }

    public static /* synthetic */ void enable$default(RumConfiguration rumConfiguration, SdkCore sdkCore, int n, Object object) {
        if ((n & 2) != 0) {
            sdkCore = Datadog.getInstance$default(null, (int)1, null);
        }
        Rum.enable(rumConfiguration, sdkCore);
    }

    private final DatadogRumMonitor createMonitor(InternalSdkCore sdkCore, RumFeature rumFeature2) {
        SessionEndedMetricDispatcher sessionEndedMetricDispatcher = new SessionEndedMetricDispatcher(sdkCore.getInternalLogger());
        String string = rumFeature2.getApplicationId$dd_sdk_android_rum_release();
        float f = rumFeature2.getSampleRate$dd_sdk_android_rum_release();
        DataWriter<Object> dataWriter = rumFeature2.getDataWriter$dd_sdk_android_rum_release();
        Handler handler = new Handler(Looper.getMainLooper());
        RateBasedSampler rateBasedSampler = new RateBasedSampler(rumFeature2.getTelemetrySampleRate$dd_sdk_android_rum_release());
        Object object = new RateBasedSampler(rumFeature2.getTelemetryConfigurationSampleRate$dd_sdk_android_rum_release());
        TelemetryEventHandler telemetryEventHandler = new TelemetryEventHandler(sdkCore, (Sampler)rateBasedSampler, (Sampler)object, sessionEndedMetricDispatcher, 0, 16, null);
        rateBasedSampler = sdkCore.getFirstPartyHostResolver();
        object = rumFeature2.getCpuVitalMonitor$dd_sdk_android_rum_release();
        VitalMonitor vitalMonitor = rumFeature2.getMemoryVitalMonitor$dd_sdk_android_rum_release();
        VitalMonitor vitalMonitor2 = rumFeature2.getFrameRateVitalMonitor$dd_sdk_android_rum_release();
        boolean bl = rumFeature2.getBackgroundEventTracking$dd_sdk_android_rum_release();
        boolean bl2 = rumFeature2.getTrackFrustrations$dd_sdk_android_rum_release();
        RumSessionListener rumSessionListener = rumFeature2.getSessionListener$dd_sdk_android_rum_release();
        ExecutorService executorService = sdkCore.createSingleThreadExecutorService("rum-pipeline");
        InitialResourceIdentifier initialResourceIdentifier = rumFeature2.getInitialResourceIdentifier$dd_sdk_android_rum_release();
        LastInteractionIdentifier lastInteractionIdentifier = rumFeature2.getLastInteractionIdentifier$dd_sdk_android_rum_release();
        return new DatadogRumMonitor(string, sdkCore, f, bl, bl2, dataWriter, handler, telemetryEventHandler, sessionEndedMetricDispatcher, (FirstPartyHostHeaderTypeResolver)rateBasedSampler, (VitalMonitor)object, vitalMonitor, vitalMonitor2, rumSessionListener, executorService, initialResourceIdentifier, lastInteractionIdentifier);
    }

    @JvmStatic
    @JvmOverloads
    public static final void enable(@NotNull RumConfiguration rumConfiguration) {
        Intrinsics.checkNotNullParameter((Object)rumConfiguration, (String)"rumConfiguration");
        Rum.enable$default(rumConfiguration, null, 2, null);
    }
}

