/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal;

import com.datadog.android.api.context.DatadogContext;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lcom/datadog/android/rum/internal/FeaturesContextResolver;", "", "()V", "resolveViewHasReplay", "", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "viewId", "", "resolveViewRecordsCount", "", "Companion", "dd-sdk-android-rum_release"})
public final class FeaturesContextResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String HAS_REPLAY_KEY = "has_replay";
    @NotNull
    public static final String VIEW_RECORDS_COUNT_KEY = "records_count";

    public final boolean resolveViewHasReplay(@NotNull DatadogContext datadogContext, @NotNull String viewId) {
        Map sessionReplayMetadata;
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        Map map = (Map)datadogContext.getFeaturesContext().get("session-replay");
        if (map == null) {
            return false;
        }
        Map sessionReplayContext = map;
        Object v = sessionReplayContext.get(viewId);
        Map map2 = sessionReplayMetadata = v instanceof Map ? (Map)v : null;
        Object v2 = map2 != null ? map2.get(HAS_REPLAY_KEY) : null;
        Boolean bl = v2 instanceof Boolean ? (Boolean)v2 : null;
        return bl != null ? bl : false;
    }

    public final long resolveViewRecordsCount(@NotNull DatadogContext datadogContext, @NotNull String viewId) {
        Map sessionReplayMetadata;
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        Map map = (Map)datadogContext.getFeaturesContext().get("session-replay");
        if (map == null) {
            return 0L;
        }
        Map sessionReplayContext = map;
        Object v = sessionReplayContext.get(viewId);
        Map map2 = sessionReplayMetadata = v instanceof Map ? (Map)v : null;
        Object v2 = map2 != null ? map2.get(VIEW_RECORDS_COUNT_KEY) : null;
        Long l = v2 instanceof Long ? (Long)v2 : null;
        return l != null ? l : 0L;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/rum/internal/FeaturesContextResolver$Companion;", "", "()V", "HAS_REPLAY_KEY", "", "VIEW_RECORDS_COUNT_KEY", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

