/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.event;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.persistence.Deserializer;
import com.datadog.android.rum.model.ActionEvent;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.LongTaskEvent;
import com.datadog.android.rum.model.ResourceEvent;
import com.datadog.android.rum.model.ViewEvent;
import com.datadog.android.telemetry.model.TelemetryDebugEvent;
import com.datadog.android.telemetry.model.TelemetryErrorEvent;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\fB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001a\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/datadog/android/rum/internal/domain/event/RumEventDeserializer;", "Lcom/datadog/android/core/internal/persistence/Deserializer;", "Lcom/google/gson/JsonObject;", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/InternalLogger;)V", "deserialize", "model", "parseEvent", "eventType", "", "Companion", "dd-sdk-android-rum_release"})
public final class RumEventDeserializer
implements Deserializer<JsonObject, Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String EVENT_TYPE_KEY_NAME = "type";
    @NotNull
    public static final String EVENT_TELEMETRY_KEY_NAME = "telemetry";
    @NotNull
    public static final String EVENT_TELEMETRY_STATUS_KEY_NAME = "status";
    @NotNull
    public static final String EVENT_TYPE_VIEW = "view";
    @NotNull
    public static final String EVENT_TYPE_RESOURCE = "resource";
    @NotNull
    public static final String EVENT_TYPE_ACTION = "action";
    @NotNull
    public static final String EVENT_TYPE_ERROR = "error";
    @NotNull
    public static final String EVENT_TYPE_LONG_TASK = "long_task";
    @NotNull
    public static final String EVENT_TYPE_TELEMETRY = "telemetry";
    @NotNull
    public static final String TELEMETRY_TYPE_DEBUG = "debug";
    @NotNull
    public static final String TELEMETRY_TYPE_ERROR = "error";
    @NotNull
    public static final String DESERIALIZE_ERROR_MESSAGE_FORMAT = "Error while trying to deserialize the RumEvent: %s";

    public RumEventDeserializer(@NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
    }

    @Nullable
    public Object deserialize(@NotNull JsonObject model) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        try {
            JsonPrimitive jsonPrimitive = model.getAsJsonPrimitive(EVENT_TYPE_KEY_NAME);
            object = this.parseEvent(jsonPrimitive != null ? jsonPrimitive.getAsString() : null, model);
        }
        catch (JsonParseException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)((Function0)new Function0<String>(model){
                final /* synthetic */ JsonObject $model;
                {
                    this.$model = $model;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Error while trying to deserialize the RumEvent: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$model};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }), (Throwable)e, (boolean)false, null, (int)48, null);
            object = null;
        }
        catch (IllegalStateException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)((Function0)new Function0<String>(model){
                final /* synthetic */ JsonObject $model;
                {
                    this.$model = $model;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Error while trying to deserialize the RumEvent: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$model};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }), (Throwable)e, (boolean)false, null, (int)48, null);
            object = null;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object parseEvent(String eventType, JsonObject model) throws JsonParseException {
        String string = eventType;
        if (string == null) throw new JsonParseException("We could not deserialize the event with type: " + eventType);
        int n = -1;
        switch (string.hashCode()) {
            case 3619493: {
                if (string.equals(EVENT_TYPE_VIEW)) {
                    n = 1;
                }
                break;
            }
            case -341064690: {
                if (string.equals(EVENT_TYPE_RESOURCE)) {
                    n = 2;
                }
                break;
            }
            case -1422950858: {
                if (string.equals(EVENT_TYPE_ACTION)) {
                    n = 3;
                }
                break;
            }
            case 128111976: {
                if (string.equals(EVENT_TYPE_LONG_TASK)) {
                    n = 4;
                }
                break;
            }
            case 780346297: {
                if (string.equals("telemetry")) {
                    n = 5;
                }
                break;
            }
            case 96784904: {
                if (string.equals("error")) {
                    n = 6;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                Object object = ViewEvent.Companion.fromJsonObject(model);
                return object;
            }
            case 2: {
                Object object = ResourceEvent.Companion.fromJsonObject(model);
                return object;
            }
            case 3: {
                Object object = ActionEvent.Companion.fromJsonObject(model);
                return object;
            }
            case 6: {
                Object object = ErrorEvent.Companion.fromJsonObject(model);
                return object;
            }
            case 4: {
                Object object = LongTaskEvent.Companion.fromJsonObject(model);
                return object;
            }
            case 5: {
                String status;
                Object object;
                String string2 = status = model.getAsJsonObject("telemetry").getAsJsonPrimitive(EVENT_TELEMETRY_STATUS_KEY_NAME).getAsString();
                if (Intrinsics.areEqual((Object)string2, (Object)TELEMETRY_TYPE_DEBUG)) {
                    object = TelemetryDebugEvent.Companion.fromJsonObject(model);
                    return object;
                }
                if (!Intrinsics.areEqual((Object)string2, (Object)"error")) throw new JsonParseException("We could not deserialize the telemetry event with status: " + status);
                object = TelemetryErrorEvent.Companion.fromJsonObject(model);
                return object;
            }
            default: {
                throw new JsonParseException("We could not deserialize the event with type: " + eventType);
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/datadog/android/rum/internal/domain/event/RumEventDeserializer$Companion;", "", "()V", "DESERIALIZE_ERROR_MESSAGE_FORMAT", "", "EVENT_TELEMETRY_KEY_NAME", "EVENT_TELEMETRY_STATUS_KEY_NAME", "EVENT_TYPE_ACTION", "EVENT_TYPE_ERROR", "EVENT_TYPE_KEY_NAME", "EVENT_TYPE_LONG_TASK", "EVENT_TYPE_RESOURCE", "EVENT_TYPE_TELEMETRY", "EVENT_TYPE_VIEW", "TELEMETRY_TYPE_DEBUG", "TELEMETRY_TYPE_ERROR", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

