/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.event;

import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.core.internal.persistence.Deserializer;
import com.datadog.android.rum.internal.domain.event.RumEventMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/rum/internal/domain/event/RumViewEventFilter;", "", "eventMetaDeserializer", "Lcom/datadog/android/core/internal/persistence/Deserializer;", "", "Lcom/datadog/android/rum/internal/domain/event/RumEventMeta;", "(Lcom/datadog/android/core/internal/persistence/Deserializer;)V", "filterOutRedundantViewEvents", "", "Lcom/datadog/android/api/storage/RawBatchEvent;", "batch", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nRumViewEventFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RumViewEventFilter.kt\ncom/datadog/android/rum/internal/domain/event/RumViewEventFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1855#2,2:51\n766#2:53\n857#2,2:54\n*S KotlinDebug\n*F\n+ 1 RumViewEventFilter.kt\ncom/datadog/android/rum/internal/domain/event/RumViewEventFilter\n*L\n21#1:51,2\n36#1:53\n36#1:54,2\n*E\n"})
public final class RumViewEventFilter {
    @NotNull
    private final Deserializer<byte[], RumEventMeta> eventMetaDeserializer;

    public RumViewEventFilter(@NotNull Deserializer<byte[], RumEventMeta> eventMetaDeserializer) {
        Intrinsics.checkNotNullParameter(eventMetaDeserializer, (String)"eventMetaDeserializer");
        this.eventMetaDeserializer = eventMetaDeserializer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RawBatchEvent> filterOutRedundantViewEvents(@NotNull List<RawBatchEvent> batch) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(batch, (String)"batch");
        Map maxDocVersionByViewId = new LinkedHashMap();
        Map viewMetaByEvent = new LinkedHashMap();
        Iterable $this$forEach$iv = batch;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Long l;
            RawBatchEvent it = (RawBatchEvent)element$iv;
            boolean bl = false;
            RumEventMeta eventMeta = (RumEventMeta)this.eventMetaDeserializer.deserialize((Object)it.getMetadata());
            if (!(eventMeta instanceof RumEventMeta.View)) continue;
            Map map = viewMetaByEvent;
            Pair pair = TuplesKt.to((Object)it, (Object)eventMeta);
            map.put(pair.getFirst(), pair.getSecond());
            String viewId = ((RumEventMeta.View)eventMeta).getViewId();
            long documentVersion = ((RumEventMeta.View)eventMeta).getDocumentVersion();
            Long maxDocVersionSeen = (Long)maxDocVersionByViewId.get(viewId);
            if (maxDocVersionSeen == null) {
                l = documentVersion;
                maxDocVersionByViewId.put(viewId, l);
                continue;
            }
            Map map2 = maxDocVersionByViewId;
            long l2 = maxDocVersionSeen;
            l = Math.max(documentVersion, l2);
            map2.put(viewId, l);
        }
        Iterable $this$filter$iv = batch;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RumEventMeta.View viewMeta;
            RawBatchEvent it = (RawBatchEvent)element$iv$iv;
            boolean bl = false;
            boolean bl2 = viewMetaByEvent.containsKey(it) ? (viewMeta = (RumEventMeta.View)MapsKt.getValue((Map)viewMetaByEvent, (Object)it)).getDocumentVersion() == ((Number)MapsKt.getValue((Map)maxDocVersionByViewId, (Object)viewMeta.getViewId())).longValue() : true;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

