/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.core.InternalSdkCore;
import com.datadog.android.core.internal.net.FirstPartyHostHeaderTypeResolver;
import com.datadog.android.rum.DdRumContentProvider;
import com.datadog.android.rum.RumSessionListener;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.Time;
import com.datadog.android.rum.internal.domain.scope.RumApplicationScope;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.internal.domain.scope.RumSessionScope;
import com.datadog.android.rum.internal.domain.scope.RumViewChangedListener;
import com.datadog.android.rum.internal.domain.scope.RumViewInfo;
import com.datadog.android.rum.internal.metric.SessionMetricDispatcher;
import com.datadog.android.rum.internal.vitals.VitalMonitor;
import com.datadog.android.rum.metric.interactiontonextview.LastInteractionIdentifier;
import com.datadog.android.rum.metric.networksettled.InitialResourceIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0001@Bo\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u001e\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0003J\b\u00107\u001a\u00020,H\u0016J\u001e\u00108\u001a\u00020\u00012\u0006\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0017J\b\u00109\u001a\u00020\nH\u0016J\u0010\u0010:\u001a\u0002012\u0006\u0010;\u001a\u00020(H\u0016J\u001e\u0010<\u001a\u0002012\u0006\u0010=\u001a\u00020>2\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0003J\u001e\u0010?\u001a\u0002012\u0006\u00102\u001a\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0003R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001f\u00a8\u0006A"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumApplicationScope;", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "Lcom/datadog/android/rum/internal/domain/scope/RumViewChangedListener;", "applicationId", "", "sdkCore", "Lcom/datadog/android/core/InternalSdkCore;", "sampleRate", "", "backgroundTrackingEnabled", "", "trackFrustrations", "firstPartyHostHeaderTypeResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "cpuVitalMonitor", "Lcom/datadog/android/rum/internal/vitals/VitalMonitor;", "memoryVitalMonitor", "frameRateVitalMonitor", "sessionEndedMetricDispatcher", "Lcom/datadog/android/rum/internal/metric/SessionMetricDispatcher;", "sessionListener", "Lcom/datadog/android/rum/RumSessionListener;", "initialResourceIdentifier", "Lcom/datadog/android/rum/metric/networksettled/InitialResourceIdentifier;", "lastInteractionIdentifier", "Lcom/datadog/android/rum/metric/interactiontonextview/LastInteractionIdentifier;", "(Ljava/lang/String;Lcom/datadog/android/core/InternalSdkCore;FZZLcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/vitals/VitalMonitor;Lcom/datadog/android/rum/internal/metric/SessionMetricDispatcher;Lcom/datadog/android/rum/RumSessionListener;Lcom/datadog/android/rum/metric/networksettled/InitialResourceIdentifier;Lcom/datadog/android/rum/metric/interactiontonextview/LastInteractionIdentifier;)V", "activeSession", "getActiveSession", "()Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "getBackgroundTrackingEnabled$dd_sdk_android_rum_release", "()Z", "childScopes", "", "getChildScopes$dd_sdk_android_rum_release", "()Ljava/util/List;", "getInitialResourceIdentifier$dd_sdk_android_rum_release", "()Lcom/datadog/android/rum/metric/networksettled/InitialResourceIdentifier;", "isAppStartedEventSent", "lastActiveViewInfo", "Lcom/datadog/android/rum/internal/domain/scope/RumViewInfo;", "getLastInteractionIdentifier$dd_sdk_android_rum_release", "()Lcom/datadog/android/rum/metric/interactiontonextview/LastInteractionIdentifier;", "rumContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "getSampleRate$dd_sdk_android_rum_release", "()F", "getTrackFrustrations$dd_sdk_android_rum_release", "delegateToChildren", "", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "writer", "Lcom/datadog/android/api/storage/DataWriter;", "", "getRumContext", "handleEvent", "isActive", "onViewChanged", "viewInfo", "sendApplicationStartEvent", "eventTime", "Lcom/datadog/android/rum/internal/domain/Time;", "startNewSession", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nRumApplicationScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RumApplicationScope.kt\ncom/datadog/android/rum/internal/domain/scope/RumApplicationScope\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,211:1\n1#2:212\n766#3:213\n857#3,2:214\n*S KotlinDebug\n*F\n+ 1 RumApplicationScope.kt\ncom/datadog/android/rum/internal/domain/scope/RumApplicationScope\n*L\n169#1:213\n169#1:214,2\n*E\n"})
public final class RumApplicationScope
implements RumScope,
RumViewChangedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalSdkCore sdkCore;
    private final float sampleRate;
    private final boolean backgroundTrackingEnabled;
    private final boolean trackFrustrations;
    @NotNull
    private final FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver;
    @NotNull
    private final VitalMonitor cpuVitalMonitor;
    @NotNull
    private final VitalMonitor memoryVitalMonitor;
    @NotNull
    private final VitalMonitor frameRateVitalMonitor;
    @NotNull
    private final SessionMetricDispatcher sessionEndedMetricDispatcher;
    @Nullable
    private final RumSessionListener sessionListener;
    @NotNull
    private final InitialResourceIdentifier initialResourceIdentifier;
    @NotNull
    private final LastInteractionIdentifier lastInteractionIdentifier;
    @NotNull
    private RumContext rumContext;
    @NotNull
    private final List<RumScope> childScopes;
    @Nullable
    private RumViewInfo lastActiveViewInfo;
    private boolean isAppStartedEventSent;
    @NotNull
    public static final String MULTIPLE_ACTIVE_SESSIONS_ERROR = "Application has multiple active sessions when starting a new session";

    public RumApplicationScope(@NotNull String applicationId, @NotNull InternalSdkCore sdkCore, float sampleRate, boolean backgroundTrackingEnabled, boolean trackFrustrations, @NotNull FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, @NotNull VitalMonitor cpuVitalMonitor, @NotNull VitalMonitor memoryVitalMonitor, @NotNull VitalMonitor frameRateVitalMonitor, @NotNull SessionMetricDispatcher sessionEndedMetricDispatcher, @Nullable RumSessionListener sessionListener, @NotNull InitialResourceIdentifier initialResourceIdentifier, @NotNull LastInteractionIdentifier lastInteractionIdentifier) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostHeaderTypeResolver, (String)"firstPartyHostHeaderTypeResolver");
        Intrinsics.checkNotNullParameter((Object)cpuVitalMonitor, (String)"cpuVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)memoryVitalMonitor, (String)"memoryVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)frameRateVitalMonitor, (String)"frameRateVitalMonitor");
        Intrinsics.checkNotNullParameter((Object)sessionEndedMetricDispatcher, (String)"sessionEndedMetricDispatcher");
        Intrinsics.checkNotNullParameter((Object)initialResourceIdentifier, (String)"initialResourceIdentifier");
        Intrinsics.checkNotNullParameter((Object)lastInteractionIdentifier, (String)"lastInteractionIdentifier");
        this.sdkCore = sdkCore;
        this.sampleRate = sampleRate;
        this.backgroundTrackingEnabled = backgroundTrackingEnabled;
        this.trackFrustrations = trackFrustrations;
        this.firstPartyHostHeaderTypeResolver = firstPartyHostHeaderTypeResolver;
        this.cpuVitalMonitor = cpuVitalMonitor;
        this.memoryVitalMonitor = memoryVitalMonitor;
        this.frameRateVitalMonitor = frameRateVitalMonitor;
        this.sessionEndedMetricDispatcher = sessionEndedMetricDispatcher;
        this.sessionListener = sessionListener;
        this.initialResourceIdentifier = initialResourceIdentifier;
        this.lastInteractionIdentifier = lastInteractionIdentifier;
        this.rumContext = new RumContext(applicationId, null, false, null, null, null, null, null, null, null, null, null, 0L, 0L, false, 32766, null);
        Object[] objectArray = new RumScope[]{new RumSessionScope(this, this.sdkCore, this.sessionEndedMetricDispatcher, this.sampleRate, this.backgroundTrackingEnabled, this.trackFrustrations, this, this.firstPartyHostHeaderTypeResolver, this.cpuVitalMonitor, this.memoryVitalMonitor, this.frameRateVitalMonitor, this.sessionListener, false, this.initialResourceIdentifier, this.lastInteractionIdentifier, 0L, 0L, 98304, null)};
        this.childScopes = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public final float getSampleRate$dd_sdk_android_rum_release() {
        return this.sampleRate;
    }

    public final boolean getBackgroundTrackingEnabled$dd_sdk_android_rum_release() {
        return this.backgroundTrackingEnabled;
    }

    public final boolean getTrackFrustrations$dd_sdk_android_rum_release() {
        return this.trackFrustrations;
    }

    @NotNull
    public final InitialResourceIdentifier getInitialResourceIdentifier$dd_sdk_android_rum_release() {
        return this.initialResourceIdentifier;
    }

    @NotNull
    public final LastInteractionIdentifier getLastInteractionIdentifier$dd_sdk_android_rum_release() {
        return this.lastInteractionIdentifier;
    }

    @NotNull
    public final List<RumScope> getChildScopes$dd_sdk_android_rum_release() {
        return this.childScopes;
    }

    @Nullable
    public final RumScope getActiveSession() {
        Object v0;
        block1: {
            Iterable iterable = this.childScopes;
            for (Object t : iterable) {
                RumScope it = (RumScope)t;
                boolean bl = false;
                if (!it.isActive()) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @WorkerThread
    @NotNull
    public RumScope handleEvent(@NotNull RumRawEvent event, @NotNull DataWriter<Object> writer) {
        boolean isInteraction;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        if (event instanceof RumRawEvent.SetSyntheticsTestAttribute) {
            this.rumContext = RumContext.copy$default(this.rumContext, null, null, false, null, null, null, null, null, null, null, ((RumRawEvent.SetSyntheticsTestAttribute)event).getTestId(), ((RumRawEvent.SetSyntheticsTestAttribute)event).getResultId(), 0L, 0L, false, 29695, null);
        }
        boolean bl = isInteraction = event instanceof RumRawEvent.StartView || event instanceof RumRawEvent.StartAction;
        if (this.getActiveSession() == null && isInteraction) {
            this.startNewSession(event, writer);
        } else if (event instanceof RumRawEvent.StopSession) {
            this.sdkCore.updateFeatureContext("rum", (Function1)new Function1<Map<String, Object>, Unit>(this){
                final /* synthetic */ RumApplicationScope this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Map<String, Object> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    it.putAll(this.this$0.getRumContext().toMap());
                }
            });
        }
        if (!(event instanceof RumRawEvent.SdkInit) && !this.isAppStartedEventSent) {
            this.sendApplicationStartEvent(event.getEventTime(), writer);
        }
        this.delegateToChildren(event, writer);
        return this;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    @NotNull
    public RumContext getRumContext() {
        return this.rumContext;
    }

    @Override
    public void onViewChanged(@NotNull RumViewInfo viewInfo) {
        Intrinsics.checkNotNullParameter((Object)viewInfo, (String)"viewInfo");
        if (viewInfo.isActive()) {
            this.lastActiveViewInfo = viewInfo;
        }
    }

    @WorkerThread
    private final void delegateToChildren(RumRawEvent event, DataWriter<Object> writer) {
        Iterator<RumScope> iterator = this.childScopes.iterator();
        while (iterator.hasNext()) {
            RumScope result = iterator.next().handleEvent(event, writer);
            if (result != null) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private final void startNewSession(RumRawEvent event, DataWriter<Object> writer) {
        void $this$filterTo$iv$iv;
        Object it;
        RumSessionScope newSession = new RumSessionScope(this, this.sdkCore, this.sessionEndedMetricDispatcher, this.sampleRate, this.backgroundTrackingEnabled, this.trackFrustrations, this, this.firstPartyHostHeaderTypeResolver, this.cpuVitalMonitor, this.memoryVitalMonitor, this.frameRateVitalMonitor, this.sessionListener, true, this.initialResourceIdentifier, this.lastInteractionIdentifier, 0L, 0L, 98304, null);
        this.childScopes.add(newSession);
        if (!(event instanceof RumRawEvent.StartView)) {
            RumViewInfo rumViewInfo = this.lastActiveViewInfo;
            if (rumViewInfo != null) {
                it = rumViewInfo;
                boolean bl = false;
                RumRawEvent.StartView startViewEvent = new RumRawEvent.StartView(((RumViewInfo)it).getKey(), ((RumViewInfo)it).getAttributes(), null, 4, null);
                newSession.handleEvent(startViewEvent, writer);
            }
        }
        Iterable $this$filter$iv = this.childScopes;
        boolean $i$f$filter = false;
        it = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RumScope it2 = (RumScope)element$iv$iv;
            boolean bl = false;
            if (!it2.isActive()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        if (((List)destination$iv$iv).size() > 1) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.TELEMETRY, (Function0)startNewSession.3.INSTANCE, null, (boolean)false, null, (int)56, null);
        }
    }

    @WorkerThread
    private final void sendApplicationStartEvent(Time eventTime, DataWriter<Object> writer) {
        boolean isForegroundProcess;
        int processImportance = DdRumContentProvider.Companion.getProcessImportance$dd_sdk_android_rum_release();
        boolean bl = isForegroundProcess = processImportance == 100;
        if (isForegroundProcess) {
            long processStartTimeNs = this.sdkCore.getAppStartTimeNs();
            long timestampNs = TimeUnit.MILLISECONDS.toNanos(eventTime.getTimestamp()) - eventTime.getNanoTime() + processStartTimeNs;
            Time applicationLaunchViewTime = new Time(TimeUnit.NANOSECONDS.toMillis(timestampNs), processStartTimeNs);
            long startupTime = eventTime.getNanoTime() - processStartTimeNs;
            RumRawEvent.ApplicationStarted appStartedEvent = new RumRawEvent.ApplicationStarted(applicationLaunchViewTime, startupTime);
            this.delegateToChildren(appStartedEvent, writer);
            this.isAppStartedEventSent = true;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumApplicationScope$Companion;", "", "()V", "MULTIPLE_ACTIVE_SESSIONS_ERROR", "", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

