/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.instrumentation;

import android.content.Context;
import android.os.Looper;
import android.util.Printer;
import com.datadog.android.api.SdkCore;
import com.datadog.android.rum.GlobalRumMonitor;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.tracking.TrackingStrategy;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0016J\u0012\u0010\u001d\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/MainLooperLongTaskStrategy;", "Landroid/util/Printer;", "Lcom/datadog/android/rum/tracking/TrackingStrategy;", "thresholdMs", "", "(J)V", "sdkCore", "Lcom/datadog/android/api/SdkCore;", "startUptimeNs", "target", "", "getThresholdMs$dd_sdk_android_rum_release", "()J", "thresholdNS", "detectLongTask", "", "message", "equals", "", "other", "", "hashCode", "", "println", "x", "register", "context", "Landroid/content/Context;", "toString", "unregister", "Companion", "dd-sdk-android-rum_release"})
public final class MainLooperLongTaskStrategy
implements Printer,
TrackingStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long thresholdMs;
    private final long thresholdNS;
    private long startUptimeNs;
    @NotNull
    private String target;
    private SdkCore sdkCore;
    @NotNull
    private static final String PREFIX_START = ">>>>> Dispatching to ";
    @NotNull
    private static final String PREFIX_END = "<<<<< Finished to ";
    private static final int PREFIX_START_LENGTH = 21;

    public MainLooperLongTaskStrategy(long thresholdMs) {
        this.thresholdMs = thresholdMs;
        this.thresholdNS = TimeUnit.MILLISECONDS.toNanos(this.thresholdMs);
        this.target = "";
    }

    public final long getThresholdMs$dd_sdk_android_rum_release() {
        return this.thresholdMs;
    }

    @Override
    public void register(@NotNull SdkCore sdkCore, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.sdkCore = sdkCore;
        Looper.getMainLooper().setMessageLogging((Printer)this);
    }

    @Override
    public void unregister(@Nullable Context context) {
        Looper.getMainLooper().setMessageLogging(null);
    }

    public void println(@Nullable String x) {
        if (x != null) {
            this.detectLongTask(x);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.datadog.android.rum.internal.instrumentation.MainLooperLongTaskStrategy");
        MainLooperLongTaskStrategy cfr_ignored_0 = (MainLooperLongTaskStrategy)other;
        return this.thresholdMs == ((MainLooperLongTaskStrategy)other).thresholdMs;
    }

    public int hashCode() {
        return Long.hashCode(this.thresholdMs);
    }

    @NotNull
    public String toString() {
        return "MainLooperLongTaskStrategy(" + this.thresholdMs + ")";
    }

    private final void detectLongTask(String message2) {
        block3: {
            RumMonitor rumMonitor2;
            long durationNs;
            long now;
            block2: {
                now = System.nanoTime();
                if (!StringsKt.startsWith$default((String)message2, (String)PREFIX_START, (boolean)false, (int)2, null)) break block2;
                String string = message2.substring(21);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.target = string;
                this.startUptimeNs = now;
                break block3;
            }
            if (!StringsKt.startsWith$default((String)message2, (String)PREFIX_END, (boolean)false, (int)2, null) || (durationNs = now - this.startUptimeNs) <= this.thresholdNS || this.sdkCore == null) break block3;
            SdkCore sdkCore = this.sdkCore;
            if (sdkCore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sdkCore");
                sdkCore = null;
            }
            AdvancedRumMonitor advancedRumMonitor = (rumMonitor2 = GlobalRumMonitor.get(sdkCore)) instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)rumMonitor2 : null;
            if (advancedRumMonitor != null) {
                advancedRumMonitor.addLongTask(durationNs, this.target);
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/MainLooperLongTaskStrategy$Companion;", "", "()V", "PREFIX_END", "", "PREFIX_START", "PREFIX_START_LENGTH", "", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

