/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.instrumentation.gestures;

import android.content.Context;
import android.view.Window;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesDetectorWrapper;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesListener;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesTracker;
import com.datadog.android.rum.internal.instrumentation.gestures.NoOpWindowCallback;
import com.datadog.android.rum.internal.instrumentation.gestures.WindowCallbackWrapper;
import com.datadog.android.rum.tracking.InteractionPredicate;
import com.datadog.android.rum.tracking.ViewAttributesProvider;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J%\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010 \u001a\u00020\u001f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lcom/datadog/android/rum/internal/instrumentation/gestures/DatadogGesturesTracker;", "Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesTracker;", "targetAttributesProviders", "", "Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "interactionPredicate", "Lcom/datadog/android/rum/tracking/InteractionPredicate;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "([Lcom/datadog/android/rum/tracking/ViewAttributesProvider;Lcom/datadog/android/rum/tracking/InteractionPredicate;Lcom/datadog/android/api/InternalLogger;)V", "getInteractionPredicate$dd_sdk_android_rum_release", "()Lcom/datadog/android/rum/tracking/InteractionPredicate;", "getTargetAttributesProviders$dd_sdk_android_rum_release", "()[Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "[Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "equals", "", "other", "", "generateGestureDetector", "Lcom/datadog/android/rum/internal/instrumentation/gestures/GesturesDetectorWrapper;", "context", "Landroid/content/Context;", "window", "Landroid/view/Window;", "sdkCore", "Lcom/datadog/android/api/SdkCore;", "generateGestureDetector$dd_sdk_android_rum_release", "hashCode", "", "startTracking", "", "stopTracking", "toString", "", "dd-sdk-android-rum_release"})
public final class DatadogGesturesTracker
implements GesturesTracker {
    @NotNull
    private final ViewAttributesProvider[] targetAttributesProviders;
    @NotNull
    private final InteractionPredicate interactionPredicate;
    @NotNull
    private final InternalLogger internalLogger;

    public DatadogGesturesTracker(@NotNull ViewAttributesProvider[] targetAttributesProviders, @NotNull InteractionPredicate interactionPredicate, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)targetAttributesProviders, (String)"targetAttributesProviders");
        Intrinsics.checkNotNullParameter((Object)interactionPredicate, (String)"interactionPredicate");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.targetAttributesProviders = targetAttributesProviders;
        this.interactionPredicate = interactionPredicate;
        this.internalLogger = internalLogger;
    }

    @NotNull
    public final ViewAttributesProvider[] getTargetAttributesProviders$dd_sdk_android_rum_release() {
        return this.targetAttributesProviders;
    }

    @NotNull
    public final InteractionPredicate getInteractionPredicate$dd_sdk_android_rum_release() {
        return this.interactionPredicate;
    }

    @Override
    public void startTracking(@Nullable Window window, @NotNull Context context, @NotNull SdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        if (window == null) {
            return;
        }
        Window.Callback callback = window.getCallback();
        if (callback == null) {
            callback = new NoOpWindowCallback();
        }
        Window.Callback toWrap = callback;
        GesturesDetectorWrapper gesturesDetector = this.generateGestureDetector$dd_sdk_android_rum_release(context, window, sdkCore);
        window.setCallback((Window.Callback)new WindowCallbackWrapper(window, sdkCore, toWrap, gesturesDetector, this.interactionPredicate, null, this.targetAttributesProviders, this.internalLogger, 32, null));
    }

    @Override
    public void stopTracking(@Nullable Window window, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (window == null) {
            return;
        }
        Window.Callback currentCallback = window.getCallback();
        if (currentCallback instanceof WindowCallbackWrapper) {
            if (!(((WindowCallbackWrapper)currentCallback).getWrappedCallback() instanceof NoOpWindowCallback)) {
                window.setCallback(((WindowCallbackWrapper)currentCallback).getWrappedCallback());
            } else {
                window.setCallback(null);
            }
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.datadog.android.rum.internal.instrumentation.gestures.DatadogGesturesTracker");
        DatadogGesturesTracker cfr_ignored_0 = (DatadogGesturesTracker)other;
        if (!Arrays.equals(this.targetAttributesProviders, ((DatadogGesturesTracker)other).targetAttributesProviders)) {
            return false;
        }
        return Intrinsics.areEqual(this.interactionPredicate.getClass(), ((DatadogGesturesTracker)other).interactionPredicate.getClass());
    }

    public int hashCode() {
        int result = 17;
        int multiplier = 31;
        result += result * multiplier + Arrays.hashCode(this.targetAttributesProviders);
        result += result * multiplier + this.interactionPredicate.getClass().hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "DatadogGesturesTracker(" + ArraysKt.joinToString$default((Object[])this.targetAttributesProviders, null, null, null, (int)0, null, null, (int)63, null) + ")";
    }

    @NotNull
    public final GesturesDetectorWrapper generateGestureDetector$dd_sdk_android_rum_release(@NotNull Context context, @NotNull Window window, @NotNull SdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        return new GesturesDetectorWrapper(context, new GesturesListener(sdkCore, new WeakReference<Window>(window), this.targetAttributesProviders, this.interactionPredicate, (Reference<Context>)new WeakReference<Context>(context), this.internalLogger));
    }
}

