/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.metric;

import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumSessionScope;
import com.datadog.android.rum.model.ViewEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\f\b\u0000\u0018\u0000 .2\u00020\u0001:\u0003./0B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0017\u001a\u00020\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0012J\u0006\u0010\u001f\u001a\u00020\u001bJ\u0006\u0010 \u001a\u00020\u001bJ\u000e\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#J\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0%H\u0002J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070%2\u0006\u0010'\u001a\u00020\u0007H\u0002J\u001e\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010%2\u0006\u0010'\u001a\u00020\u0007H\u0002J\u0016\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010%H\u0002J\u0014\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0%H\u0002J\u0016\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010%H\u0002J\u001c\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010%2\u0006\u0010-\u001a\u00020\u0007R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/datadog/android/rum/internal/metric/SessionEndedMetric;", "", "sessionId", "", "startReason", "Lcom/datadog/android/rum/internal/domain/scope/RumSessionScope$StartReason;", "ntpOffsetAtStartMs", "", "hasTrackBackgroundEventsEnabled", "", "(Ljava/lang/String;Lcom/datadog/android/rum/internal/domain/scope/RumSessionScope$StartReason;JZ)V", "errorKindFrequencies", "", "", "firstTrackedView", "Lcom/datadog/android/rum/internal/metric/SessionEndedMetric$TrackedView;", "lastTrackedView", "missedEventCountByType", "Lcom/datadog/android/rum/internal/metric/SessionEndedMetric$MissedEventType;", "sessionReplaySkippedFramesCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "trackedViewsById", "wasStopped", "calculateDuration", "escapeNonAlphanumericCharacters", "key", "onErrorTracked", "", "sdkErrorKind", "onMissedEventTracked", "missedEventType", "onSessionReplaySkippedFrameTracked", "onSessionStopped", "onViewTracked", "rumViewEvent", "Lcom/datadog/android/rum/model/ViewEvent;", "resolveNoViewCountsAttributes", "", "resolveNtpOffsetAttributes", "ntpOffsetAtEnd", "resolveRseAttributes", "resolveSDKErrorsCountAttributes", "resolveTop5ErrorsByKind", "resolveViewCountsAttributes", "toMetricAttributes", "ntpOffsetAtEndMs", "Companion", "MissedEventType", "TrackedView", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nSessionEndedMetric.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionEndedMetric.kt\ncom/datadog/android/rum/internal/metric/SessionEndedMetric\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,350:1\n1774#2,4:351\n1774#2,4:355\n1774#2,4:359\n1054#2:363\n1179#2,2:364\n1253#2,4:366\n*S KotlinDebug\n*F\n+ 1 SessionEndedMetric.kt\ncom/datadog/android/rum/internal/metric/SessionEndedMetric\n*L\n142#1:351,4\n144#1:355,4\n146#1:359,4\n159#1:363\n161#1:364,2\n161#1:366,4\n*E\n"})
public final class SessionEndedMetric {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sessionId;
    @NotNull
    private final RumSessionScope.StartReason startReason;
    private final long ntpOffsetAtStartMs;
    private final boolean hasTrackBackgroundEventsEnabled;
    @NotNull
    private final Map<String, TrackedView> trackedViewsById;
    @NotNull
    private final Map<String, Integer> errorKindFrequencies;
    @NotNull
    private final Map<MissedEventType, Integer> missedEventCountByType;
    @NotNull
    private AtomicInteger sessionReplaySkippedFramesCount;
    @Nullable
    private TrackedView firstTrackedView;
    @Nullable
    private TrackedView lastTrackedView;
    private boolean wasStopped;
    private static final int TOP_ERROR_LIMIT = 5;
    @NotNull
    public static final String RUM_SESSION_ENDED_METRIC_NAME = "[Mobile Metric] RUM Session Ended";
    @NotNull
    public static final String METRIC_TYPE_KEY = "metric_type";
    @NotNull
    public static final String METRIC_TYPE_VALUE = "rum session ended";
    @NotNull
    public static final String RSE_KEY = "rse";
    @NotNull
    public static final String PROCESS_TYPE_KEY = "process_type";
    @NotNull
    public static final String PROCESS_TYPE_VALUE = "app";
    @NotNull
    public static final String PRECONDITION_KEY = "precondition";
    @NotNull
    public static final String DURATION_KEY = "duration";
    @NotNull
    public static final String WAS_STOPPED_KEY = "was_stopped";
    @NotNull
    public static final String VIEW_COUNTS_KEY = "views_count";
    @NotNull
    public static final String VIEW_COUNTS_TOTAL_KEY = "total";
    @NotNull
    public static final String VIEW_COUNTS_BG_KEY = "background";
    @NotNull
    public static final String VIEW_COUNTS_APP_LAUNCH_KEY = "app_launch";
    @NotNull
    public static final String VIEW_COUNT_WITH_HAS_REPLAY = "with_has_replay";
    @NotNull
    public static final String NO_VIEW_EVENTS_COUNT_KEY = "no_view_events_count";
    @NotNull
    public static final String NO_VIEW_EVENTS_COUNT_ACTIONS_KEY = "actions";
    @NotNull
    public static final String NO_VIEW_EVENTS_COUNT_RESOURCES_KEY = "resources";
    @NotNull
    public static final String NO_VIEW_EVENTS_COUNT_ERRORS_KEY = "errors";
    @NotNull
    public static final String NO_VIEW_EVENTS_COUNT_LONG_TASKS_KEY = "long_tasks";
    @NotNull
    public static final String HAS_BACKGROUND_EVENTS_TRACKING_ENABLED_KEY = "has_background_events_tracking_enabled";
    @NotNull
    public static final String NTP_OFFSET_KEY = "ntp_offset";
    @NotNull
    public static final String NTP_OFFSET_AT_START_KEY = "at_start";
    @NotNull
    public static final String NTP_OFFSET_AT_END_KEY = "at_end";
    @NotNull
    public static final String SDK_ERRORS_COUNT_KEY = "sdk_errors_count";
    @NotNull
    public static final String SDK_ERRORS_COUNT_TOTAL_KEY = "total";
    @NotNull
    public static final String SDK_ERRORS_COUNT_BY_KIND_KEY = "by_kind";
    @NotNull
    public static final String SDK_ERROR_DEFAULT_KIND = "Empty error kind";
    @NotNull
    public static final String SESSION_REPLAY_SKIPPED_FRAMES_COUNT = "sr_skipped_frames_count";

    public SessionEndedMetric(@NotNull String sessionId, @NotNull RumSessionScope.StartReason startReason, long ntpOffsetAtStartMs, boolean hasTrackBackgroundEventsEnabled) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)((Object)startReason), (String)"startReason");
        this.sessionId = sessionId;
        this.startReason = startReason;
        this.ntpOffsetAtStartMs = ntpOffsetAtStartMs;
        this.hasTrackBackgroundEventsEnabled = hasTrackBackgroundEventsEnabled;
        this.trackedViewsById = new LinkedHashMap();
        this.errorKindFrequencies = new LinkedHashMap();
        this.missedEventCountByType = new LinkedHashMap();
        this.sessionReplaySkippedFramesCount = new AtomicInteger(0);
    }

    public final boolean onViewTracked(@NotNull ViewEvent rumViewEvent) {
        Intrinsics.checkNotNullParameter((Object)rumViewEvent, (String)"rumViewEvent");
        if (!Intrinsics.areEqual((Object)rumViewEvent.getSession().getId(), (Object)this.sessionId)) {
            return false;
        }
        Object object = this.trackedViewsById.get(rumViewEvent.getView().getId());
        if (object == null || (object = ((TrackedView)object).getViewUrl()) == null) {
            object = rumViewEvent.getView().getUrl();
        }
        TrackedView trackedView = this.trackedViewsById.get(rumViewEvent.getView().getId());
        Boolean bl = rumViewEvent.getSession().getHasReplay();
        TrackedView trackedView2 = new TrackedView((String)object, trackedView != null ? trackedView.getStartMs() : rumViewEvent.getDate(), rumViewEvent.getView().getTimeSpent(), bl != null ? bl : false);
        this.trackedViewsById.put(rumViewEvent.getView().getId(), trackedView2);
        if (this.firstTrackedView == null) {
            this.firstTrackedView = trackedView2;
        }
        this.lastTrackedView = trackedView2;
        return true;
    }

    public final void onErrorTracked(@Nullable String sdkErrorKind) {
        String string = sdkErrorKind;
        if (string == null) {
            string = SDK_ERROR_DEFAULT_KIND;
        }
        String errorKindKey = string;
        Map<String, Integer> map = this.errorKindFrequencies;
        Integer n = this.errorKindFrequencies.get(errorKindKey);
        Integer n2 = (n != null ? n : 0) + 1;
        map.put(errorKindKey, n2);
    }

    public final void onSessionStopped() {
        this.wasStopped = true;
    }

    public final void onMissedEventTracked(@NotNull MissedEventType missedEventType) {
        Intrinsics.checkNotNullParameter((Object)((Object)missedEventType), (String)"missedEventType");
        Map<MissedEventType, Integer> map = this.missedEventCountByType;
        Integer n = this.missedEventCountByType.get((Object)missedEventType);
        Integer n2 = (n != null ? n : 0) + 1;
        map.put(missedEventType, n2);
    }

    public final void onSessionReplaySkippedFrameTracked() {
        this.sessionReplaySkippedFramesCount.incrementAndGet();
    }

    @NotNull
    public final Map<String, Object> toMetricAttributes(long ntpOffsetAtEndMs) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)METRIC_TYPE_KEY, (Object)METRIC_TYPE_VALUE), TuplesKt.to((Object)RSE_KEY, this.resolveRseAttributes(ntpOffsetAtEndMs))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final long calculateDuration() {
        TrackedView trackedView = this.lastTrackedView;
        TrackedView trackedView2 = trackedView;
        if (trackedView == null) return 0L;
        TrackedView last = trackedView2;
        boolean bl = false;
        TrackedView trackedView3 = this.firstTrackedView;
        if (trackedView3 == null) return 0L;
        TrackedView first = trackedView3;
        boolean bl2 = false;
        Long l = TimeUnit.MILLISECONDS.toNanos(last.getStartMs() - first.getStartMs()) + last.getDurationNs();
        trackedView2 = l;
        if (l == null) return 0L;
        long l2 = (Long)((Object)trackedView2);
        return l2;
    }

    private final Map<String, Object> resolveRseAttributes(long ntpOffsetAtEnd) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PROCESS_TYPE_KEY, (Object)PROCESS_TYPE_VALUE), TuplesKt.to((Object)PRECONDITION_KEY, (Object)this.startReason.getAsString()), TuplesKt.to((Object)DURATION_KEY, (Object)this.calculateDuration()), TuplesKt.to((Object)WAS_STOPPED_KEY, (Object)this.wasStopped), TuplesKt.to((Object)VIEW_COUNTS_KEY, this.resolveViewCountsAttributes()), TuplesKt.to((Object)SDK_ERRORS_COUNT_KEY, this.resolveSDKErrorsCountAttributes()), TuplesKt.to((Object)NO_VIEW_EVENTS_COUNT_KEY, this.resolveNoViewCountsAttributes()), TuplesKt.to((Object)HAS_BACKGROUND_EVENTS_TRACKING_ENABLED_KEY, (Object)this.hasTrackBackgroundEventsEnabled), TuplesKt.to((Object)NTP_OFFSET_KEY, this.resolveNtpOffsetAttributes(ntpOffsetAtEnd)), TuplesKt.to((Object)SESSION_REPLAY_SKIPPED_FRAMES_COUNT, (Object)this.sessionReplaySkippedFramesCount.get())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Map<String, Integer> resolveNoViewCountsAttributes() {
        Pair[] pairArray = new Pair[4];
        Integer n = this.missedEventCountByType.get((Object)MissedEventType.ACTION);
        pairArray[0] = TuplesKt.to((Object)NO_VIEW_EVENTS_COUNT_ACTIONS_KEY, (Object)(n != null ? n : 0));
        Integer n2 = this.missedEventCountByType.get((Object)MissedEventType.RESOURCE);
        pairArray[1] = TuplesKt.to((Object)NO_VIEW_EVENTS_COUNT_RESOURCES_KEY, (Object)(n2 != null ? n2 : 0));
        Integer n3 = this.missedEventCountByType.get((Object)MissedEventType.ERROR);
        pairArray[2] = TuplesKt.to((Object)NO_VIEW_EVENTS_COUNT_ERRORS_KEY, (Object)(n3 != null ? n3 : 0));
        Integer n4 = this.missedEventCountByType.get((Object)MissedEventType.LONG_TASK);
        pairArray[3] = TuplesKt.to((Object)NO_VIEW_EVENTS_COUNT_LONG_TASKS_KEY, (Object)(n4 != null ? n4 : 0));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Map<String, Long> resolveNtpOffsetAttributes(long ntpOffsetAtEnd) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)NTP_OFFSET_AT_START_KEY, (Object)this.ntpOffsetAtStartMs), TuplesKt.to((Object)NTP_OFFSET_AT_END_KEY, (Object)ntpOffsetAtEnd)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Map<String, Object> resolveViewCountsAttributes() {
        int n;
        int n2;
        TrackedView it;
        int count$iv;
        int n3;
        Iterable $this$count$iv;
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)"total", (Object)this.trackedViewsById.size());
        Iterable iterable = this.trackedViewsById.values();
        String string = VIEW_COUNTS_BG_KEY;
        int n4 = 1;
        Pair[] pairArray2 = pairArray;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n3 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (TrackedView)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getViewUrl(), (Object)"com/datadog/background/view") || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n3 = count$iv;
        }
        int n5 = n3;
        pairArray2[n4] = TuplesKt.to((Object)string, (Object)n5);
        $this$count$iv = this.trackedViewsById.values();
        string = VIEW_COUNTS_APP_LAUNCH_KEY;
        n4 = 2;
        pairArray2 = pairArray;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (TrackedView)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getViewUrl(), (Object)"com/datadog/application-launch/view") || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        n5 = n2;
        pairArray2[n4] = TuplesKt.to((Object)string, (Object)n5);
        $this$count$iv = this.trackedViewsById.values();
        string = VIEW_COUNT_WITH_HAS_REPLAY;
        n4 = 3;
        pairArray2 = pairArray;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (TrackedView)element$iv;
                boolean bl = false;
                if (!it.getHasReplay() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        n5 = n;
        pairArray2[n4] = TuplesKt.to((Object)string, (Object)n5);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Map<String, Object> resolveSDKErrorsCountAttributes() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"total", (Object)CollectionsKt.sumOfInt((Iterable)this.errorKindFrequencies.values())), TuplesKt.to((Object)SDK_ERRORS_COUNT_BY_KIND_KEY, this.resolveTop5ErrorsByKind())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Integer> resolveTop5ErrorsByKind() {
        void $this$associateTo$iv$iv;
        int limit = RangesKt.coerceAtMost((int)5, (int)this.errorKindFrequencies.size());
        Iterable $this$sortedByDescending$iv = this.errorKindFrequencies.entrySet();
        boolean $i$f$sortedByDescending = false;
        Iterable $this$associate$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getValue()));
            }
        }).subList(0, limit);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)this.escapeNonAlphanumericCharacters((String)entry.getKey()), entry.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private final String escapeNonAlphanumericCharacters(String key) {
        Regex regex = new Regex("[^\\w']+");
        CharSequence charSequence = key;
        String string = "_";
        return regex.replace(charSequence, string);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/datadog/android/rum/internal/metric/SessionEndedMetric$Companion;", "", "()V", "DURATION_KEY", "", "HAS_BACKGROUND_EVENTS_TRACKING_ENABLED_KEY", "METRIC_TYPE_KEY", "METRIC_TYPE_VALUE", "NO_VIEW_EVENTS_COUNT_ACTIONS_KEY", "NO_VIEW_EVENTS_COUNT_ERRORS_KEY", "NO_VIEW_EVENTS_COUNT_KEY", "NO_VIEW_EVENTS_COUNT_LONG_TASKS_KEY", "NO_VIEW_EVENTS_COUNT_RESOURCES_KEY", "NTP_OFFSET_AT_END_KEY", "NTP_OFFSET_AT_START_KEY", "NTP_OFFSET_KEY", "PRECONDITION_KEY", "PROCESS_TYPE_KEY", "PROCESS_TYPE_VALUE", "RSE_KEY", "RUM_SESSION_ENDED_METRIC_NAME", "SDK_ERRORS_COUNT_BY_KIND_KEY", "SDK_ERRORS_COUNT_KEY", "SDK_ERRORS_COUNT_TOTAL_KEY", "SDK_ERROR_DEFAULT_KIND", "SESSION_REPLAY_SKIPPED_FRAMES_COUNT", "TOP_ERROR_LIMIT", "", "VIEW_COUNTS_APP_LAUNCH_KEY", "VIEW_COUNTS_BG_KEY", "VIEW_COUNTS_KEY", "VIEW_COUNTS_TOTAL_KEY", "VIEW_COUNT_WITH_HAS_REPLAY", "WAS_STOPPED_KEY", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0080\u0001\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Lcom/datadog/android/rum/internal/metric/SessionEndedMetric$MissedEventType;", "", "(Ljava/lang/String;I)V", "ACTION", "RESOURCE", "ERROR", "LONG_TASK", "Companion", "dd-sdk-android-rum_release"})
    public static final class MissedEventType
    extends Enum<MissedEventType> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ MissedEventType ACTION;
        public static final /* enum */ MissedEventType RESOURCE;
        public static final /* enum */ MissedEventType ERROR;
        public static final /* enum */ MissedEventType LONG_TASK;
        private static final /* synthetic */ MissedEventType[] $VALUES;

        public static MissedEventType[] values() {
            return (MissedEventType[])$VALUES.clone();
        }

        public static MissedEventType valueOf(String value) {
            return Enum.valueOf(MissedEventType.class, value);
        }

        static {
            ACTION = new MissedEventType();
            RESOURCE = new MissedEventType();
            ERROR = new MissedEventType();
            LONG_TASK = new MissedEventType();
            $VALUES = missedEventTypeArray = new MissedEventType[]{MissedEventType.ACTION, MissedEventType.RESOURCE, MissedEventType.ERROR, MissedEventType.LONG_TASK};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/rum/internal/metric/SessionEndedMetric$MissedEventType$Companion;", "", "()V", "fromRawEvent", "Lcom/datadog/android/rum/internal/metric/SessionEndedMetric$MissedEventType;", "rawEvent", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "dd-sdk-android-rum_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final MissedEventType fromRawEvent(@NotNull RumRawEvent rawEvent) {
                Intrinsics.checkNotNullParameter((Object)rawEvent, (String)"rawEvent");
                RumRawEvent rumRawEvent = rawEvent;
                return (rumRawEvent instanceof RumRawEvent.AddError ? true : rumRawEvent instanceof RumRawEvent.StopResourceWithError) ? ERROR : (rumRawEvent instanceof RumRawEvent.StartAction ? ACTION : (rumRawEvent instanceof RumRawEvent.StartResource ? RESOURCE : (rumRawEvent instanceof RumRawEvent.AddLongTask ? LONG_TASK : null)));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/datadog/android/rum/internal/metric/SessionEndedMetric$TrackedView;", "", "viewUrl", "", "startMs", "", "durationNs", "hasReplay", "", "(Ljava/lang/String;JJZ)V", "getDurationNs", "()J", "getHasReplay", "()Z", "getStartMs", "getViewUrl", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "dd-sdk-android-rum_release"})
    public static final class TrackedView {
        @NotNull
        private final String viewUrl;
        private final long startMs;
        private final long durationNs;
        private final boolean hasReplay;

        public TrackedView(@NotNull String viewUrl, long startMs, long durationNs, boolean hasReplay) {
            Intrinsics.checkNotNullParameter((Object)viewUrl, (String)"viewUrl");
            this.viewUrl = viewUrl;
            this.startMs = startMs;
            this.durationNs = durationNs;
            this.hasReplay = hasReplay;
        }

        @NotNull
        public final String getViewUrl() {
            return this.viewUrl;
        }

        public final long getStartMs() {
            return this.startMs;
        }

        public final long getDurationNs() {
            return this.durationNs;
        }

        public final boolean getHasReplay() {
            return this.hasReplay;
        }

        @NotNull
        public final String component1() {
            return this.viewUrl;
        }

        public final long component2() {
            return this.startMs;
        }

        public final long component3() {
            return this.durationNs;
        }

        public final boolean component4() {
            return this.hasReplay;
        }

        @NotNull
        public final TrackedView copy(@NotNull String viewUrl, long startMs, long durationNs, boolean hasReplay) {
            Intrinsics.checkNotNullParameter((Object)viewUrl, (String)"viewUrl");
            return new TrackedView(viewUrl, startMs, durationNs, hasReplay);
        }

        public static /* synthetic */ TrackedView copy$default(TrackedView trackedView, String string, long l, long l2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = trackedView.viewUrl;
            }
            if ((n & 2) != 0) {
                l = trackedView.startMs;
            }
            if ((n & 4) != 0) {
                l2 = trackedView.durationNs;
            }
            if ((n & 8) != 0) {
                bl = trackedView.hasReplay;
            }
            return trackedView.copy(string, l, l2, bl);
        }

        @NotNull
        public String toString() {
            return "TrackedView(viewUrl=" + this.viewUrl + ", startMs=" + this.startMs + ", durationNs=" + this.durationNs + ", hasReplay=" + this.hasReplay + ")";
        }

        public int hashCode() {
            int result = this.viewUrl.hashCode();
            result = result * 31 + Long.hashCode(this.startMs);
            result = result * 31 + Long.hashCode(this.durationNs);
            result = result * 31 + Boolean.hashCode(this.hasReplay);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrackedView)) {
                return false;
            }
            TrackedView trackedView = (TrackedView)other;
            if (!Intrinsics.areEqual((Object)this.viewUrl, (Object)trackedView.viewUrl)) {
                return false;
            }
            if (this.startMs != trackedView.startMs) {
                return false;
            }
            if (this.durationNs != trackedView.durationNs) {
                return false;
            }
            return this.hasReplay == trackedView.hasReplay;
        }
    }
}

