/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.metric;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.metrics.MethodCallSamplingRate;
import com.datadog.android.rum.internal.domain.scope.RumSessionScope;
import com.datadog.android.rum.internal.metric.SessionEndedMetric;
import com.datadog.android.rum.internal.metric.SessionEndedMetricDispatcher;
import com.datadog.android.rum.internal.metric.SessionMetricDispatcher;
import com.datadog.android.rum.model.ViewEvent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u001a\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/datadog/android/rum/internal/metric/SessionEndedMetricDispatcher;", "Lcom/datadog/android/rum/internal/metric/SessionMetricDispatcher;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/InternalLogger;)V", "metricsBySessionId", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/datadog/android/rum/internal/metric/SessionEndedMetric;", "buildSdkErrorTrackError", "sessionId", "errorKind", "buildViewTrackError", "viewEvent", "Lcom/datadog/android/rum/model/ViewEvent;", "endMetric", "", "ntpOffsetAtEndMs", "", "onMissedEventTracked", "missedEventType", "Lcom/datadog/android/rum/internal/metric/SessionEndedMetric$MissedEventType;", "onSdkErrorTracked", "onSessionReplaySkippedFrameTracked", "onSessionStopped", "onViewTracked", "startMetric", "startReason", "Lcom/datadog/android/rum/internal/domain/scope/RumSessionScope$StartReason;", "ntpOffsetAtStartMs", "backgroundEventTracking", "", "dd-sdk-android-rum_release"})
public final class SessionEndedMetricDispatcher
implements SessionMetricDispatcher {
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final ConcurrentHashMap<String, SessionEndedMetric> metricsBySessionId;

    public SessionEndedMetricDispatcher(@NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.internalLogger = internalLogger;
        this.metricsBySessionId = new ConcurrentHashMap();
    }

    @Override
    public void startMetric(@NotNull String sessionId, @NotNull RumSessionScope.StartReason startReason, long ntpOffsetAtStartMs, boolean backgroundEventTracking) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)((Object)startReason), (String)"startReason");
        ((Map)this.metricsBySessionId).put(sessionId, new SessionEndedMetric(sessionId, startReason, ntpOffsetAtStartMs, backgroundEventTracking));
    }

    @Override
    public void endMetric(@NotNull String sessionId, long ntpOffsetAtEndMs) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            SessionEndedMetric sessionEndedMetric = this.metricsBySessionId.remove(sessionId);
            if (sessionEndedMetric == null) break block0;
            SessionEndedMetric metric = sessionEndedMetric;
            boolean bl = false;
            InternalLogger.DefaultImpls.logMetric$default((InternalLogger)this.internalLogger, (Function0)endMetric.1.1.INSTANCE, metric.toMetricAttributes(ntpOffsetAtEndMs), (float)MethodCallSamplingRate.ALL.getRate(), null, (int)8, null);
        }
    }

    @Override
    public void onSessionStopped(@NotNull String sessionId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            SessionEndedMetric sessionEndedMetric = this.metricsBySessionId.get(sessionId);
            if (sessionEndedMetric == null) break block0;
            sessionEndedMetric.onSessionStopped();
        }
    }

    @Override
    public void onViewTracked(@NotNull String sessionId, @NotNull ViewEvent viewEvent) {
        boolean result;
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)viewEvent, (String)"viewEvent");
        SessionEndedMetric sessionEndedMetric = this.metricsBySessionId.get(sessionId);
        boolean bl = result = sessionEndedMetric != null ? sessionEndedMetric.onViewTracked(viewEvent) : false;
        if (!result) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)((Function0)new Function0<String>(this, sessionId, viewEvent){
                final /* synthetic */ SessionEndedMetricDispatcher this$0;
                final /* synthetic */ String $sessionId;
                final /* synthetic */ ViewEvent $viewEvent;
                {
                    this.this$0 = $receiver;
                    this.$sessionId = $sessionId;
                    this.$viewEvent = $viewEvent;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return SessionEndedMetricDispatcher.access$buildViewTrackError(this.this$0, this.$sessionId, this.$viewEvent);
                }
            }), null, (boolean)false, null, (int)56, null);
        }
    }

    @Override
    public void onSdkErrorTracked(@NotNull String sessionId, @Nullable String errorKind) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        SessionEndedMetric sessionEndedMetric = this.metricsBySessionId.get(sessionId);
        if (sessionEndedMetric != null) {
            sessionEndedMetric.onErrorTracked(errorKind);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)((Function0)new Function0<String>(this, sessionId, errorKind){
                final /* synthetic */ SessionEndedMetricDispatcher this$0;
                final /* synthetic */ String $sessionId;
                final /* synthetic */ String $errorKind;
                {
                    this.this$0 = $receiver;
                    this.$sessionId = $sessionId;
                    this.$errorKind = $errorKind;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return SessionEndedMetricDispatcher.access$buildSdkErrorTrackError(this.this$0, this.$sessionId, this.$errorKind);
                }
            }), null, (boolean)false, null, (int)56, null);
        }
    }

    @Override
    public void onMissedEventTracked(@NotNull String sessionId, @NotNull SessionEndedMetric.MissedEventType missedEventType) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)((Object)missedEventType), (String)"missedEventType");
            SessionEndedMetric sessionEndedMetric = this.metricsBySessionId.get(sessionId);
            if (sessionEndedMetric == null) break block0;
            sessionEndedMetric.onMissedEventTracked(missedEventType);
        }
    }

    @Override
    public void onSessionReplaySkippedFrameTracked(@NotNull String sessionId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            SessionEndedMetric sessionEndedMetric = this.metricsBySessionId.get(sessionId);
            if (sessionEndedMetric == null) break block0;
            sessionEndedMetric.onSessionReplaySkippedFrameTracked();
        }
    }

    private final String buildSdkErrorTrackError(String sessionId, String errorKind) {
        return "Failed to track " + errorKind + " error, session " + sessionId + " has ended";
    }

    private final String buildViewTrackError(String sessionId, ViewEvent viewEvent) {
        String string = viewEvent.getView().getUrl();
        String viewType = Intrinsics.areEqual((Object)string, (Object)"com/datadog/application-launch/view") ? "AppLaunch" : (Intrinsics.areEqual((Object)string, (Object)"com/datadog/background/view") ? "Background" : "Custom");
        return "Failed to track " + viewType + " view in session with different UUID " + sessionId;
    }

    public static final /* synthetic */ String access$buildViewTrackError(SessionEndedMetricDispatcher $this, String sessionId, ViewEvent viewEvent) {
        return $this.buildViewTrackError(sessionId, viewEvent);
    }

    public static final /* synthetic */ String access$buildSdkErrorTrackError(SessionEndedMetricDispatcher $this, String sessionId, String errorKind) {
        return $this.buildSdkErrorTrackError(sessionId, errorKind);
    }
}

