/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.metric.interactiontonextview;

import androidx.annotation.VisibleForTesting;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.rum.internal.metric.interactiontonextview.ActionTypeInteractionValidator;
import com.datadog.android.rum.internal.metric.interactiontonextview.InteractionIngestionValidator;
import com.datadog.android.rum.internal.metric.interactiontonextview.InternalInteractionContext;
import com.datadog.android.rum.metric.interactiontonextview.LastInteractionIdentifier;
import com.datadog.android.rum.metric.interactiontonextview.PreviousViewLastInteractionContext;
import com.datadog.android.rum.metric.interactiontonextview.TimeBasedInteractionIdentifier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0011H\u0001\u00a2\u0006\u0002\b\u0012J\u0019\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0001\u00a2\u0006\u0002\b\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fJ\u0016\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000fJ\b\u0010\u001a\u001a\u00020\u0015H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0015\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/datadog/android/rum/internal/metric/interactiontonextview/InteractionToNextViewMetricResolver;", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "ingestionValidator", "Lcom/datadog/android/rum/internal/metric/interactiontonextview/InteractionIngestionValidator;", "lastInteractionIdentifier", "Lcom/datadog/android/rum/metric/interactiontonextview/LastInteractionIdentifier;", "(Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/rum/internal/metric/interactiontonextview/InteractionIngestionValidator;Lcom/datadog/android/rum/metric/interactiontonextview/LastInteractionIdentifier;)V", "lastInteractions", "Ljava/util/LinkedHashMap;", "", "Lcom/datadog/android/rum/internal/metric/interactiontonextview/InternalInteractionContext;", "Lkotlin/collections/LinkedHashMap;", "lastViewCreatedTimestamps", "", "lasInteractions", "", "lasInteractions$dd_sdk_android_rum_release", "lastViewCreatedTimestamps$dd_sdk_android_rum_release", "onActionSent", "", "context", "onViewCreated", "viewId", "timestamp", "purgeOldEntries", "resolveLastInteraction", "currentViewCreatedTimestamp", "resolveMetric", "(Ljava/lang/String;)Ljava/lang/Long;", "Companion", "dd-sdk-android-rum_release"})
public final class InteractionToNextViewMetricResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final InteractionIngestionValidator ingestionValidator;
    @NotNull
    private final LastInteractionIdentifier lastInteractionIdentifier;
    @NotNull
    private final LinkedHashMap<String, InternalInteractionContext> lastInteractions;
    @NotNull
    private final LinkedHashMap<String, Long> lastViewCreatedTimestamps;
    public static final int MAX_ENTRIES = 4;

    public InteractionToNextViewMetricResolver(@NotNull InternalLogger internalLogger, @NotNull InteractionIngestionValidator ingestionValidator, @NotNull LastInteractionIdentifier lastInteractionIdentifier) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)ingestionValidator, (String)"ingestionValidator");
        Intrinsics.checkNotNullParameter((Object)lastInteractionIdentifier, (String)"lastInteractionIdentifier");
        this.internalLogger = internalLogger;
        this.ingestionValidator = ingestionValidator;
        this.lastInteractionIdentifier = lastInteractionIdentifier;
        this.lastInteractions = new LinkedHashMap();
        this.lastViewCreatedTimestamps = new LinkedHashMap();
    }

    public /* synthetic */ InteractionToNextViewMetricResolver(InternalLogger internalLogger, InteractionIngestionValidator interactionIngestionValidator, LastInteractionIdentifier lastInteractionIdentifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            interactionIngestionValidator = new ActionTypeInteractionValidator();
        }
        if ((n & 4) != 0) {
            lastInteractionIdentifier = new TimeBasedInteractionIdentifier(0L, 1, null);
        }
        this(internalLogger, interactionIngestionValidator, lastInteractionIdentifier);
    }

    public final void onViewCreated(@NotNull String viewId, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        Long l = timestamp;
        ((Map)this.lastViewCreatedTimestamps).put(viewId, l);
        this.purgeOldEntries();
    }

    public final void onActionSent(@NotNull InternalInteractionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.ingestionValidator.validate(context)) {
            ((Map)this.lastInteractions).put(context.getViewId$dd_sdk_android_rum_release(), context);
        }
        this.purgeOldEntries();
    }

    @Nullable
    public final Long resolveMetric(@NotNull String viewId) {
        Intrinsics.checkNotNullParameter((Object)viewId, (String)"viewId");
        this.purgeOldEntries();
        Long currentViewCreatedTimestamp = this.lastViewCreatedTimestamps.get(viewId);
        if (currentViewCreatedTimestamp == null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)((Function0)new Function0<String>(viewId){
                final /* synthetic */ String $viewId;
                {
                    this.$viewId = $viewId;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "[ViewNetworkSettledMetric] The view was not yet created for this viewId:" + this.$viewId;
                }
            }), null, (boolean)false, null, (int)56, null);
            return null;
        }
        InternalInteractionContext lastPrevViewInteraction = this.resolveLastInteraction(viewId, currentViewCreatedTimestamp);
        if (lastPrevViewInteraction != null) {
            long difference = currentViewCreatedTimestamp - lastPrevViewInteraction.getEventCreatedAtNanos$dd_sdk_android_rum_release();
            if (difference > 0L) {
                return difference;
            }
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)((Function0)new Function0<String>(viewId){
                final /* synthetic */ String $viewId;
                {
                    this.$viewId = $viewId;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "[ViewNetworkSettledMetric] The difference between the last interaction and the current view is negative for viewId:" + this.$viewId;
                }
            }), null, (boolean)false, null, (int)56, null);
            return null;
        }
        if (this.lastViewCreatedTimestamps.size() > 1) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)((Function0)new Function0<String>(viewId){
                final /* synthetic */ String $viewId;
                {
                    this.$viewId = $viewId;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "[ViewNetworkSettledMetric] No previous interaction found for this viewId:" + this.$viewId;
                }
            }), null, (boolean)false, null, (int)56, null);
        }
        return null;
    }

    private final InternalInteractionContext resolveLastInteraction(String viewId, long currentViewCreatedTimestamp) {
        Set<String> set = this.lastViewCreatedTimestamps.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"lastViewCreatedTimestamps.keys");
        int currentViewIdIndex = CollectionsKt.indexOf((Iterable)set, (Object)viewId);
        Set<String> set2 = this.lastViewCreatedTimestamps.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"lastViewCreatedTimestamps.keys");
        String previousViewId = (String)CollectionsKt.elementAtOrNull((Iterable)set2, (int)(currentViewIdIndex - 1));
        if (previousViewId != null) {
            InternalInteractionContext internalInteractionContext = this.lastInteractions.get(previousViewId);
            if (internalInteractionContext != null) {
                InternalInteractionContext it = internalInteractionContext;
                boolean bl = false;
                PreviousViewLastInteractionContext context = new PreviousViewLastInteractionContext(it.getActionType$dd_sdk_android_rum_release(), it.getEventCreatedAtNanos$dd_sdk_android_rum_release(), currentViewCreatedTimestamp);
                if (this.lastInteractionIdentifier.validate(context)) {
                    return it;
                }
            }
        }
        return null;
    }

    private final void purgeOldEntries() {
        while (this.lastInteractions.entrySet().size() > 4) {
            Set<Map.Entry<String, InternalInteractionContext>> set = this.lastInteractions.entrySet();
            Set<Map.Entry<String, InternalInteractionContext>> set2 = this.lastInteractions.entrySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"lastInteractions.entries");
            set.remove(CollectionsKt.first((Iterable)set2));
        }
        while (this.lastViewCreatedTimestamps.entrySet().size() > 4) {
            Set<String> set = this.lastViewCreatedTimestamps.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"lastViewCreatedTimestamps.keys");
            this.lastViewCreatedTimestamps.remove(CollectionsKt.first((Iterable)set));
        }
    }

    @VisibleForTesting
    @NotNull
    public final Map<String, InternalInteractionContext> lasInteractions$dd_sdk_android_rum_release() {
        return this.lastInteractions;
    }

    @VisibleForTesting
    @NotNull
    public final Map<String, Long> lastViewCreatedTimestamps$dd_sdk_android_rum_release() {
        return this.lastViewCreatedTimestamps;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/rum/internal/metric/interactiontonextview/InteractionToNextViewMetricResolver$Companion;", "", "()V", "MAX_ENTRIES", "", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

