/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.metric.networksettled;

import androidx.annotation.VisibleForTesting;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.rum.internal.metric.networksettled.InternalResourceContext;
import com.datadog.android.rum.internal.metric.networksettled.NetworkSettledMetricResolver;
import com.datadog.android.rum.metric.networksettled.InitialResourceIdentifier;
import com.datadog.android.rum.metric.networksettled.NetworkSettledResourceContext;
import com.datadog.android.rum.metric.networksettled.TimeBasedInitialResourceIdentifier;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\r\u0010\u0016\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rJ\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\bJ\u0006\u0010\u0010\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0012\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/datadog/android/rum/internal/metric/networksettled/NetworkSettledMetricResolver;", "", "initialResourceIdentifier", "Lcom/datadog/android/rum/metric/networksettled/InitialResourceIdentifier;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/rum/metric/networksettled/InitialResourceIdentifier;Lcom/datadog/android/api/InternalLogger;)V", "lastComputedMetric", "", "Ljava/lang/Long;", "networkSettleMaxValue", "resourceStartedTimestamps", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "viewCreatedTimestamp", "viewWasStopped", "", "computeMetric", "()Ljava/lang/Long;", "getResourceStartedCacheSize", "", "resolveMetric", "resourceWasDropped", "", "resourceId", "resourceWasStarted", "context", "Lcom/datadog/android/rum/internal/metric/networksettled/InternalResourceContext;", "resourceWasStopped", "viewWasCreated", "eventTimestampInNanos", "dd-sdk-android-rum_release"})
public final class NetworkSettledMetricResolver {
    @NotNull
    private final InitialResourceIdentifier initialResourceIdentifier;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final HashSet<String> resourceStartedTimestamps;
    @Nullable
    private volatile Long networkSettleMaxValue;
    @Nullable
    private volatile Long viewCreatedTimestamp;
    @Nullable
    private volatile Long lastComputedMetric;
    private volatile boolean viewWasStopped;

    public NetworkSettledMetricResolver(@NotNull InitialResourceIdentifier initialResourceIdentifier, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)initialResourceIdentifier, (String)"initialResourceIdentifier");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.initialResourceIdentifier = initialResourceIdentifier;
        this.internalLogger = internalLogger;
        this.resourceStartedTimestamps = new HashSet();
    }

    public /* synthetic */ NetworkSettledMetricResolver(InitialResourceIdentifier initialResourceIdentifier, InternalLogger internalLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            initialResourceIdentifier = new TimeBasedInitialResourceIdentifier(0L, 1, null);
        }
        this(initialResourceIdentifier, internalLogger);
    }

    public final void viewWasCreated(long eventTimestampInNanos) {
        this.viewCreatedTimestamp = eventTimestampInNanos;
    }

    public final void resourceWasStarted(@NotNull InternalResourceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.viewWasStopped) {
            return;
        }
        if (this.initialResourceIdentifier.validate(new NetworkSettledResourceContext(context.getResourceId$dd_sdk_android_rum_release(), context.getEventCreatedAtNanos$dd_sdk_android_rum_release(), this.viewCreatedTimestamp))) {
            this.resourceStartedTimestamps.add(context.getResourceId$dd_sdk_android_rum_release());
        }
    }

    public final void resourceWasStopped(@NotNull InternalResourceContext context) {
        long networkToSettledDuration;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.viewWasStopped) {
            return;
        }
        Long currentViewCreatedTimestamp = this.viewCreatedTimestamp;
        Long l = this.networkSettleMaxValue;
        long currentNetworkSettleMaxValue = l != null ? l : 0L;
        boolean resourceStartedTimestamp = this.resourceStartedTimestamps.remove(context.getResourceId$dd_sdk_android_rum_release());
        if (currentViewCreatedTimestamp != null && resourceStartedTimestamp && (networkToSettledDuration = context.getEventCreatedAtNanos$dd_sdk_android_rum_release() - currentViewCreatedTimestamp) > currentNetworkSettleMaxValue) {
            this.networkSettleMaxValue = networkToSettledDuration;
        }
    }

    public final void resourceWasDropped(@NotNull String resourceId) {
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        if (this.viewWasStopped) {
            return;
        }
        this.resourceStartedTimestamps.remove(resourceId);
    }

    public final void viewWasStopped() {
        this.viewWasStopped = true;
        this.resourceStartedTimestamps.clear();
    }

    @Nullable
    public final Long resolveMetric() {
        if (this.viewWasStopped) {
            return this.lastComputedMetric;
        }
        this.lastComputedMetric = this.computeMetric();
        return this.lastComputedMetric;
    }

    @VisibleForTesting
    public final int getResourceStartedCacheSize() {
        return this.resourceStartedTimestamps.size();
    }

    private final Long computeMetric() {
        if (this.viewCreatedTimestamp == null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.DEBUG, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)computeMetric.1.INSTANCE, null, (boolean)false, null, (int)56, null);
            return null;
        }
        if (this.resourceStartedTimestamps.size() > 0) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.DEBUG, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)computeMetric.2.INSTANCE, null, (boolean)false, null, (int)56, null);
            return null;
        }
        return this.networkSettleMaxValue;
    }
}

