/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.net;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.net.Request;
import com.datadog.android.api.net.RequestExecutionContext;
import com.datadog.android.api.net.RequestFactory;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.core.internal.utils.ByteArrayExtKt;
import com.datadog.android.rum.internal.domain.event.RumViewEventFilter;
import com.datadog.android.rum.internal.net.RumRequestFactory;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ.\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J8\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J0\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010!\u001a\u00020 H\u0002R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/datadog/android/rum/internal/net/RumRequestFactory;", "Lcom/datadog/android/api/net/RequestFactory;", "customEndpointUrl", "", "viewEventFilter", "Lcom/datadog/android/rum/internal/domain/event/RumViewEventFilter;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Ljava/lang/String;Lcom/datadog/android/rum/internal/domain/event/RumViewEventFilter;Lcom/datadog/android/api/InternalLogger;)V", "getCustomEndpointUrl$dd_sdk_android_rum_release", "()Ljava/lang/String;", "buildHeaders", "", "requestId", "idempotencyKey", "context", "Lcom/datadog/android/api/context/DatadogContext;", "buildTags", "serviceName", "version", "sdkVersion", "env", "variant", "executionContext", "Lcom/datadog/android/api/net/RequestExecutionContext;", "buildUrl", "create", "Lcom/datadog/android/api/net/Request;", "batchData", "", "Lcom/datadog/android/api/storage/RawBatchEvent;", "batchMetadata", "", "byteArray", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nRumRequestFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RumRequestFactory.kt\ncom/datadog/android/rum/internal/net/RumRequestFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,173:1\n1549#2:174\n1620#2,3:175\n1549#2:178\n1620#2,3:179\n125#3:182\n152#3,3:183\n*S KotlinDebug\n*F\n+ 1 RumRequestFactory.kt\ncom/datadog/android/rum/internal/net/RumRequestFactory\n*L\n39#1:174\n39#1:175,3\n55#1:178\n55#1:179,3\n83#1:182\n83#1:183,3\n*E\n"})
public final class RumRequestFactory
implements RequestFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String customEndpointUrl;
    @NotNull
    private final RumViewEventFilter viewEventFilter;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private static final byte[] PAYLOAD_SEPARATOR;
    @NotNull
    public static final String RETRY_COUNT_KEY = "retry_count";
    @NotNull
    public static final String LAST_FAILURE_STATUS_KEY = "last_failure_status";
    @NotNull
    private static final String SHA1_GENERATION_ERROR_MESSAGE = "Cannot generate SHA-1 hash for rum request idempotency key.";
    @NotNull
    private static final String SHA1_NO_SUCH_ALGORITHM_EXCEPTION = "SHA-1 algorithm could not be found in MessageDigest.";

    public RumRequestFactory(@Nullable String customEndpointUrl, @NotNull RumViewEventFilter viewEventFilter, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)viewEventFilter, (String)"viewEventFilter");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.customEndpointUrl = customEndpointUrl;
        this.viewEventFilter = viewEventFilter;
        this.internalLogger = internalLogger;
    }

    @Nullable
    public final String getCustomEndpointUrl$dd_sdk_android_rum_release() {
        return this.customEndpointUrl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Request create(@NotNull DatadogContext context, @NotNull RequestExecutionContext executionContext, @NotNull List<RawBatchEvent> batchData, @Nullable byte[] batchMetadata) {
        Collection<byte[]> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter(batchData, (String)"batchData");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String requestId = string;
        Iterable iterable = this.viewEventFilter.filterOutRedundantViewEvents(batchData);
        boolean $i$f$map22 = false;
        void var9_9 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            RawBatchEvent rawBatchEvent = (RawBatchEvent)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getData());
        }
        byte[] body = ByteArrayExtKt.join$default((Collection)((List)destination$iv$iv), (byte[])PAYLOAD_SEPARATOR, null, null, (InternalLogger)this.internalLogger, (int)6, null);
        String idempotencyKey2 = this.idempotencyKey(body);
        Iterable $i$f$map22 = this.viewEventFilter.filterOutRedundantViewEvents(batchData);
        Map<String, String> map = this.buildHeaders(requestId, idempotencyKey2, context);
        String string2 = this.buildUrl(context, executionContext);
        String string3 = "RUM Request";
        String string4 = requestId;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RawBatchEvent bl = (RawBatchEvent)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getData());
        }
        collection = (List)destination$iv$iv2;
        String string5 = "text/plain;charset=UTF-8";
        byte[] byArray = ByteArrayExtKt.join$default((Collection)collection, (byte[])PAYLOAD_SEPARATOR, null, null, (InternalLogger)this.internalLogger, (int)6, null);
        Map<String, String> map2 = map;
        String string6 = string2;
        String string7 = string3;
        String string8 = string4;
        return new Request(string8, string7, string6, map2, byArray, string5);
    }

    /*
     * WARNING - void declaration
     */
    private final String buildUrl(DatadogContext context, RequestExecutionContext executionContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ddsource", (Object)context.getSource()), TuplesKt.to((Object)"ddtags", (Object)this.buildTags(context.getService(), context.getVersion(), context.getSdkVersion(), context.getEnv(), context.getVariant(), executionContext))};
        Map queryParams = MapsKt.mapOf((Pair[])pairArray);
        Object object = "%s/api/v2/rum";
        Locale locale = Locale.US;
        Object[] objectArray = new Object[1];
        String string = this.customEndpointUrl;
        if (string == null) {
            string = context.getSite().getIntakeEndpoint();
        }
        objectArray[0] = string;
        String string2 = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String intakeUrl = string2;
        object = queryParams;
        String string3 = intakeUrl;
        boolean $i$f$map = false;
        objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey() + "=" + it.getValue());
        }
        return string3 + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", (CharSequence)"?", null, (int)0, null, null, (int)60, null);
    }

    private final Map<String, String> buildHeaders(String requestId, String idempotencyKey2, DatadogContext context) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DD-API-KEY", (Object)context.getClientToken()), TuplesKt.to((Object)"DD-EVP-ORIGIN", (Object)context.getSource()), TuplesKt.to((Object)"DD-EVP-ORIGIN-VERSION", (Object)context.getSdkVersion()), TuplesKt.to((Object)"DD-REQUEST-ID", (Object)requestId)};
        Map headers = MapsKt.mutableMapOf((Pair[])pairArray);
        if (idempotencyKey2 != null) {
            headers.put("DD-IDEMPOTENCY-KEY", idempotencyKey2);
        }
        return headers;
    }

    private final String buildTags(String serviceName, String version, String sdkVersion, String env, String variant, RequestExecutionContext executionContext) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildTags_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildTags_u24lambda_u243.append("service:" + serviceName).append(",").append("version:" + version).append(",").append("sdk_version:" + sdkVersion).append(",").append("env:" + env);
        if (((CharSequence)variant).length() > 0) {
            $this$buildTags_u24lambda_u243.append(",").append("variant:" + variant);
        }
        if (executionContext.getPreviousResponseCode() != null) {
            $this$buildTags_u24lambda_u243.append(",").append("retry_count:" + executionContext.getAttemptNumber());
            $this$buildTags_u24lambda_u243.append(",").append("last_failure_status:" + executionContext.getPreviousResponseCode());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String idempotencyKey(byte[] byteArray) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] hashBytes = digest.digest(byteArray);
            Intrinsics.checkNotNullExpressionValue((Object)hashBytes, (String)"hashBytes");
            return com.datadog.android.internal.utils.ByteArrayExtKt.toHexString((byte[])hashBytes);
        }
        catch (DigestException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)idempotencyKey.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        catch (IllegalArgumentException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)idempotencyKey.2.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        catch (NoSuchAlgorithmException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)idempotencyKey.3.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        catch (NullPointerException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)idempotencyKey.4.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
        return null;
    }

    static {
        byte[] byArray = "\n".getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        PAYLOAD_SEPARATOR = byArray;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/rum/internal/net/RumRequestFactory$Companion;", "", "()V", "LAST_FAILURE_STATUS_KEY", "", "PAYLOAD_SEPARATOR", "", "RETRY_COUNT_KEY", "SHA1_GENERATION_ERROR_MESSAGE", "SHA1_NO_SUCH_ALGORITHM_EXCEPTION", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

