/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.tracking;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.Window;
import androidx.annotation.MainThread;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.instrumentation.gestures.GesturesTracker;
import com.datadog.android.rum.internal.tracking.FragmentLifecycleCallbacks;
import com.datadog.android.rum.internal.utils.ComponentPredicateExtKt;
import com.datadog.android.rum.internal.utils.ViewUtilsKt;
import com.datadog.android.rum.tracking.ComponentPredicate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u0000 22\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u00012BE\u0012 \u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\"\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00062\b\u0010(\u001a\u0004\u0018\u00010)H\u0017J\u0018\u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0006H\u0017J\u0018\u0010+\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0006H\u0017J\u0018\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\u0006H\u0016J\u0010\u00101\u001a\u00020$2\u0006\u0010-\u001a\u00020\u0002H\u0016R.\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u001eX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00063"}, d2={"Lcom/datadog/android/rum/internal/tracking/AndroidXFragmentLifecycleCallbacks;", "Lcom/datadog/android/rum/internal/tracking/FragmentLifecycleCallbacks;", "Landroidx/fragment/app/FragmentActivity;", "Landroidx/fragment/app/FragmentManager$FragmentLifecycleCallbacks;", "argumentsProvider", "Lkotlin/Function1;", "Landroidx/fragment/app/Fragment;", "", "", "", "componentPredicate", "Lcom/datadog/android/rum/tracking/ComponentPredicate;", "rumFeature", "Lcom/datadog/android/rum/internal/RumFeature;", "rumMonitor", "Lcom/datadog/android/rum/RumMonitor;", "(Lkotlin/jvm/functions/Function1;Lcom/datadog/android/rum/tracking/ComponentPredicate;Lcom/datadog/android/rum/internal/RumFeature;Lcom/datadog/android/rum/RumMonitor;)V", "getArgumentsProvider$dd_sdk_android_rum_release", "()Lkotlin/jvm/functions/Function1;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "getExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "executor$delegate", "Lkotlin/Lazy;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "getInternalLogger", "()Lcom/datadog/android/api/InternalLogger;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "getSdkCore", "()Lcom/datadog/android/api/feature/FeatureSdkCore;", "setSdkCore", "(Lcom/datadog/android/api/feature/FeatureSdkCore;)V", "onFragmentActivityCreated", "", "fm", "Landroidx/fragment/app/FragmentManager;", "f", "savedInstanceState", "Landroid/os/Bundle;", "onFragmentResumed", "onFragmentStopped", "register", "activity", "Lcom/datadog/android/api/SdkCore;", "resolveKey", "fragment", "unregister", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nAndroidXFragmentLifecycleCallbacks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidXFragmentLifecycleCallbacks.kt\ncom/datadog/android/rum/internal/tracking/AndroidXFragmentLifecycleCallbacks\n+ 2 ComponentPredicateExt.kt\ncom/datadog/android/rum/internal/utils/ComponentPredicateExtKt\n*L\n1#1,120:1\n25#2,3:121\n40#2,5:124\n28#2,10:129\n25#2,13:139\n*S KotlinDebug\n*F\n+ 1 AndroidXFragmentLifecycleCallbacks.kt\ncom/datadog/android/rum/internal/tracking/AndroidXFragmentLifecycleCallbacks\n*L\n82#1:121,3\n84#1:124,5\n82#1:129,10\n99#1:139,13\n*E\n"})
public class AndroidXFragmentLifecycleCallbacks
extends FragmentManager.FragmentLifecycleCallbacks
implements FragmentLifecycleCallbacks<FragmentActivity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<Fragment, Map<String, Object>> argumentsProvider;
    @NotNull
    private final ComponentPredicate<Fragment> componentPredicate;
    @NotNull
    private final RumFeature rumFeature;
    @NotNull
    private final RumMonitor rumMonitor;
    protected FeatureSdkCore sdkCore;
    @NotNull
    private final Lazy executor$delegate;
    public static final long STOP_VIEW_DELAY_MS = 200L;

    public AndroidXFragmentLifecycleCallbacks(@NotNull Function1<? super Fragment, ? extends Map<String, ? extends Object>> argumentsProvider, @NotNull ComponentPredicate<Fragment> componentPredicate, @NotNull RumFeature rumFeature2, @NotNull RumMonitor rumMonitor2) {
        Intrinsics.checkNotNullParameter(argumentsProvider, (String)"argumentsProvider");
        Intrinsics.checkNotNullParameter(componentPredicate, (String)"componentPredicate");
        Intrinsics.checkNotNullParameter((Object)rumFeature2, (String)"rumFeature");
        Intrinsics.checkNotNullParameter((Object)rumMonitor2, (String)"rumMonitor");
        this.argumentsProvider = argumentsProvider;
        this.componentPredicate = componentPredicate;
        this.rumFeature = rumFeature2;
        this.rumMonitor = rumMonitor2;
        this.executor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ScheduledExecutorService>(this){
            final /* synthetic */ AndroidXFragmentLifecycleCallbacks this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ScheduledExecutorService invoke() {
                return this.this$0.getSdkCore().createScheduledExecutorService("rum-fragmentx-lifecycle");
            }
        }));
    }

    @NotNull
    public final Function1<Fragment, Map<String, Object>> getArgumentsProvider$dd_sdk_android_rum_release() {
        return this.argumentsProvider;
    }

    @NotNull
    protected final FeatureSdkCore getSdkCore() {
        FeatureSdkCore featureSdkCore = this.sdkCore;
        if (featureSdkCore != null) {
            return featureSdkCore;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sdkCore");
        return null;
    }

    protected final void setSdkCore(@NotNull FeatureSdkCore featureSdkCore) {
        Intrinsics.checkNotNullParameter((Object)featureSdkCore, (String)"<set-?>");
        this.sdkCore = featureSdkCore;
    }

    private final ScheduledExecutorService getExecutor() {
        Lazy lazy = this.executor$delegate;
        return (ScheduledExecutorService)lazy.getValue();
    }

    private final InternalLogger getInternalLogger() {
        return this.sdkCore != null ? this.getSdkCore().getInternalLogger() : InternalLogger.Companion.getUNBOUND();
    }

    @Override
    public void register(@NotNull FragmentActivity activity, @NotNull SdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        this.setSdkCore((FeatureSdkCore)sdkCore);
        activity.getSupportFragmentManager().registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this, true);
    }

    @Override
    public void unregister(@NotNull FragmentActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        activity.getSupportFragmentManager().unregisterFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this);
    }

    @MainThread
    public void onFragmentActivityCreated(@NotNull FragmentManager fm, @NotNull Fragment f, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentActivityCreated(fm, f, savedInstanceState);
        Context context = f.getContext();
        if (f instanceof DialogFragment && context != null && this.sdkCore != null) {
            Dialog dialog = ((DialogFragment)f).getDialog();
            Window window = dialog != null ? dialog.getWindow() : null;
            GesturesTracker gesturesTracker = this.rumFeature.getActionTrackingStrategy$dd_sdk_android_rum_release().getGesturesTracker();
            gesturesTracker.startTracking(window, context, (SdkCore)this.getSdkCore());
        }
    }

    /*
     * WARNING - void declaration
     */
    @MainThread
    public void onFragmentResumed(@NotNull FragmentManager fm, @NotNull Fragment f) {
        void $this$runIfValid$iv;
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentResumed(fm, f);
        ComponentPredicate<Fragment> componentPredicate = this.componentPredicate;
        InternalLogger internalLogger$iv = this.getInternalLogger();
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept(f)) {
            try {
                Fragment it = f;
                boolean bl = false;
                Object key = this.resolveKey(it);
                ComponentPredicate<Fragment> $this$resolveViewName$iv = this.componentPredicate;
                boolean $i$f$resolveViewName = false;
                String customName$iv = $this$resolveViewName$iv.getViewName(f);
                CharSequence charSequence = customName$iv;
                String viewName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ViewUtilsKt.resolveViewUrl(f) : customName$iv;
                this.rumMonitor.startView(key, viewName, (Map)this.argumentsProvider.invoke((Object)it));
            }
            catch (Exception e$iv) {
                Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger$iv, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)ComponentPredicateExtKt.runIfValid.1.INSTANCE, (Throwable)e$iv, (boolean)false, null, (int)48, null);
            }
        }
    }

    @MainThread
    public void onFragmentStopped(@NotNull FragmentManager fm, @NotNull Fragment f) {
        Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        super.onFragmentStopped(fm, f);
        ConcurrencyExtKt.scheduleSafe((ScheduledExecutorService)this.getExecutor(), (String)"Delayed view stop", (long)200L, (TimeUnit)TimeUnit.MILLISECONDS, (InternalLogger)this.getSdkCore().getInternalLogger(), () -> AndroidXFragmentLifecycleCallbacks.onFragmentStopped$lambda$2(this, f));
    }

    @NotNull
    public Object resolveKey(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        return fragment;
    }

    /*
     * WARNING - void declaration
     */
    private static final void onFragmentStopped$lambda$2(AndroidXFragmentLifecycleCallbacks this$0, Fragment $f) {
        void $this$runIfValid$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$f, (String)"$f");
        ComponentPredicate<Fragment> componentPredicate = this$0.componentPredicate;
        InternalLogger internalLogger$iv = this$0.getInternalLogger();
        boolean $i$f$runIfValid = false;
        if ($this$runIfValid$iv.accept($f)) {
            try {
                Fragment it = $f;
                boolean bl = false;
                Object key = this$0.resolveKey(it);
                RumMonitor.DefaultImpls.stopView$default(this$0.rumMonitor, key, null, 2, null);
            }
            catch (Exception e$iv) {
                Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger$iv, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)ComponentPredicateExtKt.runIfValid.1.INSTANCE, (Throwable)e$iv, (boolean)false, null, (int)48, null);
            }
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/rum/internal/tracking/AndroidXFragmentLifecycleCallbacks$Companion;", "", "()V", "STOP_VIEW_DELAY_MS", "", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

