/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.tracking;

import android.content.res.Resources;
import android.view.View;
import android.view.ViewParent;
import androidx.recyclerview.widget.RecyclerView;
import com.datadog.android.core.internal.utils.NumberExtKt;
import com.datadog.android.rum.tracking.ViewAttributesProvider;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0096\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00060\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/rum/internal/tracking/JetpackViewAttributesProvider;", "Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "()V", "equals", "", "other", "", "extractAttributes", "", "view", "Landroid/view/View;", "attributes", "", "", "hashCode", "", "isDirectChildOfRecyclerView", "child", "resolveIdOrResourceName", "viewIdAsHexa", "dd-sdk-android-rum_release"})
public final class JetpackViewAttributesProvider
implements ViewAttributesProvider {
    @Override
    public void extractAttributes(@NotNull View view, @NotNull Map<String, Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        View child = view;
        for (ViewParent parent = view.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof RecyclerView && child != null && this.isDirectChildOfRecyclerView(child)) {
                int positionInAdapter = ((RecyclerView)parent).getChildAdapterPosition(child);
                Object object = positionInAdapter;
                attributes.put("action.target.parent.index", object);
                Map<String, Object> map = attributes;
                String string = "action.target.parent.classname";
                object = parent.getClass().getCanonicalName();
                map.put(string, object);
                map = attributes;
                string = "action.target.parent.resource_id";
                object = this.resolveIdOrResourceName((View)parent);
                map.put(string, object);
                break;
            }
            ViewParent viewParent = parent;
            child = viewParent instanceof View ? (View)viewParent : null;
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        return Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private final boolean isDirectChildOfRecyclerView(View child) {
        return child.getLayoutParams() instanceof RecyclerView.LayoutParams;
    }

    private final String resolveIdOrResourceName(View view) {
        String string;
        try {
            String string2 = view.getResources().getResourceEntryName(view.getId());
            if (string2 == null) {
                string2 = this.viewIdAsHexa(view);
            }
            string = string2;
        }
        catch (Resources.NotFoundException e) {
            string = this.viewIdAsHexa(view);
        }
        return string;
    }

    private final String viewIdAsHexa(View view) {
        return "0x" + NumberExtKt.toHexString((int)view.getId());
    }
}

