/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.vitals;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.scope.RumViewScope;
import com.datadog.android.rum.internal.vitals.VitalObserver;
import com.datadog.android.rum.internal.vitals.VitalReader;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/rum/internal/vitals/VitalReaderRunnable;", "Ljava/lang/Runnable;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "reader", "Lcom/datadog/android/rum/internal/vitals/VitalReader;", "observer", "Lcom/datadog/android/rum/internal/vitals/VitalObserver;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "periodMs", "", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/android/rum/internal/vitals/VitalReader;Lcom/datadog/android/rum/internal/vitals/VitalObserver;Ljava/util/concurrent/ScheduledExecutorService;J)V", "getExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "getObserver", "()Lcom/datadog/android/rum/internal/vitals/VitalObserver;", "getPeriodMs", "()J", "getReader", "()Lcom/datadog/android/rum/internal/vitals/VitalReader;", "getSdkCore", "()Lcom/datadog/android/api/feature/FeatureSdkCore;", "run", "", "dd-sdk-android-rum_release"})
public final class VitalReaderRunnable
implements Runnable {
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final VitalReader reader;
    @NotNull
    private final VitalObserver observer;
    @NotNull
    private final ScheduledExecutorService executor;
    private final long periodMs;

    public VitalReaderRunnable(@NotNull FeatureSdkCore sdkCore, @NotNull VitalReader reader, @NotNull VitalObserver observer, @NotNull ScheduledExecutorService executor2, long periodMs) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        this.sdkCore = sdkCore;
        this.reader = reader;
        this.observer = observer;
        this.executor = executor2;
        this.periodMs = periodMs;
    }

    @NotNull
    public final FeatureSdkCore getSdkCore() {
        return this.sdkCore;
    }

    @NotNull
    public final VitalReader getReader() {
        return this.reader;
    }

    @NotNull
    public final VitalObserver getObserver() {
        return this.observer;
    }

    @NotNull
    public final ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public final long getPeriodMs() {
        return this.periodMs;
    }

    @Override
    public void run() {
        Double data;
        RumContext rumContext = RumContext.Companion.fromFeatureContext(this.sdkCore.getFeatureContext("rum"));
        RumViewScope.RumViewType rumViewType = rumContext.getViewType();
        if (rumViewType == RumViewScope.RumViewType.FOREGROUND && (data = this.reader.readVitalData()) != null) {
            this.observer.onNewSample(data);
        }
        ConcurrencyExtKt.scheduleSafe((ScheduledExecutorService)this.executor, (String)"Vitals monitoring", (long)this.periodMs, (TimeUnit)TimeUnit.MILLISECONDS, (InternalLogger)this.sdkCore.getInternalLogger(), (Runnable)this);
    }
}

