/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.resource;

import android.content.Context;
import android.content.res.Resources;
import androidx.annotation.RawRes;
import com.datadog.android.Datadog;
import com.datadog.android.api.SdkCore;
import com.datadog.android.core.internal.utils.NumberExtKt;
import com.datadog.android.rum.resource.RumResourceInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\t\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"getAssetAsRumResource", "Ljava/io/InputStream;", "Landroid/content/Context;", "fileName", "", "accessMode", "", "sdkCore", "Lcom/datadog/android/api/SdkCore;", "getRawResAsRumResource", "id", "dd-sdk-android-rum_release"})
public final class ContextExtKt {
    @NotNull
    public static final InputStream getAssetAsRumResource(@NotNull Context $this$getAssetAsRumResource, @NotNull String fileName, int accessMode, @NotNull SdkCore sdkCore) {
        Intrinsics.checkNotNullParameter((Object)$this$getAssetAsRumResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        InputStream inputStream = $this$getAssetAsRumResource.getAssets().open(fileName, accessMode);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"assets.open(fileName, accessMode)");
        return new RumResourceInputStream(inputStream, "assets://" + fileName, sdkCore);
    }

    public static /* synthetic */ InputStream getAssetAsRumResource$default(Context context, String string, int n, SdkCore sdkCore, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        if ((n2 & 4) != 0) {
            sdkCore = Datadog.getInstance$default(null, (int)1, null);
        }
        return ContextExtKt.getAssetAsRumResource(context, string, n, sdkCore);
    }

    @NotNull
    public static final InputStream getRawResAsRumResource(@NotNull Context $this$getRawResAsRumResource, @RawRes int id, @NotNull SdkCore sdkCore) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getRawResAsRumResource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        try {
            object = $this$getRawResAsRumResource.getResources().getResourceName(id);
        }
        catch (Resources.NotFoundException e) {
            object = "res/0x" + NumberExtKt.toHexString((int)id);
        }
        Object resName = object;
        InputStream inputStream = $this$getRawResAsRumResource.getResources().openRawResource(id);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"resources.openRawResource(id)");
        Intrinsics.checkNotNullExpressionValue((Object)resName, (String)"resName");
        return new RumResourceInputStream(inputStream, (String)resName, sdkCore);
    }

    public static /* synthetic */ InputStream getRawResAsRumResource$default(Context context, int n, SdkCore sdkCore, int n2, Object object) {
        if ((n2 & 2) != 0) {
            sdkCore = Datadog.getInstance$default(null, (int)1, null);
        }
        return ContextExtKt.getRawResAsRumResource(context, n, sdkCore);
    }
}

